/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.traversal.TraversalSupport;
import org.apache.batik.dom.util.SoftDoublyIndexedTable;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AbstractDocument
extends AbstractParentNode
implements Document,
DocumentEvent,
DocumentTraversal,
Localizable {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages");
    protected transient DOMImplementation implementation;
    protected transient TraversalSupport traversalSupport;
    protected transient DocumentEventSupport documentEventSupport;
    protected transient boolean eventsEnabled;
    protected transient WeakHashMap elementsByTagNames;

    protected AbstractDocument() {
    }

    protected AbstractDocument(DOMImplementation dOMImplementation) {
        this.implementation = dOMImplementation;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 10) {
                return (DocumentType)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public void setDoctype(DocumentType documentType) {
        if (documentType != null) {
            this.appendChild(documentType);
            ((ExtendedNode)((Object)documentType)).setReadonly(true);
        }
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Object object;
        Node node2;
        if (node instanceof AbstractNode) {
            AbstractNode abstractNode = (AbstractNode)node;
            return bl ? abstractNode.deepExport(abstractNode.cloneNode(false), this) : abstractNode.export(abstractNode.cloneNode(false), this);
        }
        switch (node.getNodeType()) {
            case 1: {
                Element element = this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                node2 = element;
                if (!element.hasAttributes()) break;
                object = node.getAttributes();
                int n = object.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr = (Attr)object.item(n2);
                    if (attr.getSpecified()) {
                        element.setAttributeNodeNS((Attr)this.importNode(attr, true));
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                node2 = this.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                break;
            }
            case 3: {
                node2 = this.createTextNode(node.getNodeValue());
                bl = false;
                break;
            }
            case 4: {
                node2 = this.createCDATASection(node.getNodeValue());
                bl = false;
                break;
            }
            case 5: {
                node2 = this.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                node2 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                bl = false;
                break;
            }
            case 8: {
                node2 = this.createComment(node.getNodeValue());
                bl = false;
                break;
            }
            default: {
                throw this.createDOMException((short)9, "import.node", new Object[0]);
            }
        }
        if (bl) {
            object = node.getFirstChild();
            while (object != null) {
                node2.appendChild(this.importNode((Node)object, true));
                object = object.getNextSibling();
            }
        }
        return node2;
    }

    public Node cloneNode(boolean bl) {
        Document document = (Document)this.newNode();
        this.copyInto(document);
        if (bl) {
            Node node = this.getFirstChild();
            while (node != null) {
                document.appendChild(document.importNode(node, bl));
                node = node.getNextSibling();
            }
        }
        return document;
    }

    public AbstractParentNode.ElementsByTagName getElementsByTagName(Node node, String string, String string2) {
        if (this.elementsByTagNames == null) {
            return null;
        }
        SoftDoublyIndexedTable softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNames.get(node);
        if (softDoublyIndexedTable == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagName)softDoublyIndexedTable.get(string, string2);
    }

    public void putElementsByTagName(Node node, String string, String string2, AbstractParentNode.ElementsByTagName elementsByTagName) {
        SoftDoublyIndexedTable softDoublyIndexedTable;
        if (this.elementsByTagNames == null) {
            this.elementsByTagNames = new WeakHashMap(11);
        }
        if ((softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNames.get(node)) == null) {
            softDoublyIndexedTable = new SoftDoublyIndexedTable();
            this.elementsByTagNames.put(node, softDoublyIndexedTable);
        }
        softDoublyIndexedTable.put(string, string2, elementsByTagName);
    }

    public Event createEvent(String string) throws DOMException {
        if (this.documentEventSupport == null) {
            this.documentEventSupport = ((AbstractDOMImplementation)this.implementation).createDocumentEventSupport();
        }
        return this.documentEventSupport.createEvent(string);
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (this.traversalSupport == null) {
            this.traversalSupport = new TraversalSupport();
        }
        return this.traversalSupport.createNodeIterator(this, node, n, nodeFilter, bl);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return TraversalSupport.createTreeWalker(this, node, n, nodeFilter, bl);
    }

    public void detachNodeIterator(NodeIterator nodeIterator) {
        this.traversalSupport.detachNodeIterator(nodeIterator);
    }

    public void nodeToBeRemoved(Node node) {
        if (this.traversalSupport != null) {
            this.traversalSupport.nodeToBeRemoved(node);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this;
    }

    protected Node export(Node node, Document document) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node deepExport(Node node, Document document) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractDocument abstractDocument = (AbstractDocument)node;
        abstractDocument.implementation = this.implementation;
        abstractDocument.localizableSupport = new LocalizableSupport(RESOURCES);
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractDocument abstractDocument = (AbstractDocument)node;
        abstractDocument.implementation = this.implementation;
        abstractDocument.localizableSupport = new LocalizableSupport(RESOURCES);
        return node;
    }

    protected void checkChildType(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(s), node.getNodeName()});
            }
        }
        if (s == 1 && this.getDocumentElement() != null || s == 10 && this.getDoctype() != null) {
            throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(s), node.getNodeName()});
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.implementation.getClass().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES);
        Class<?> clazz = Class.forName((String)objectInputStream.readObject());
        try {
            Method method = clazz.getMethod("getDOMImplementation", null);
            this.implementation = (DOMImplementation)method.invoke(null, null);
        }
        catch (Exception exception) {
            try {
                this.implementation = (DOMImplementation)clazz.newInstance();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public abstract Element getElementById(String var1);

    public abstract Attr createAttributeNS(String var1, String var2) throws DOMException;

    public abstract Element createElementNS(String var1, String var2) throws DOMException;

    public abstract EntityReference createEntityReference(String var1) throws DOMException;

    public abstract Attr createAttribute(String var1) throws DOMException;

    public abstract ProcessingInstruction createProcessingInstruction(String var1, String var2) throws DOMException;

    public abstract CDATASection createCDATASection(String var1) throws DOMException;

    public abstract Comment createComment(String var1);

    public abstract Text createTextNode(String var1);

    public abstract DocumentFragment createDocumentFragment();

    public abstract Element createElement(String var1) throws DOMException;
}

