/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentChildNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public abstract class AbstractElement
extends AbstractParentChildNode
implements Element {
    protected NamedNodeMap attributes;

    protected AbstractElement() {
    }

    protected AbstractElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        if (!DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{string});
        }
    }

    public short getNodeType() {
        return 1;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes == null ? (this.attributes = this.createAttributes()) : this.attributes;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public boolean hasAttribute(String string) {
        return this.attributes != null && this.attributes.getNamedItem(string) != null;
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String string, String string2) throws DOMException {
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        Attr attr = this.getOwnerDocument().createAttribute(string);
        attr.setValue(string2);
        this.attributes.setNamedItem(attr);
    }

    public void removeAttribute(String string) throws DOMException {
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{string});
        }
        this.attributes.removeNamedItem(string);
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{attr.getName()});
        }
        return (Attr)this.attributes.removeNamedItem(attr.getNodeName());
    }

    public void normalize() {
        super.normalize();
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                namedNodeMap.item(n).normalize();
                --n;
            }
        }
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.attributes != null && this.attributes.getNamedItemNS(string, string2) != null;
    }

    public String getAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItemNS(string, string2);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        Attr attr = this.getOwnerDocument().createAttributeNS(string, string2);
        attr.setValue(string3);
        this.attributes.setNamedItemNS(attr);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
        }
        this.attributes.removeNamedItemNS(string, string2);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    protected void nodeAdded(Node node) {
        this.invalidateElementsByTagName(node);
    }

    protected void nodeToBeRemoved(Node node) {
        this.invalidateElementsByTagName(node);
    }

    private void invalidateElementsByTagName(Node node) {
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        String string = node.getNamespaceURI();
        String string2 = string == null ? node.getNodeName() : node.getLocalName();
        Node node2 = this;
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 1: 
                case 9: {
                    AbstractParentNode.ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(node2, string, string2);
                    if (elementsByTagName != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagName = abstractDocument.getElementsByTagName(node2, "*", string2)) != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagName = abstractDocument.getElementsByTagName(node2, string, "*")) != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagName = abstractDocument.getElementsByTagName(node2, "*", "*")) == null) break;
                    elementsByTagName.invalidate();
                }
            }
            node2 = node2.getParentNode();
        }
    }

    protected NamedNodeMap createAttributes() {
        return new NamedNodeHashMap();
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(n);
                if (abstractAttr.getSpecified()) {
                    Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                    if (abstractAttr instanceof AbstractAttrNS) {
                        abstractElement.setAttributeNodeNS(attr);
                    } else {
                        abstractElement.setAttributeNode(attr);
                    }
                }
                --n;
            }
        }
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(n);
                if (abstractAttr.getSpecified()) {
                    Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                    if (abstractAttr instanceof AbstractAttrNS) {
                        abstractElement.setAttributeNodeNS(attr);
                    } else {
                        abstractElement.setAttributeNode(attr);
                    }
                }
                --n;
            }
        }
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(n).cloneNode(false);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                } else {
                    abstractElement.setAttributeNode(abstractAttr);
                }
                --n;
            }
        }
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(n).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                } else {
                    abstractElement.setAttributeNode(abstractAttr);
                }
                --n;
            }
        }
        return node;
    }

    protected void checkChildType(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(node.getNodeType()), node.getNodeName()});
            }
        }
    }

    public void fireDOMAttrModifiedEvent(String string, String string2, String string3) {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled() && !string2.equals(string3)) {
            AbstractDocument abstractDocument2 = abstractDocument;
            MutationEvent mutationEvent = (MutationEvent)abstractDocument2.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMAttrModified", true, false, null, string2, string3, string, (short)1);
            this.dispatchEvent(mutationEvent);
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public String namespaceURI;
        public String name;
        public Node value;
        public Entry next;

        public Entry(int n, String string, String string2, Node node, Entry entry) {
            this.hash = n;
            this.namespaceURI = string;
            this.name = string2;
            this.value = node;
            this.next = entry;
        }

        public boolean match(String string, String string2) {
            if (this.namespaceURI != null ? !this.namespaceURI.equals(string) : string != null) {
                return false;
            }
            return this.name.equals(string2);
        }
    }

    public class NamedNodeHashMap
    implements NamedNodeMap,
    Serializable {
        protected static final int INITIAL_CAPACITY = 3;
        protected Entry[] table = new Entry[3];
        protected int count;

        public Node getNamedItem(String string) {
            if (string == null) {
                return null;
            }
            return this.get(null, string);
        }

        public Node setNamedItem(Node node) throws DOMException {
            if (node == null) {
                return null;
            }
            this.checkNode(node);
            return this.setNamedItem(null, node.getNodeName(), node);
        }

        public Node removeNamedItem(String string) throws DOMException {
            return this.removeNamedItemNS(null, string);
        }

        public Node item(int n) {
            if (n < 0 || n >= this.count) {
                return null;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.table.length) {
                Entry entry = this.table[n3];
                if (entry != null) {
                    do {
                        if (n2++ != n) continue;
                        return entry.value;
                    } while ((entry = entry.next) != null);
                }
                ++n3;
            }
            return null;
        }

        public int getLength() {
            return this.count;
        }

        public Node getNamedItemNS(String string, String string2) {
            return this.get(string, string2);
        }

        public Node setNamedItemNS(Node node) throws DOMException {
            String string;
            if (node == null) {
                return null;
            }
            return this.setNamedItem(string, (string = node.getNamespaceURI()) == null ? node.getNodeName() : node.getLocalName(), node);
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string2 == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            AbstractAttr abstractAttr = (AbstractAttr)this.remove(string, string2);
            if (abstractAttr == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
            }
            abstractAttr.setOwnerElement(null);
            AbstractElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr.getNodeValue(), "");
            return abstractAttr;
        }

        public Node setNamedItem(String string, String string2, Node node) throws DOMException {
            ((AbstractAttr)node).setOwnerElement(AbstractElement.this);
            AbstractAttr abstractAttr = (AbstractAttr)this.put(string, string2, node);
            if (abstractAttr != null) {
                abstractAttr.setOwnerElement(null);
                AbstractElement.this.fireDOMAttrModifiedEvent(string2, abstractAttr.getNodeValue(), node.getNodeValue());
            } else {
                AbstractElement.this.fireDOMAttrModifiedEvent(string2, "", node.getNodeValue());
            }
            return abstractAttr;
        }

        protected void checkNode(Node node) {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (AbstractElement.this.getOwnerDocument() != node.getOwnerDocument()) {
                throw AbstractElement.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{new Integer(node.getNodeType()), node.getNodeName()});
            }
            if (node.getNodeType() == 2 && ((Attr)node).getOwnerElement() != null) {
                throw AbstractElement.this.createDOMException((short)4, "inuse.attribute", new Object[]{node.getNodeName()});
            }
        }

        protected Node get(String string, String string2) {
            int n = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.hash == n && entry.match(string, string2)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }

        protected Node put(String string, String string2, Node node) {
            Entry entry;
            int n = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.match(string, string2)) {
                    Node node2 = entry2.value;
                    entry2.value = node;
                    return node2;
                }
                entry2 = entry2.next;
            }
            int n3 = this.table.length;
            if (this.count++ >= n3 * 3 >>> 2) {
                this.rehash();
                n2 = n % this.table.length;
            }
            this.table[n2] = entry = new Entry(n, string, string2, node, this.table[n2]);
            return null;
        }

        protected Node remove(String string, String string2) {
            int n = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = null;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.match(string, string2)) {
                    Node node = entry2.value;
                    if (entry == null) {
                        this.table[n2] = entry2.next;
                    } else {
                        entry.next = entry2.next;
                    }
                    --this.count;
                    return node;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
            return null;
        }

        protected void rehash() {
            Entry[] entryArray = this.table;
            this.table = new Entry[entryArray.length * 2 + 1];
            int n = entryArray.length - 1;
            while (n >= 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    Entry entry2 = entry;
                    entry = entry.next;
                    int n2 = entry2.hash % this.table.length;
                    entry2.next = this.table[n2];
                    this.table[n2] = entry2;
                }
                --n;
            }
        }

        protected int hashCode(String string, String string2) {
            int n = string == null ? 0 : string.hashCode();
            return n ^ string2.hashCode();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            int n = this.getLength();
            int n2 = n - 1;
            while (n2 >= 0) {
                AbstractAttr abstractAttr = (AbstractAttr)this.item(n2);
                abstractAttr.setOwnerDocument(AbstractElement.this.getOwnerDocument());
                abstractAttr.setOwnerElement(AbstractElement.this);
                --n2;
            }
        }
    }
}

