/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXSVGDocumentFactory
extends SAXDocumentFactory
implements SVGDocumentFactory {
    protected static final String DTDS = "org.apache.batik.dom.svg.resources.dtduris";
    protected static final String HTTP_CHARSET = "charset";
    protected static String uris;

    public SAXSVGDocumentFactory(String string) {
        super(SVGDOMImplementation.getDOMImplementation(), string);
    }

    public SAXSVGDocumentFactory(String string, boolean bl) {
        super(SVGDOMImplementation.getDOMImplementation(), string, bl);
    }

    public SVGOMDocument createDocument(String string) throws IOException {
        int n;
        int n2;
        ParsedURL parsedURL = new ParsedURL(string);
        InputStream inputStream = parsedURL.openStream(MimeTypeConstants.MIME_TYPES_SVG);
        InputSource inputSource = new InputSource(inputStream);
        String string2 = parsedURL.getContentType();
        int n3 = -1;
        if (string2 != null) {
            string2 = string2.toLowerCase();
            n3 = string2.indexOf(HTTP_CHARSET);
        }
        if (n3 != -1 && (n2 = string2.indexOf(61, n = n3 + HTTP_CHARSET.length())) != -1) {
            int n4 = string2.indexOf(44, ++n2);
            int n5 = string2.indexOf(59, n2);
            if (n5 != -1 && (n5 < n4 || n4 == -1)) {
                n4 = n5;
            }
            String string3 = n4 != -1 ? string2.substring(n2, n4) : string2.substring(n2);
            inputSource.setEncoding(string3.trim());
        }
        inputSource.setSystemId(string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
        try {
            sVGOMDocument.setURLObject(new URL(parsedURL.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Malformed URL: " + string);
        }
        return sVGOMDocument;
    }

    public SVGOMDocument createDocument(String string, InputStream inputStream) throws IOException {
        SVGOMDocument sVGOMDocument;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        try {
            sVGOMDocument = (SVGOMDocument)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
            if (string != null) {
                sVGOMDocument.setURLObject(new URL(string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return sVGOMDocument;
    }

    public SVGOMDocument createDocument(String string, Reader reader) throws IOException {
        SVGOMDocument sVGOMDocument;
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        try {
            sVGOMDocument = (SVGOMDocument)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
            if (string != null) {
                sVGOMDocument.setURLObject(new URL(string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return sVGOMDocument;
    }

    public Document createDocument(String string, String string2, String string3) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3);
    }

    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3, inputStream);
    }

    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3, reader);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            if (uris == null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(DTDS, Locale.getDefault());
                uris = resourceBundle.getString("uris");
            }
            if (uris.indexOf(string2) != -1) {
                return new InputSource(this.getClass().getResource("resources/svg10.dtd").toString());
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw new SAXException(missingResourceException);
        }
        return null;
    }
}

