/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.ARGBChannel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;

public class DisplacementMapRed
extends AbstractRed {
    private static final boolean TIME = false;
    private static final boolean USE_NN = false;
    private float scaleX;
    private float scaleY;
    private ARGBChannel xChannel;
    private ARGBChannel yChannel;
    CachableRed image;
    CachableRed offsets;
    int maxOffX;
    int maxOffY;
    RenderingHints hints;
    TileOffsets[] xOffsets;
    TileOffsets[] yOffsets;

    public DisplacementMapRed(CachableRed cachableRed, CachableRed cachableRed2, ARGBChannel aRGBChannel, ARGBChannel aRGBChannel2, float f, float f2, RenderingHints renderingHints) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException("Must provide xChannel");
        }
        if (aRGBChannel2 == null) {
            throw new IllegalArgumentException("Must provide yChannel");
        }
        this.offsets = cachableRed2;
        this.scaleX = f;
        this.scaleY = f2;
        this.xChannel = aRGBChannel;
        this.yChannel = aRGBChannel2;
        this.hints = renderingHints;
        this.maxOffX = (int)Math.ceil(f / 2.0f);
        this.maxOffY = (int)Math.ceil(f2 / 2.0f);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = cachableRed.getBounds();
        rectangle2.x -= this.maxOffX;
        rectangle2.width += 2 * this.maxOffX;
        rectangle2.y -= this.maxOffY;
        rectangle2.height += 2 * this.maxOffY;
        cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        this.image = cachableRed = new TileCacheRed(cachableRed);
        ColorModel colorModel = cachableRed.getColorModel();
        colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
        this.init(cachableRed, rectangle, colorModel, cachableRed.getSampleModel(), rectangle.x, rectangle.y, null);
        this.xOffsets = new TileOffsets[this.getNumXTiles()];
        this.yOffsets = new TileOffsets[this.getNumYTiles()];
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        Rectangle rectangle = writableRaster.getBounds();
        Raster raster = this.offsets.getData(rectangle);
        ColorModel colorModel = this.offsets.getColorModel();
        GraphicsUtil.coerceData((WritableRaster)raster, colorModel, false);
        TileOffsets tileOffsets = this.getXOffsets(n);
        TileOffsets tileOffsets2 = this.getYOffsets(n2);
        if (this.image.getColorModel().isAlphaPremultiplied()) {
            this.filterBL(raster, writableRaster, tileOffsets.tile, tileOffsets.off, tileOffsets2.tile, tileOffsets2.off);
        } else {
            this.filterBLPre(raster, writableRaster, tileOffsets.tile, tileOffsets.off, tileOffsets2.tile, tileOffsets2.off);
        }
        return writableRaster;
    }

    public TileOffsets getXOffsets(int n) {
        TileOffsets tileOffsets = this.xOffsets[n - this.getMinTileX()];
        if (tileOffsets != null) {
            return tileOffsets;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.image.getSampleModel();
        int n2 = singlePixelPackedSampleModel.getOffset(0, 0);
        int n3 = singlePixelPackedSampleModel.getWidth();
        int n4 = n3 + 2 * this.maxOffX;
        int n5 = this.getTileGridXOffset() + n * n3 - this.maxOffX - this.image.getTileGridXOffset();
        int n6 = n5 + n4 - 1;
        int n7 = (int)Math.floor((double)n5 / (double)n3);
        int n8 = (int)Math.floor((double)n6 / (double)n3);
        int n9 = n5 - n7 * n3;
        int n10 = n3;
        int n11 = (n8 + 1) * n3 - 1 - n6;
        this.xOffsets[n - this.getMinTileX()] = tileOffsets = new TileOffsets(n4, n2, 1, n9, n10, n11, n7, n8);
        return tileOffsets;
    }

    public TileOffsets getYOffsets(int n) {
        TileOffsets tileOffsets = this.yOffsets[n - this.getMinTileY()];
        if (tileOffsets != null) {
            return tileOffsets;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.image.getSampleModel();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        int n3 = singlePixelPackedSampleModel.getHeight();
        int n4 = n3 + 2 * this.maxOffY;
        int n5 = this.getTileGridYOffset() + n * n3 - this.maxOffY - this.image.getTileGridYOffset();
        int n6 = n5 + n4 - 1;
        int n7 = (int)Math.floor((double)n5 / (double)n3);
        int n8 = (int)Math.floor((double)n6 / (double)n3);
        int n9 = n5 - n7 * n3;
        int n10 = n3;
        int n11 = (n8 + 1) * n3 - 1 - n6;
        this.yOffsets[n - this.getMinTileY()] = tileOffsets = new TileOffsets(n4, 0, n2, n9, n10, n11, n7, n8);
        return tileOffsets;
    }

    public void filterBL(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = this.maxOffX;
        int n4 = this.maxOffY;
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - raster.getSampleModelTranslateX(), writableRaster.getMinY() - raster.getSampleModelTranslateY());
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        int n11 = n9 - n;
        int n12 = n10 - n;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n13 = this.xChannel.toInt() * 8;
        int n14 = this.yChannel.toInt() * 8;
        int n15 = n7;
        int n16 = n8;
        int n17 = (int)((double)this.scaleX / 255.0 * 32768.0);
        int n18 = (int)((double)this.scaleY / 255.0 * 32768.0);
        int n19 = this.maxOffX;
        int n20 = n - n19;
        int n21 = this.maxOffY;
        int n22 = n2 - n21;
        long l = System.currentTimeMillis();
        int n23 = nArray[0] - 1;
        int n24 = nArray3[0] - 1;
        int[] nArray7 = null;
        int n25 = n4;
        while (n25 < n6) {
            int n26 = n3;
            while (n26 < n5) {
                int n27;
                int n28;
                int n29;
                int n30 = nArray6[n16];
                int n31 = n17 * ((n30 >> n13 & 0xFF) - 127);
                int n32 = n18 * ((n30 >> n14 & 0xFF) - 127);
                int n33 = n26 + (n31 >> 15);
                int n34 = n25 + (n32 >> 15);
                if (n23 != nArray[n33] || n24 != nArray3[n34]) {
                    n23 = nArray[n33];
                    n24 = nArray3[n34];
                    nArray7 = ((DataBufferInt)this.image.getTile(n23, n24).getDataBuffer()).getBankData()[0];
                }
                void var38_40 = nArray7[nArray2[n33] + nArray4[n34]];
                int n35 = nArray[n33 + 1];
                int n36 = nArray3[n34 + 1];
                if (n24 == n36) {
                    if (n23 == n35) {
                        n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                        n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                        n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                    } else {
                        n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                        nArray7 = ((DataBufferInt)this.image.getTile(n35, n24).getDataBuffer()).getBankData()[0];
                        n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                        n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                        n23 = n35;
                    }
                } else if (n23 == n35) {
                    n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n23, n36).getDataBuffer()).getBankData()[0];
                    n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                    n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                    n24 = n36;
                } else {
                    nArray7 = ((DataBufferInt)this.image.getTile(n23, n36).getDataBuffer()).getBankData()[0];
                    n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n35, n36).getDataBuffer()).getBankData()[0];
                    n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n35, n24).getDataBuffer()).getBankData()[0];
                    n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                    n23 = n35;
                }
                int n37 = n31 & Short.MAX_VALUE;
                int n38 = n32 & Short.MAX_VALUE;
                int n39 = var38_40 >>> 16 & 0xFF00;
                int n40 = n29 >>> 16 & 0xFF00;
                int n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = n28 >>> 16 & 0xFF00;
                n40 = n27 >>> 16 & 0xFF00;
                int n42 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                int n43 = ((n41 << 15) + (n42 - n41) * n38 + 0x400000 & 0x7F800000) << 1;
                n39 = var38_40 >> 8 & 0xFF00;
                n40 = n29 >> 8 & 0xFF00;
                n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = n28 >> 8 & 0xFF00;
                n40 = n27 >> 8 & 0xFF00;
                n42 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n43 |= ((n41 << 15) + (n42 - n41) * n38 + 0x400000 & 0x7F800000) >>> 7;
                n39 = var38_40 & 0xFF00;
                n40 = n29 & 0xFF00;
                n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = n28 & 0xFF00;
                n40 = n27 & 0xFF00;
                n42 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n43 |= ((n41 << 15) + (n42 - n41) * n38 + 0x400000 & 0x7F800000) >>> 15;
                n39 = var38_40 << 8 & 0xFF00;
                n40 = n29 << 8 & 0xFF00;
                n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = n28 << 8 & 0xFF00;
                n40 = n27 << 8 & 0xFF00;
                n42 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                nArray5[n15] = n43 |= ((n41 << 15) + (n42 - n41) * n38 + 0x400000 & 0x7F800000) >>> 23;
                ++n26;
                ++n15;
                ++n16;
            }
            n15 += n11;
            n16 += n12;
            ++n25;
        }
    }

    public void filterBLPre(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = this.maxOffX;
        int n4 = this.maxOffY;
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - raster.getSampleModelTranslateX(), writableRaster.getMinY() - raster.getSampleModelTranslateY());
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        int n11 = n9 - n;
        int n12 = n10 - n;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n13 = this.xChannel.toInt() * 8;
        int n14 = this.yChannel.toInt() * 8;
        int n15 = n7;
        int n16 = n8;
        int n17 = (int)((double)this.scaleX / 255.0 * 32768.0);
        int n18 = (int)((double)this.scaleY / 255.0 * 32768.0);
        int n19 = this.maxOffX;
        int n20 = n - n19;
        int n21 = this.maxOffY;
        int n22 = n2 - n21;
        long l = System.currentTimeMillis();
        int n23 = nArray[0] - 1;
        int n24 = nArray3[0] - 1;
        int[] nArray7 = null;
        int n25 = n4;
        while (n25 < n6) {
            int n26 = n3;
            while (n26 < n5) {
                int n27;
                int n28;
                int n29;
                int n30 = nArray6[n16];
                int n31 = n17 * ((n30 >> n13 & 0xFF) - 127);
                int n32 = n18 * ((n30 >> n14 & 0xFF) - 127);
                int n33 = n26 + (n31 >> 15);
                int n34 = n25 + (n32 >> 15);
                if (n23 != nArray[n33] || n24 != nArray3[n34]) {
                    n23 = nArray[n33];
                    n24 = nArray3[n34];
                    nArray7 = ((DataBufferInt)this.image.getTile(n23, n24).getDataBuffer()).getBankData()[0];
                }
                void var38_40 = nArray7[nArray2[n33] + nArray4[n34]];
                int n35 = nArray[n33 + 1];
                int n36 = nArray3[n34 + 1];
                if (n24 == n36) {
                    if (n23 == n35) {
                        n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                        n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                        n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                    } else {
                        n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                        nArray7 = ((DataBufferInt)this.image.getTile(n35, n24).getDataBuffer()).getBankData()[0];
                        n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                        n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                        n23 = n35;
                    }
                } else if (n23 == n35) {
                    n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n23, n36).getDataBuffer()).getBankData()[0];
                    n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                    n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                    n24 = n36;
                } else {
                    nArray7 = ((DataBufferInt)this.image.getTile(n23, n36).getDataBuffer()).getBankData()[0];
                    n28 = nArray7[nArray2[n33] + nArray4[n34 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n35, n36).getDataBuffer()).getBankData()[0];
                    n27 = nArray7[nArray2[n33 + 1] + nArray4[n34 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n35, n24).getDataBuffer()).getBankData()[0];
                    n29 = nArray7[nArray2[n33 + 1] + nArray4[n34]];
                    n23 = n35;
                }
                int n37 = n31 & Short.MAX_VALUE;
                int n38 = n32 & Short.MAX_VALUE;
                int n39 = var38_40 >>> 16 & 0xFF00;
                int n40 = n29 >>> 16 & 0xFF00;
                int n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                int n42 = (n39 >> 8) * 65793 + 128 >> 8;
                int n43 = (n40 >> 8) * 65793 + 128 >> 8;
                n39 = n28 >>> 16 & 0xFF00;
                n40 = n27 >>> 16 & 0xFF00;
                int n44 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                int n45 = (n39 >> 8) * 65793 + 128 >> 8;
                int n46 = (n40 >> 8) * 65793 + 128 >> 8;
                int n47 = ((n41 << 15) + (n44 - n41) * n38 + 0x400000 & 0x7F800000) << 1;
                n39 = (var38_40 >> 16 & 0xFF) * n42 >> 8 & 0xFF00;
                n40 = (n29 >> 16 & 0xFF) * n43 >> 8 & 0xFF00;
                n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = (n28 >> 16 & 0xFF) * n45 >> 8 & 0xFF00;
                n40 = (n27 >> 16 & 0xFF) * n46 >> 8 & 0xFF00;
                n44 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n47 |= ((n41 << 15) + (n44 - n41) * n38 + 0x400000 & 0x7F800000) >>> 7;
                n39 = (var38_40 >> 8 & 0xFF) * n42 >> 8 & 0xFF00;
                n40 = (n29 >> 8 & 0xFF) * n43 >> 8 & 0xFF00;
                n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = (n28 >> 8 & 0xFF) * n45 >> 8 & 0xFF00;
                n40 = (n27 >> 8 & 0xFF) * n46 >> 8 & 0xFF00;
                n44 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n47 |= ((n41 << 15) + (n44 - n41) * n38 + 0x400000 & 0x7F800000) >>> 15;
                n39 = (var38_40 & 0xFF) * n42 >> 8 & 0xFF00;
                n40 = (n29 & 0xFF) * n43 >> 8 & 0xFF00;
                n41 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                n39 = (n28 & 0xFF) * n45 >> 8 & 0xFF00;
                n40 = (n27 & 0xFF) * n46 >> 8 & 0xFF00;
                n44 = n39 + ((n40 - n39) * n37 >> 15) & 0xFFFF;
                nArray5[n15] = n47 |= ((n41 << 15) + (n44 - n41) * n38 + 0x400000 & 0x7F800000) >>> 23;
                ++n26;
                ++n15;
                ++n16;
            }
            n15 += n11;
            n16 += n12;
            ++n25;
        }
    }

    public void filterNN(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = this.maxOffX;
        int n4 = this.maxOffY;
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        int n11 = n9 - n;
        int n12 = n10 - n;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n13 = this.xChannel.toInt() * 8;
        int n14 = this.yChannel.toInt() * 8;
        int n15 = (int)(this.scaleX * 65536.0f / 255.0f + 0.5f);
        int n16 = (int)(this.scaleY * 65536.0f / 255.0f + 0.5f);
        int n17 = n7;
        int n18 = n8;
        long l = System.currentTimeMillis();
        int n19 = n4;
        int n20 = nArray[0] - 1;
        int n21 = nArray3[0] - 1;
        int[] nArray7 = null;
        while (n19 < n6) {
            int n22 = n3;
            while (n22 < n5) {
                int n23 = nArray6[n18];
                int n24 = n15 * ((n23 >> n13 & 0xFF) - 127);
                int n25 = n16 * ((n23 >> n14 & 0xFF) - 127);
                int n26 = n22 + (n24 >> 16);
                int n27 = n19 + (n25 >> 16);
                if (n20 != nArray[n26] || n21 != nArray3[n27]) {
                    n20 = nArray[n26];
                    n21 = nArray3[n27];
                    nArray7 = ((DataBufferInt)this.image.getTile(n20, n21).getDataBuffer()).getBankData()[0];
                }
                nArray5[n17] = nArray7[nArray2[n26] + nArray4[n27]];
                ++n17;
                ++n18;
                ++n22;
            }
            n17 += n11;
            n18 += n12;
            ++n19;
        }
    }

    static class TileOffsets {
        int[] tile;
        int[] off;

        TileOffsets(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.tile = new int[n + 1];
            this.off = new int[n + 1];
            if (n7 == n8) {
                n5 -= n6;
            }
            int n9 = 0;
            while (n9 < n) {
                this.tile[n9] = n7++;
                this.off[n9] = n2 + n4 * n3;
                if (++n4 == n5) {
                    n4 = 0;
                    if (n7 == n8) {
                        n5 -= n6;
                    }
                }
                ++n9;
            }
            this.tile[n] = this.tile[n - 1];
            this.off[n] = this.off[n - 1];
        }
    }
}

