/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.BumpMap;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class SpecularLightingRed
extends AbstractTiledRed {
    private double ks;
    private double specularExponent;
    private Light light;
    private BumpMap bumpMap;
    private double scaleX;
    private double scaleY;
    private Rectangle litRegion;

    public SpecularLightingRed(double d, double d2, Light light, BumpMap bumpMap, Rectangle rectangle, double d3, double d4) {
        this.ks = d;
        this.specularExponent = d2;
        this.light = light;
        this.bumpMap = bumpMap;
        this.litRegion = rectangle;
        this.scaleX = d3;
        this.scaleY = d4;
        ColorModel colorModel = GraphicsUtil.Linear_sRGB_Unpre;
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = AbstractTiledRed.getDefaultTileSize();
        if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n, n2);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, rectangle.x, rectangle.y, null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    public void genRect(WritableRaster writableRaster) {
        double d = this.scaleX;
        double d2 = this.scaleY;
        double[] dArray = this.light.getColor();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n5 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n3 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
        int n6 = singlePixelPackedSampleModel.getScanlineStride();
        int n7 = n6 - n;
        int n8 = n5;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        double d3 = d * (double)n3;
        double d4 = d2 * (double)n4;
        double d5 = 0.0;
        double d6 = 0.0;
        double[][][] dArray2 = this.bumpMap.getNormalArray(n3, n4, n, n2);
        if (!this.light.isConstant()) {
            double[][] dArray3 = new double[n][3];
            n13 = 0;
            while (n13 < n2) {
                double[][] dArray4 = dArray2[n13];
                this.light.getLightRow(d3, d4 + (double)n13 * d2, d, n, dArray4, dArray3);
                n14 = 0;
                while (n14 < n) {
                    double[] dArray5 = dArray4[n14];
                    double[] dArray6 = dArray3[n14];
                    dArray6[2] = dArray6[2] + 1.0;
                    d6 = Math.sqrt(dArray6[0] * dArray6[0] + dArray6[1] * dArray6[1] + dArray6[2] * dArray6[2]);
                    if (d6 > 0.0) {
                        double d7 = 1.0 / d6;
                        dArray6[0] = dArray6[0] * d7;
                        dArray6[1] = dArray6[1] * d7;
                        dArray6[2] = dArray6[2] * d7;
                    }
                    d5 = 255.0 * this.ks * Math.pow(dArray5[0] * dArray6[0] + dArray5[1] * dArray6[1] + dArray5[2] * dArray6[2], this.specularExponent);
                    n9 = (int)(d5 * dArray[0]);
                    n10 = (int)(d5 * dArray[1]);
                    n11 = (int)(d5 * dArray[2]);
                    if ((n9 & 0xFFFFFF00) != 0) {
                        int n15 = n9 = (n9 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n10 & 0xFFFFFF00) != 0) {
                        int n16 = n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n11 & 0xFFFFFF00) != 0) {
                        n11 = (n11 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    n12 = n9 > n10 ? n9 : n10;
                    n12 = n12 > n11 ? n12 : n11;
                    nArray[n8++] = n12 << 24 | n9 << 16 | n10 << 8 | n11;
                    ++n14;
                }
                n8 += n7;
                ++n13;
            }
        } else {
            double[] dArray7 = new double[3];
            this.light.getLight(0.0, 0.0, 0.0, dArray7);
            dArray7[2] = dArray7[2] + 1.0;
            d6 = Math.sqrt(dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1] + dArray7[2] * dArray7[2]);
            if (d6 > 0.0) {
                dArray7[0] = dArray7[0] / d6;
                dArray7[1] = dArray7[1] / d6;
                dArray7[2] = dArray7[2] / d6;
            }
            n13 = 0;
            while (n13 < n2) {
                double[][] dArray8 = dArray2[n13];
                n14 = 0;
                while (n14 < n) {
                    double[] dArray9 = dArray8[n14];
                    d5 = 255.0 * this.ks * Math.pow(dArray9[0] * dArray7[0] + dArray9[1] * dArray7[1] + dArray9[2] * dArray7[2], this.specularExponent);
                    n9 = (int)(d5 * dArray[0]);
                    n10 = (int)(d5 * dArray[1]);
                    n11 = (int)(d5 * dArray[2]);
                    if ((n9 & 0xFFFFFF00) != 0) {
                        int n17 = n9 = (n9 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n10 & 0xFFFFFF00) != 0) {
                        int n18 = n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((n11 & 0xFFFFFF00) != 0) {
                        n11 = (n11 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    n12 = n9 > n10 ? n9 : n10;
                    n12 = n12 > n11 ? n12 : n11;
                    nArray[n8++] = n12 << 24 | n9 << 16 | n10 << 8 | n11;
                    ++n14;
                }
                n8 += n7;
                ++n13;
            }
        }
    }
}

