/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JPEGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-1, -40, -1, -32};
    static final String[] exts = new String[]{"jpeg", "jpg"};
    static final String[] mimeTypes = new String[]{"image/jpeg", "image/jpg"};

    public JPEGRegistryEntry() {
        super("JPEG", exts, mimeTypes, 0, signature);
    }

    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"JPEG", parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"JPEG"};
        }
        Thread thread = new Thread(){

            public void run() {
                Filter filter;
                try {
                    JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream2);
                    BufferedImage bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                    CachableRed cachableRed = GraphicsUtil.wrap(bufferedImage);
                    cachableRed = new Any2sRGBRed(cachableRed);
                    filter = new RedRable(cachableRed);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

