/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.Mark;

public class TextNode
extends AbstractGraphicsNode
implements Selectable {
    protected Point2D location = new Point2D.Float(0.0f, 0.0f);
    protected AttributedCharacterIterator aci;
    protected String text;
    protected Mark beginMark = null;
    protected Mark endMark = null;
    protected List textRuns;
    protected AttributedCharacterIterator[] chunkACIs = null;
    protected TextPainter textPainter = StrokingTextPainter.getInstance();
    private Rectangle2D geometryBounds;
    private Rectangle2D primitiveBounds;
    private Shape outline;

    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter == null ? StrokingTextPainter.getInstance() : textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public List getTextRuns() {
        return this.textRuns;
    }

    public void setTextRuns(List list) {
        this.textRuns = list;
    }

    public AttributedCharacterIterator[] getChunkACIs() {
        return this.chunkACIs;
    }

    public void setChunkACIs(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        this.chunkACIs = attributedCharacterIteratorArray;
    }

    public String getText() {
        if (this.text == null) {
            StringBuffer stringBuffer = new StringBuffer(this.aci.getEndIndex());
            char c = this.aci.first();
            while (c != '\uffff') {
                stringBuffer.append(c);
                c = this.aci.next();
            }
            this.text = stringBuffer.toString();
        }
        return this.text;
    }

    public void setLocation(Point2D point2D) {
        this.invalidateGeometryCache();
        this.location = point2D;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setAttributedCharacterIterator(AttributedCharacterIterator attributedCharacterIterator) {
        this.invalidateGeometryCache();
        this.aci = attributedCharacterIterator;
        this.text = null;
        this.textRuns = null;
        this.chunkACIs = null;
    }

    public AttributedCharacterIterator getAttributedCharacterIterator() {
        return this.aci;
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
        this.outline = null;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds == null && this.aci != null) {
            this.primitiveBounds = this.textPainter.getPaintedBounds(this);
        }
        return this.primitiveBounds;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null && this.aci != null) {
            this.geometryBounds = this.textPainter.getBounds(this);
        }
        return this.geometryBounds;
    }

    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D != null) {
            return rectangle2D.contains(point2D.getX(), point2D.getY());
        }
        return false;
    }

    public Shape getOutline() {
        if (this.outline == null && this.aci != null) {
            this.outline = this.textPainter.getDecoratedShape(this);
        }
        return this.outline;
    }

    public boolean selectAt(double d, double d2) {
        this.beginMark = this.textPainter.selectAt(d, d2, this.aci, this);
        return true;
    }

    public boolean selectTo(double d, double d2) {
        Mark mark = this.textPainter.selectTo(d, d2, this.beginMark, this.aci, this);
        boolean bl = false;
        if (mark != this.endMark) {
            this.endMark = mark;
            bl = true;
        }
        return bl;
    }

    public boolean selectAll(double d, double d2) {
        this.beginMark = this.textPainter.selectFirst(d, d2, this.aci, this);
        this.endMark = this.textPainter.selectLast(d, d2, this.aci, this);
        return true;
    }

    public Object getSelection() {
        int[] nArray = this.textPainter.getSelected(this.aci, this.beginMark, this.endMark);
        AttributedCharacterSpanIterator attributedCharacterSpanIterator = null;
        if (nArray != null && nArray.length > 1) {
            if (nArray[0] > nArray[1]) {
                int n = nArray[1];
                nArray[1] = nArray[0];
                nArray[0] = n;
            }
            attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(this.aci, nArray[0], nArray[1] + 1);
        }
        return attributedCharacterSpanIterator;
    }

    public Shape getHighlightShape() {
        Shape shape = this.textPainter.getHighlightShape(this.beginMark, this.endMark);
        AffineTransform affineTransform = this.getGlobalTransform();
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible) {
            super.paint(graphics2D);
        }
    }

    public void primitivePaint(Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        if (shape != null && !(shape instanceof GeneralPath)) {
            graphics2D.setClip(new GeneralPath(shape));
        }
        this.textPainter.paint(this, graphics2D);
    }

    public static final class Anchor
    implements Serializable {
        public static final int ANCHOR_START = 0;
        public static final int ANCHOR_MIDDLE = 1;
        public static final int ANCHOR_END = 2;
        public static final Anchor START = new Anchor(0);
        public static final Anchor MIDDLE = new Anchor(1);
        public static final Anchor END = new Anchor(2);
        private int type;

        private Anchor(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.type) {
                case 0: {
                    return START;
                }
                case 1: {
                    return MIDDLE;
                }
                case 2: {
                    return END;
                }
            }
            throw new Error("Unknown Anchor type");
        }
    }
}

