/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Map;
import org.apache.batik.gvt.font.AWTGVTGlyphVector;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;

public class AWTGVTFont
implements GVTFont {
    private Font awtFont;
    private Font tenPtFont;

    public AWTGVTFont(Font font) {
        this.awtFont = font;
        this.tenPtFont = this.awtFont.deriveFont(10.0f);
    }

    public AWTGVTFont(Map map) {
        this.awtFont = new Font(map);
        this.tenPtFont = this.awtFont.deriveFont(10.0f);
    }

    public AWTGVTFont(String string, int n, int n2) {
        this.awtFont = new Font(string, n, n2);
        this.tenPtFont = this.awtFont.deriveFont(10.0f);
    }

    public boolean canDisplay(char c) {
        return this.awtFont.canDisplay(c);
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        return this.awtFont.canDisplayUpTo(cArray, n, n2);
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        return this.awtFont.canDisplayUpTo(characterIterator, n, n2);
    }

    public int canDisplayUpTo(String string) {
        return this.awtFont.canDisplayUpTo(string);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        if (this.getSize() < 1.0f) {
            return new AWTGVTGlyphVector(this.tenPtFont.createGlyphVector(fontRenderContext, cArray), new AWTGVTFont(this.tenPtFont), this.getSize() / 10.0f, stringCharacterIterator);
        }
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, cArray), this, 1.0f, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        AttributedCharacterIterator attributedCharacterIterator;
        AttributedString attributedString;
        AWTGVTGlyphVector aWTGVTGlyphVector = this.getSize() < 1.0f ? new AWTGVTGlyphVector(this.tenPtFont.createGlyphVector(fontRenderContext, characterIterator), new AWTGVTFont(this.tenPtFont), this.getSize() / 10.0f, characterIterator) : new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, characterIterator), this, 1.0f, characterIterator);
        if (characterIterator instanceof AttributedCharacterIterator && ArabicTextHandler.containsArabic(attributedString = new AttributedString(attributedCharacterIterator = (AttributedCharacterIterator)characterIterator))) {
            String string = ArabicTextHandler.createSubstituteString(attributedCharacterIterator);
            return this.createGlyphVector(fontRenderContext, string);
        }
        return aWTGVTGlyphVector;
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray, CharacterIterator characterIterator) {
        if (this.getSize() < 1.0f) {
            return new AWTGVTGlyphVector(this.tenPtFont.createGlyphVector(fontRenderContext, nArray), new AWTGVTFont(this.tenPtFont), this.getSize() / 10.0f, characterIterator);
        }
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, nArray), this, 1.0f, characterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        if (this.getSize() < 1.0f) {
            return new AWTGVTGlyphVector(this.tenPtFont.createGlyphVector(fontRenderContext, string), new AWTGVTFont(this.tenPtFont), this.getSize() / 10.0f, stringCharacterIterator);
        }
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, string), this, 1.0f, stringCharacterIterator);
    }

    public GVTFont deriveFont(float f) {
        Font font = this.awtFont.deriveFont(f);
        return new AWTGVTFont(font);
    }

    public GVTLineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        if (this.getSize() < 1.0f) {
            return new GVTLineMetrics(this.tenPtFont.getLineMetrics(cArray, n, n2, fontRenderContext), this.getSize() / 10.0f);
        }
        return new GVTLineMetrics(this.awtFont.getLineMetrics(cArray, n, n2, fontRenderContext));
    }

    public GVTLineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        if (this.getSize() < 1.0f) {
            return new GVTLineMetrics(this.tenPtFont.getLineMetrics(characterIterator, n, n2, fontRenderContext), this.getSize() / 10.0f);
        }
        return new GVTLineMetrics(this.awtFont.getLineMetrics(characterIterator, n, n2, fontRenderContext));
    }

    public GVTLineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        if (this.getSize() < 1.0f) {
            return new GVTLineMetrics(this.tenPtFont.getLineMetrics(string, fontRenderContext), this.getSize() / 10.0f);
        }
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, fontRenderContext));
    }

    public GVTLineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        if (this.getSize() < 1.0f) {
            return new GVTLineMetrics(this.tenPtFont.getLineMetrics(string, n, n2, fontRenderContext), this.getSize() / 10.0f);
        }
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, n, n2, fontRenderContext));
    }

    public float getSize() {
        return this.awtFont.getSize2D();
    }

    public float getHKern(int n, int n2) {
        return 0.0f;
    }

    public float getVKern(int n, int n2) {
        return 0.0f;
    }

    public String toString() {
        return this.awtFont.getFontName();
    }
}

