/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;
    TextNode cachedNode;

    public static TextPainter getInstance() {
        return singleton;
    }

    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    private List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Object object;
        ArrayList arrayList = textNode.getTextRuns();
        if (arrayList != null) {
            return arrayList;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = textNode.getChunkACIs();
        if (attributedCharacterIteratorArray == null) {
            object = new AttributedString(attributedCharacterIterator);
            n = attributedCharacterIterator.getBeginIndex();
            while (n < attributedCharacterIterator.getEndIndex()) {
                ((AttributedString)object).addAttribute(GVTAttributedCharacterIterator.TextAttribute.CHAR_INDEX, new Integer(n), n, n + 1);
                ++n;
            }
            attributedCharacterIterator = ((AttributedString)object).getIterator();
            textNode.setAttributedCharacterIterator(attributedCharacterIterator);
            attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
            int n2 = 0;
            while (n2 < attributedCharacterIteratorArray.length) {
                attributedCharacterIteratorArray[n2] = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[n2], this.fontRenderContext);
                attributedCharacterIteratorArray[n2] = this.createModifiedACIForFontMatching(textNode, attributedCharacterIteratorArray[n2]);
                ++n2;
            }
            textNode.setChunkACIs(attributedCharacterIteratorArray);
        }
        arrayList = new ArrayList();
        n = 0;
        Point2D point2D = new Point2D.Float(0.0f, 0.0f);
        int n3 = 0;
        do {
            attributedCharacterIteratorArray[n3].first();
            object = this.getTextChunk(textNode, attributedCharacterIteratorArray[n3], arrayList, n, point2D);
            attributedCharacterIteratorArray[n3].first();
            if (object != null) {
                this.adjustChunkOffsets(arrayList, ((TextChunk)object).advance, ((TextChunk)object).begin, ((TextChunk)object).end);
                n = ((TextChunk)object).end;
                point2D = ((TextChunk)object).advance;
            }
            attributedCharacterIteratorArray[n3].first();
        } while (object != null && ++n3 < attributedCharacterIteratorArray.length);
        textNode.setTextRuns(arrayList);
        return arrayList;
    }

    private AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        attributedCharacterIterator.first();
        while (attributedCharacterIterator.current() != '\uffff') {
            int n2;
            int n3 = attributedCharacterIterator.getIndex();
            boolean bl = true;
            n = 1;
            TextPath textPath = null;
            while (bl) {
                n2 = attributedCharacterIterator.getRunStart(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
                int n4 = attributedCharacterIterator.getRunLimit(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
                AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n4);
                attributedCharacterSpanIterator.first();
                Float f = (Float)attributedCharacterSpanIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float f2 = (Float)attributedCharacterSpanIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                TextPath textPath2 = (TextPath)attributedCharacterSpanIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
                boolean bl2 = bl = n != 0 || (f == null || f.isNaN()) && (f2 == null || f2.isNaN());
                if (textPath == null && textPath2 != null && n == 0) {
                    bl = false;
                }
                if (bl) {
                    textPath = textPath2;
                    attributedCharacterIterator.setIndex(n4);
                    if (attributedCharacterIterator.current() == '\uffff') {
                        break;
                    }
                } else {
                    attributedCharacterIterator.setIndex(n2);
                }
                n = 0;
            }
            n2 = attributedCharacterIterator.getIndex();
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n3, n2);
            attributedCharacterIterator.setIndex(n2);
            arrayList.add(attributedCharacterSpanIterator);
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            attributedCharacterIteratorArray[n] = (AttributedCharacterIterator)iterator.next();
            ++n;
        }
        return attributedCharacterIteratorArray;
    }

    private TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, List list, int n, Point2D point2D) {
        int n2 = n;
        boolean bl = true;
        Point2D point2D2 = point2D;
        Point2D point2D3 = textNode.getLocation();
        if (attributedCharacterIterator.current() != '\uffff') {
            int n3 = attributedCharacterIterator.getIndex();
            TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
            TextPath textPath2 = null;
            if (n3 > 0) {
                attributedCharacterIterator.setIndex(n3 - 1);
                textPath2 = (TextPath)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
                attributedCharacterIterator.setIndex(n3);
            }
            if (textPath2 != textPath) {
                point2D2 = new Point2D.Float(0.0f, 0.0f);
            }
            boolean bl2 = true;
            TextPath textPath3 = null;
            Point2D point2D4 = null;
            do {
                int n4 = attributedCharacterIterator.getRunStart(extendedAtts);
                int n5 = attributedCharacterIterator.getRunLimit(extendedAtts);
                AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n4, n5);
                attributedCharacterSpanIterator.first();
                Float f = (Float)attributedCharacterSpanIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float f2 = (Float)attributedCharacterSpanIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                TextPath textPath4 = (TextPath)attributedCharacterSpanIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
                boolean bl3 = bl = bl2 || (f == null || f.isNaN()) && (f2 == null || f2.isNaN());
                if (textPath3 == null && textPath4 != null && !bl2) {
                    bl = false;
                }
                if (bl) {
                    Point2D.Float float_ = textPath4 == null ? (textPath3 != null && point2D4 != null ? new Point2D.Float((float)point2D4.getX(), (float)point2D4.getY()) : new Point2D.Float((float)(point2D3.getX() + point2D2.getX()), (float)(point2D3.getY() + point2D2.getY()))) : new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
                    TextSpanLayout textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterSpanIterator, float_, this.fontRenderContext);
                    TextRun textRun = new TextRun(textSpanLayout, attributedCharacterSpanIterator, bl2);
                    list.add(textRun);
                    Point2D point2D5 = textSpanLayout.getAdvance2D();
                    point2D2 = new Point2D.Float((float)(point2D2.getX() + point2D5.getX()), (float)(point2D2.getY() + point2D5.getY()));
                    ++n2;
                    textPath3 = textPath4;
                    point2D4 = textSpanLayout.getTextPathAdvance();
                    if (attributedCharacterIterator.setIndex(n5) == '\uffff') {
                        break;
                    }
                } else {
                    attributedCharacterIterator.setIndex(n4);
                }
                bl2 = false;
            } while (bl);
            return new TextChunk(n, n2, point2D2);
        }
        return null;
    }

    private AttributedCharacterIterator createModifiedACIForFontMatching(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex());
        AttributedString attributedString = new AttributedString(attributedCharacterSpanIterator);
        attributedCharacterIterator.first();
        boolean bl = true;
        while (bl) {
            Object object;
            int n;
            int n2 = attributedCharacterIterator.getRunStart(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator2 = new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n = attributedCharacterIterator.getRunLimit(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER));
            Vector vector = (Vector)attributedCharacterSpanIterator2.getAttributes().get(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
            if (vector == null) {
                return attributedCharacterIterator;
            }
            Vector<Object> vector2 = new Vector<Object>();
            int n3 = 0;
            while (n3 < vector.size()) {
                object = (GVTFontFamily)vector.get(n3);
                if (object instanceof UnresolvedFontFamily) {
                    GVTFontFamily gVTFontFamily = FontFamilyResolver.resolve((UnresolvedFontFamily)object);
                    if (gVTFontFamily != null) {
                        vector2.add(gVTFontFamily);
                    }
                } else {
                    vector2.add(object);
                }
                ++n3;
            }
            if (vector2.size() == 0) {
                vector2.add(FontFamilyResolver.defaultFont);
            }
            object = (Float)attributedCharacterSpanIterator2.getAttributes().get(TextAttribute.SIZE);
            float f = 12.0f;
            if (object != null) {
                f = ((Float)object).floatValue();
            }
            Vector<GVTFont> vector3 = new Vector<GVTFont>();
            int n4 = 0;
            while (n4 < vector2.size()) {
                GVTFont gVTFont = ((GVTFontFamily)vector2.get(n4)).deriveFont(f, attributedCharacterSpanIterator2);
                vector3.add(gVTFont);
                ++n4;
            }
            int n5 = n - n2;
            boolean[] blArray = new boolean[n5];
            int n6 = 0;
            while (n6 < n5) {
                blArray[n6] = false;
                ++n6;
            }
            int n7 = 0;
            while (n7 < vector3.size()) {
                GVTFont gVTFont = (GVTFont)vector3.get(n7);
                int n8 = attributedCharacterSpanIterator2.getBeginIndex();
                while (n8 < attributedCharacterSpanIterator2.getEndIndex()) {
                    int n9;
                    int n10 = gVTFont.canDisplayUpTo(attributedCharacterSpanIterator2, n8, n);
                    if (n10 == -1) {
                        n9 = n8;
                        while (n9 < n) {
                            if (!blArray[n9 - n2]) {
                                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT, gVTFont, n9, n9 + 1);
                                blArray[n9 - n2] = true;
                            }
                            ++n9;
                        }
                        n8 = attributedCharacterSpanIterator2.getEndIndex();
                        continue;
                    }
                    if (n10 > n8) {
                        n9 = n8;
                        while (n9 < n10) {
                            if (!blArray[n9 - n2]) {
                                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT, gVTFont, n9, n9 + 1);
                                blArray[n9 - n2] = true;
                            }
                            ++n9;
                        }
                        n8 = n10 + 1;
                        continue;
                    }
                    ++n8;
                }
                ++n7;
            }
            int n11 = 0;
            while (n11 < n5) {
                if (!blArray[n11]) {
                    GVTFontFamily gVTFontFamily = FontFamilyResolver.getFamilyThatCanDisplay(attributedCharacterSpanIterator2.setIndex(n2 + n11));
                    if (gVTFontFamily != null) {
                        GVTFont gVTFont = gVTFontFamily.deriveFont(f, attributedCharacterSpanIterator2);
                        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT, gVTFont, n2 + n11, n2 + n11 + 1);
                    } else {
                        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT, vector3.get(0), n2 + n11, n2 + n11 + 1);
                    }
                }
                ++n11;
            }
            if (attributedCharacterIterator.setIndex(n) != '\uffff') continue;
            bl = false;
        }
        return attributedString.getIterator();
    }

    private void adjustChunkOffsets(List list, Point2D point2D, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            TextRun textRun = (TextRun)list.get(n3);
            int n4 = textRun.getAnchorType();
            float f = 0.0f;
            float f2 = 0.0f;
            switch (n4) {
                case 1: {
                    f = (float)(-point2D.getX() / 2.0);
                    f2 = (float)(-point2D.getY() / 2.0);
                    break;
                }
                case 2: {
                    f = (float)(-point2D.getX());
                    f2 = (float)(-point2D.getY());
                    break;
                }
            }
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Point2D point2D2 = textSpanLayout.getOffset();
            if (textSpanLayout.isVertical()) {
                textSpanLayout.setOffset(new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY() + f2));
            } else {
                textSpanLayout.setOffset(new Point2D.Float((float)point2D2.getX() + f, (float)point2D2.getY()));
            }
            ++n3;
        }
    }

    private void paintDecorations(List list, Graphics2D graphics2D, int n) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null) {
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(rectangle2D);
                }
                if (stroke != null && paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(rectangle2D);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangle2D);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangle2D);
            }
        }
    }

    private void paintTextRuns(List list, Graphics2D graphics2D) {
        int n = 0;
        while (n < list.size()) {
            TextRun textRun = (TextRun)list.get(n);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            textRun.getLayout().draw(graphics2D);
            ++n;
        }
    }

    protected Rectangle2D getBounds(TextNode textNode, boolean bl, boolean bl2) {
        Shape shape;
        Rectangle2D rectangle2D = this.getOutline(textNode, bl).getBounds2D();
        if (bl2 && (shape = this.getStrokeOutline(textNode, bl)) != null) {
            rectangle2D = rectangle2D.createUnion(shape.getBounds2D());
        }
        return rectangle2D;
    }

    protected Shape getOutline(TextNode textNode, boolean bl) {
        Shape shape;
        Object object;
        Object object2;
        Shape shape2 = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            object2 = (TextRun)list.get(n);
            object = ((TextRun)object2).getLayout();
            shape = new GeneralPath(object.getOutline());
            if (shape2 == null) {
                shape2 = shape;
            } else {
                ((Path2D)shape2).setWindingRule(1);
                ((Path2D)shape2).append(shape, false);
            }
            ++n;
        }
        if (bl) {
            object2 = this.getDecorationOutline(list, 1);
            object = this.getDecorationOutline(list, 2);
            shape = this.getDecorationOutline(list, 4);
            if (object2 != null) {
                if (shape2 == null) {
                    shape2 = new GeneralPath((Shape)object2);
                } else {
                    ((Path2D)shape2).setWindingRule(1);
                    ((Path2D)shape2).append((Shape)object2, false);
                }
            }
            if (object != null) {
                if (shape2 == null) {
                    shape2 = new GeneralPath((Shape)object);
                } else {
                    ((Path2D)shape2).setWindingRule(1);
                    ((Path2D)shape2).append((Shape)object, false);
                }
            }
            if (shape != null) {
                if (shape2 == null) {
                    shape2 = new GeneralPath(shape);
                } else {
                    ((Path2D)shape2).setWindingRule(1);
                    ((Path2D)shape2).append(shape, false);
                }
            }
        }
        return shape2;
    }

    protected Shape getStrokeOutline(TextNode textNode, boolean bl) {
        Object object;
        Object object2;
        Shape shape;
        Path2D path2D = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            shape = null;
            object2 = (TextRun)list.get(n);
            object = ((TextRun)object2).getACI();
            object.first();
            TextSpanLayout textSpanLayout = ((TextRun)object2).getLayout();
            Stroke stroke = (Stroke)object.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
            Paint paint = (Paint)object.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
            if (stroke != null && paint != null) {
                Shape shape2 = textSpanLayout.getOutline();
                shape = stroke.createStrokedShape(shape2);
            }
            if (shape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(shape);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append(shape, false);
                }
            }
            ++n;
        }
        if (bl) {
            shape = this.getDecorationStrokeOutline(list, 1);
            object2 = this.getDecorationStrokeOutline(list, 2);
            object = this.getDecorationStrokeOutline(list, 4);
            if (shape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(shape);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append(shape, false);
                }
            }
            if (object2 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath((Shape)object2);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append((Shape)object2, false);
                }
            }
            if (object != null) {
                if (path2D == null) {
                    path2D = new GeneralPath((Shape)object);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append((Shape)object, false);
                }
            }
        }
        return path2D;
    }

    private Shape getDecorationOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangle2D);
                } else {
                    path2D.append(rectangle2D, false);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangle2D);
            } else {
                path2D.append(rectangle2D, false);
            }
        }
        return path2D;
    }

    private Shape getDecorationStrokeOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null && stroke != null && paint2 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(stroke.createStrokedShape(rectangle2D));
                } else {
                    path2D.append(stroke.createStrokedShape(rectangle2D), false);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null && stroke != null && paint2 != null) {
            if (path2D == null) {
                path2D = new GeneralPath(stroke.createStrokedShape(rectangle2D));
            } else {
                path2D.append(stroke.createStrokedShape(rectangle2D), false);
            }
        }
        return path2D;
    }

    protected Mark hitTest(double d, double d2, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode) {
        Object object;
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            object = (TextRun)list.get(n);
            TextSpanLayout textSpanLayout = ((TextRun)object).getLayout();
            TextHit textHit = textSpanLayout.hitTestChar((float)d, (float)d2);
            if (textHit != null && textSpanLayout.getBounds().contains(d, d2)) {
                textHit.setTextNode(textNode);
                textHit.setFontRenderContext(this.fontRenderContext);
                this.cachedMark = new BasicTextPainter.BasicMark(d, d2, textSpanLayout, textHit);
                this.cachedNode = textNode;
                return this.cachedMark;
            }
            ++n;
        }
        if (this.cachedNode != textNode) {
            object = new TextHit(0, false);
            ((TextHit)object).setTextNode(textNode);
            ((TextHit)object).setFontRenderContext(this.fontRenderContext);
            this.cachedMark = new BasicTextPainter.BasicMark(d, d2, ((TextRun)list.get(0)).getLayout(), (TextHit)object);
            this.cachedNode = textNode;
        }
        return this.cachedMark;
    }

    public Mark selectFirst(double d, double d2, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode) {
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        attributedCharacterIterator.first();
        int n = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CHAR_INDEX);
        TextHit textHit = new TextHit(n, false);
        textHit.setTextNode(textNode);
        textHit.setFontRenderContext(this.fontRenderContext);
        this.cachedMark = new BasicTextPainter.BasicMark(d, d2, ((TextRun)list.get(0)).getLayout(), textHit);
        this.cachedNode = textNode;
        return this.cachedMark;
    }

    public Mark selectLast(double d, double d2, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode) {
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        TextSpanLayout textSpanLayout = ((TextRun)list.get(list.size() - 1)).getLayout();
        int n = textSpanLayout.getGlyphCount() - 1;
        attributedCharacterIterator.last();
        int n2 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CHAR_INDEX);
        TextHit textHit = new TextHit(n2, false);
        textHit.setTextNode(textNode);
        textHit.setFontRenderContext(this.fontRenderContext);
        this.cachedMark = new BasicTextPainter.BasicMark(d, d2, textSpanLayout, textHit);
        this.cachedNode = textNode;
        return this.cachedMark;
    }

    public int[] getSelected(AttributedCharacterIterator attributedCharacterIterator, Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        TextSpanLayout textSpanLayout = basicMark2.getLayout();
        TextSpanLayout textSpanLayout2 = basicMark.getLayout();
        int n = textSpanLayout.getGlyphIndex(nArray[0]);
        int n2 = textSpanLayout2.getGlyphIndex(nArray[1]);
        int n3 = textSpanLayout.getCharacterCount(n, n);
        int n4 = textSpanLayout2.getCharacterCount(n2, n2);
        if (n3 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n3 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n3 - 1);
            }
        }
        if (n4 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n4 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n4 - 1);
            }
        }
        return nArray;
    }

    public Shape getHighlightShape(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        int n = basicMark2.getHit().getCharIndex();
        int n2 = basicMark.getHit().getCharIndex();
        TextSpanLayout textSpanLayout = null;
        TextSpanLayout textSpanLayout2 = null;
        if (basicMark2 != null && basicMark != null) {
            textSpanLayout = basicMark2.getLayout();
            textSpanLayout2 = basicMark.getLayout();
        }
        if (textSpanLayout == null || textSpanLayout2 == null) {
            return null;
        }
        TextNode textNode = basicMark2.getHit().getTextNode();
        List list = this.getTextRuns(textNode, textNode.getAttributedCharacterIterator());
        GeneralPath generalPath = new GeneralPath();
        int n3 = 0;
        while (n3 < list.size()) {
            TextRun textRun = (TextRun)list.get(n3);
            TextSpanLayout textSpanLayout3 = textRun.getLayout();
            Shape shape = textSpanLayout3.getHighlightShape(n, n2);
            if (shape != null && !shape.getBounds().isEmpty()) {
                generalPath.append(shape, false);
            }
            ++n3;
        }
        return generalPath;
    }

    static {
        extendedAtts.add(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
        extendedAtts.add(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        extendedAtts.add(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        singleton = new StrokingTextPainter();
    }

    class TextRun {
        private AttributedCharacterIterator aci;
        private TextSpanLayout layout;
        private int anchorType;
        private boolean firstRunInChunk;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            this.anchorType = 0;
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE) == GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n, int n2, Point2D point2D) {
            this.begin = n;
            this.end = n2;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

