/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    private GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    private FontRenderContext frc;
    private AffineTransform transform;
    private Point2D advance;
    private Point2D offset;
    private Point2D prevCharPosition;
    private TextPath textPath;
    private Point2D textPathAdvance;
    public static final float eps = 1.0E-5f;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = attributedCharacterIterator;
        this.frc = fontRenderContext;
        this.offset = point2D;
        this.transform = null;
        this.font = this.getFont(this.aci);
        this.metrics = this.font.getLineMetrics(this.aci, this.aci.getBeginIndex(), this.aci.getEndIndex(), fontRenderContext);
        this.gv = null;
        this.aci.first();
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(fontRenderContext, this.font.getSize(), this.aci);
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(fontRenderContext, this.aci);
        }
        this.gv.performDefaultLayout();
        this.doExplicitGlyphLayout(false);
        this.adjustTextSpacing();
        this.doPathLayout(false);
    }

    public void draw(Graphics2D graphics2D) {
        if (this.transform != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(this.transform);
            this.gv.draw(graphics2D, this.aci);
            graphics2D.setTransform(affineTransform);
        } else {
            this.gv.draw(graphics2D, this.aci);
        }
    }

    public Shape getOutline() {
        Shape shape = this.gv.getOutline();
        if (this.transform != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        return shape;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D point2D) {
        this.offset = point2D;
        this.gv.performDefaultLayout();
        this.doExplicitGlyphLayout(true);
        this.adjustTextSpacing();
        this.doPathLayout(true);
    }

    public Shape getDecorationOutline(int n) {
        Shape shape = new GeneralPath();
        if ((n & 1) != 0) {
            shape.append(this.getUnderlineShape(), false);
        }
        if ((n & 2) != 0) {
            shape.append(this.getStrikethroughShape(), false);
        }
        if ((n & 4) != 0) {
            shape.append(this.getOverlineShape(), false);
        }
        if (this.transform != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        return shape;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.gv.getVisualBounds();
        if (this.transform != null) {
            rectangle2D = this.transform.createTransformedShape(rectangle2D).getBounds2D();
        }
        return rectangle2D;
    }

    public Rectangle2D getDecoratedBounds() {
        return this.getBounds().createUnion(this.getDecorationOutline(7).getBounds2D());
    }

    public Point2D getAdvance2D() {
        return this.advance;
    }

    public Point2D getTextPathAdvance() {
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int n) {
        int n2 = this.aci.getBeginIndex();
        int n3 = this.getGlyphCount();
        int n4 = 0;
        while (n4 < n3) {
            this.aci.setIndex(n2);
            int n5 = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CHAR_INDEX);
            if (n == n5) {
                return n4;
            }
            n2 += this.getCharacterCount(n4, n4);
            ++n4;
        }
        return -1;
    }

    public Shape getHighlightShape(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        GeneralPath generalPath = null;
        int n4 = this.aci.getBeginIndex();
        int n5 = this.getGlyphCount();
        boolean bl = this.isGlyphOrientationAuto();
        int n6 = 90;
        if (!bl) {
            n6 = this.getGlyphOrientationAngle();
        }
        Point2D.Float[] floatArray = new Point2D.Float[2 * n5];
        Point2D.Float[] floatArray2 = new Point2D.Float[2 * n5];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            Shape shape;
            char c = this.aci.setIndex(n4);
            int n9 = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CHAR_INDEX);
            if (n9 >= n && n9 <= n2 && (shape = this.gv.getGlyphLogicalBounds(n8)) != null) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                float[] fArray = new float[6];
                int n10 = 0;
                int n11 = -1;
                PathIterator pathIterator = shape.getPathIterator(null);
                Point2D.Float float_ = null;
                if (this.isVertical() && bl) {
                    n6 = this.isLatinChar(c) ? 90 : 0;
                }
                while (!pathIterator.isDone()) {
                    n11 = pathIterator.currentSegment(fArray);
                    if (n11 == 0 || n11 == 1) {
                        if (n10 > 4) break;
                        if (n10 == 4) {
                            if (float_ == null || float_.x != fArray[0] || float_.y != fArray[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                            if (n10 == 0) {
                                float_ = float_2;
                            }
                            block0 : switch (n6) {
                                case 0: {
                                    switch (n10) {
                                        case 0: {
                                            floatArray2[n7] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7 + 1] = float_2;
                                        }
                                    }
                                    break;
                                }
                                case 90: {
                                    switch (n10) {
                                        case 0: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray2[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7] = float_2;
                                        }
                                    }
                                    break;
                                }
                                case 180: {
                                    switch (n10) {
                                        case 0: {
                                            floatArray2[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7] = float_2;
                                        }
                                    }
                                    break;
                                }
                                case 270: {
                                    switch (n10) {
                                        case 0: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray2[n7] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7 + 1] = float_2;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (n11 != 4 || n10 < 4 || n10 > 5) break;
                    ++n10;
                    pathIterator.next();
                }
                if (pathIterator.isDone()) {
                    if (floatArray2[n7] != null && (floatArray[n7].x != floatArray[n7 + 1].x || floatArray[n7].y != floatArray[n7 + 1].y)) {
                        n7 += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n7);
                    n7 = 0;
                    generalPath.append(shape, false);
                }
            }
            n4 += this.getCharacterCount(n8, n8);
            ++n8;
        }
        GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n7);
        if (this.transform != null) {
            return this.transform.createTransformedShape(generalPath);
        }
        return generalPath;
    }

    public static int cleanPtsList(Point2D.Float[] floatArray, int n) {
        if (n < 4) {
            return n;
        }
        Point2D.Float float_ = floatArray[0];
        Point2D.Float float_2 = floatArray[1];
        Point2D.Float float_3 = floatArray[2];
        int n2 = 3;
        int n3 = 3;
        while (n3 < n) {
            Point2D.Float float_4 = float_;
            Point2D.Float float_5 = GlyphLayout.calcIntervalIntersection(float_4, float_ = float_2, float_2 = float_3, float_3 = floatArray[n3]);
            if (float_5 != null) {
                floatArray[n2 - 1] = float_3;
                floatArray[n2 - 2] = float_5;
            } else {
                floatArray[n2] = float_3;
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static void addPtsToPath(GeneralPath generalPath, Point2D.Float[] floatArray, Point2D.Float[] floatArray2, int n) {
        if (n < 2) {
            return;
        }
        int n2 = 2;
        int n3 = 2;
        Point2D.Float float_ = floatArray[0];
        Point2D.Float float_2 = floatArray[1];
        Point2D.Float float_3 = floatArray2[0];
        Point2D.Float float_4 = floatArray2[1];
        int n4 = 2;
        while (n4 < n) {
            Point2D.Float float_5 = float_;
            Point2D.Float float_6 = float_2;
            Point2D.Float float_7 = float_3;
            Point2D.Float float_8 = float_4;
            float_ = floatArray[n4];
            float_2 = floatArray[n4 + 1];
            float_3 = floatArray2[n4];
            float_4 = floatArray2[n4 + 1];
            Point2D.Float float_9 = GlyphLayout.calcIntervalIntersection(float_5, float_6, float_, float_3);
            if (float_9 != null) {
                --n2;
            }
            if ((float_9 = GlyphLayout.calcIntervalIntersection(float_7, float_8, float_3, float_)) != null) {
                --n3;
            }
            if ((float_9 = GlyphLayout.calcIntervalIntersection(float_, float_2, float_6, float_8)) == null) {
                floatArray[n2++] = float_;
            }
            floatArray[n2++] = float_2;
            float_9 = GlyphLayout.calcIntervalIntersection(float_3, float_4, float_8, float_6);
            if (float_9 == null) {
                floatArray2[n3++] = float_3;
            }
            floatArray2[n3++] = float_4;
            n4 += 2;
        }
        n2 = GlyphLayout.cleanPtsList(floatArray, n2);
        generalPath.moveTo(floatArray[0].x, floatArray[0].y);
        int n5 = 1;
        while (n5 < n2) {
            generalPath.lineTo(floatArray[n5].x, floatArray[n5].y);
            ++n5;
        }
        n3 = GlyphLayout.cleanPtsList(floatArray2, n3);
        int n6 = n3 - 1;
        while (n6 >= 0) {
            generalPath.lineTo(floatArray2[n6].x, floatArray2[n6].y);
            --n6;
        }
        generalPath.closePath();
    }

    public static Point2D.Float verifyInRange(Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3) {
        if (float_ == null) {
            return null;
        }
        if (float_3.x == 0.0f && float_3.y == 0.0f) {
            if (Math.abs(float_2.x - float_.x) < 1.0E-5f && Math.abs(float_2.y - float_.y) < 1.0E-5f) {
                return float_;
            }
            return null;
        }
        float f = Math.abs(float_3.x) > Math.abs(float_3.y) ? (float_.x - float_2.x) / float_3.x : (float_.y - float_2.y) / float_3.y;
        if (f < 0.0f || f > 1.0f) {
            return null;
        }
        return float_;
    }

    public static Point2D.Float calcIntervalIntersection(Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3, Point2D.Float float_4) {
        int n;
        int n2;
        Point2D.Float float_5 = new Point2D.Float(float_2.x - float_.x, float_2.y - float_.y);
        Point2D.Float float_6 = new Point2D.Float(float_4.x - float_3.x, float_4.y - float_3.y);
        float f = float_5.y * float_.x - float_5.x * float_.y;
        float f2 = float_6.y * float_3.x - float_6.x * float_3.y;
        float f3 = float_5.x * float_3.y - float_5.y * float_3.x + f;
        if (f3 < -1.0E-5f) {
            n2 = -1;
        } else if (f3 > 1.0E-5f) {
            n2 = 1;
        } else {
            return GlyphLayout.verifyInRange(float_3, float_, float_5);
        }
        f3 = float_5.x * float_4.y - float_5.y * float_4.x + f;
        if (f3 < -1.0E-5f) {
            n = -1;
        } else if (f3 > 1.0E-5f) {
            n = 1;
        } else {
            return GlyphLayout.verifyInRange(float_4, float_, float_5);
        }
        if (n2 == n) {
            f3 = float_6.x * float_.y - float_6.y * float_.x + f2;
            if (f3 < -1.0E-5f) {
                n2 = -1;
            } else if (f3 > 1.0E-5f) {
                n2 = 1;
            } else {
                return GlyphLayout.verifyInRange(float_, float_3, float_6);
            }
            f3 = float_6.x * float_2.y - float_6.y * float_2.x + f2;
            if (f3 < -1.0E-5f) {
                n = -1;
            } else if (f3 > 1.0E-5f) {
                n = 1;
            } else {
                return GlyphLayout.verifyInRange(float_2, float_3, float_6);
            }
            if (n2 == n) {
                return null;
            }
        }
        float f4 = float_5.x * float_6.y - float_5.y * float_6.x;
        Point2D.Float float_7 = new Point2D.Float((float_5.x * f2 - float_6.x * f) / f4, (float_5.y * f2 - float_6.y * f) / f4);
        float_7 = GlyphLayout.verifyInRange(float_7, float_, float_5);
        float_7 = GlyphLayout.verifyInRange(float_7, float_3, float_6);
        return float_7;
    }

    public TextHit hitTestChar(float f, float f2) {
        TextHit textHit = null;
        if (this.transform != null) {
            try {
                Point2D.Float float_ = new Point2D.Float(f, f2);
                this.transform.inverseTransform(float_, float_);
                f = (float)((Point2D)float_).getX();
                f2 = (float)((Point2D)float_).getY();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        int n = this.aci.getBeginIndex();
        int n2 = 0;
        while (n2 < this.gv.getNumGlyphs()) {
            Shape shape = this.gv.getGlyphLogicalBounds(n2);
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (shape.contains(f, f2)) {
                    boolean bl = (double)f > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                    boolean bl2 = !bl;
                    this.aci.setIndex(n);
                    int n3 = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CHAR_INDEX);
                    textHit = new TextHit(n3, bl2);
                    return textHit;
                }
            }
            n += this.getCharacterCount(n2, n2);
            ++n2;
        }
        return textHit;
    }

    public boolean isVertical() {
        this.aci.first();
        return this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE) == GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    }

    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    public int getCharacterCount(int n, int n2) {
        return this.gv.getCharacterCount(n, n2);
    }

    public boolean isLeftToRight() {
        this.aci.first();
        int n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return Math.floor((double)n / 2.0) == Math.floor((double)(n + 1) / 2.0);
    }

    protected Shape getOverlineShape() {
        double d = this.metrics.getOverlineOffset();
        float f = this.metrics.getOverlineThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + (d += (double)f), rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getUnderlineShape() {
        double d = this.metrics.getUnderlineOffset();
        float f = this.metrics.getUnderlineThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + (d += (double)f * 1.5), rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getStrikethroughShape() {
        double d = this.metrics.getStrikethroughOffset();
        float f = this.metrics.getStrikethroughThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + d, rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected GVTFont getFont(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        GVTFont gVTFont = (GVTFont)attributedCharacterIterator.getAttributes().get(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gVTFont != null) {
            return gVTFont;
        }
        return new AWTGVTFont(attributedCharacterIterator.getAttributes());
    }

    protected void doPathLayout(boolean bl) {
        Point2D point2D;
        this.aci.first();
        this.textPath = (TextPath)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        if (this.textPath == null) {
            return;
        }
        boolean bl2 = !this.isVertical();
        boolean bl3 = this.isGlyphOrientationAuto();
        int n = 0;
        if (!bl3) {
            n = this.getGlyphOrientationAngle();
        }
        float f = this.textPath.lengthOfPath();
        float f2 = this.textPath.getStartOffset();
        int n2 = 0;
        while (n2 < this.gv.getNumGlyphs()) {
            this.gv.setGlyphVisible(n2, true);
            ++n2;
        }
        float f3 = bl2 ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (f == 0.0f || f3 == 0.0f) {
            return;
        }
        float f4 = bl2 ? (float)this.offset.getX() + f2 : (float)this.offset.getY() + f2;
        int n3 = this.aci.getBeginIndex();
        Point2D point2D2 = this.gv.getGlyphPosition(0);
        float f5 = 0.0f;
        if (bl) {
            f5 = bl2 ? (float)point2D2.getY() : (float)point2D2.getX();
        }
        char c = this.aci.first();
        int n4 = -1;
        float f6 = 0.0f;
        int n5 = 0;
        while (n5 < this.gv.getNumGlyphs()) {
            Object object;
            point2D = this.gv.getGlyphPosition(n5);
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (n5 < this.gv.getNumGlyphs() - 1) {
                object = this.gv.getGlyphPosition(n5 + 1);
                if (bl2) {
                    f7 = (float)(((Point2D)object).getX() - point2D.getX());
                    f8 = (float)(((Point2D)object).getY() - point2D.getY());
                } else {
                    f7 = (float)(((Point2D)object).getY() - point2D.getY());
                    f8 = (float)(((Point2D)object).getX() - point2D.getX());
                }
            } else {
                object = this.gv.getGlyphMetrics(n5);
                f7 = bl2 ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : (bl3 ? (this.isLatinChar(c) ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : ((GVTGlyphMetrics)object).getVerticalAdvance()) : (n == 0 || n == 180 ? ((GVTGlyphMetrics)object).getVerticalAdvance() : ((GVTGlyphMetrics)object).getHorizontalAdvance()));
            }
            object = this.gv.getGlyphOutline(n5).getBounds2D();
            float f9 = (float)((RectangularShape)object).getWidth();
            float f10 = (float)((RectangularShape)object).getHeight();
            float f11 = bl2 ? f4 + f9 / 2.0f : f4 + f10 / 2.0f;
            Point2D point2D3 = this.textPath.pointAtLength(f11);
            if (point2D3 != null) {
                float f12 = this.textPath.angleAtLength(f11);
                AffineTransform affineTransform = new AffineTransform();
                if (bl2) {
                    affineTransform.rotate(f12);
                } else {
                    affineTransform.rotate((double)f12 - 1.5707963267948966);
                }
                if (bl2) {
                    affineTransform.translate(0.0, f5);
                } else {
                    affineTransform.translate(f5, 0.0);
                }
                if (bl2) {
                    affineTransform.translate(f9 / -2.0f, 0.0);
                } else if (bl3) {
                    if (this.isLatinChar(c)) {
                        affineTransform.translate(0.0, -f10 / 2.0f);
                    } else {
                        affineTransform.translate(0.0, f10 / 2.0f);
                    }
                } else if (n == 0) {
                    affineTransform.translate(0.0, f10 / 2.0f);
                } else {
                    affineTransform.translate(0.0, -f10 / 2.0f);
                }
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(n5);
                if (affineTransform2 != null) {
                    affineTransform.concatenate(affineTransform2);
                }
                this.gv.setGlyphTransform(n5, affineTransform);
                this.gv.setGlyphPosition(n5, new Point2D.Double(point2D3.getX(), point2D3.getY()));
                n4 = n5;
                f6 = f7;
            } else {
                this.gv.setGlyphVisible(n5, false);
            }
            f4 += f7;
            f5 += f8;
            n3 += this.gv.getCharacterCount(n5, n5);
            c = this.aci.setIndex(this.aci.getBeginIndex() + n5 + this.gv.getCharacterCount(n5, n5));
            ++n5;
        }
        if (n4 > -1) {
            point2D = this.gv.getGlyphPosition(n4);
            this.textPathAdvance = bl2 ? new Point2D.Double(point2D.getX() + (double)f6, point2D.getY()) : new Point2D.Double(point2D.getX(), point2D.getY() + (double)f6);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
    }

    protected void adjustTextSpacing() {
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
        Integer n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        if (bl != null && bl.booleanValue()) {
            this.applySpacingParams(f, n, (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
        }
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL) {
            this.applyStretchTransform(f);
        }
    }

    protected void applyStretchTransform(Float f) {
        if (f != null && !f.isNaN()) {
            double d = 1.0;
            double d2 = 1.0;
            if (this.isVertical()) {
                d2 = (double)f.floatValue() / this.gv.getVisualBounds().getHeight();
            } else {
                d = (double)f.floatValue() / this.gv.getVisualBounds().getWidth();
            }
            Point2D point2D = this.gv.getGlyphPosition(0);
            int n = 0;
            while (n < this.gv.getNumGlyphs()) {
                Point2D point2D2 = this.gv.getGlyphPosition(n);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
                affineTransform.scale(d, d2);
                affineTransform.translate(-point2D.getX(), -point2D.getY());
                Point2D.Float float_ = new Point2D.Float();
                affineTransform.transform(point2D2, float_);
                this.gv.setGlyphPosition(n, float_);
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(n);
                if (affineTransform2 != null) {
                    affineTransform2.preConcatenate(AffineTransform.getScaleInstance(d, d2));
                    this.gv.setGlyphTransform(n, affineTransform2);
                } else {
                    this.gv.setGlyphTransform(n, AffineTransform.getScaleInstance(d, d2));
                }
                ++n;
            }
        }
    }

    protected void applySpacingParams(Float f, Integer n, Float f2, Float f3, Float f4) {
        this.advance = this.doSpacing(f2, f3, f4);
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && f != null && !f.isNaN()) {
            float f5 = 1.0f;
            float f6 = 1.0f;
            if (!this.isVertical()) {
                float f7 = (float)this.gv.getGlyphMetrics(this.gv.getNumGlyphs() - 1).getBounds2D().getWidth();
                f5 = (f.floatValue() - f7) / (float)(this.gv.getVisualBounds().getWidth() - (double)f7);
            } else {
                f6 = f.floatValue() / (float)this.gv.getVisualBounds().getHeight();
            }
            this.rescaleSpacing(f5, f6);
        }
    }

    protected Point2D doSpacing(Float f, Float f2, Float f3) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f instanceof Float && !f.isNaN()) {
            f4 = f.floatValue();
            bl = false;
        }
        if (f2 instanceof Float && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl3 = true;
        }
        if (f3 instanceof Float && !f3.isNaN()) {
            f6 = f3.floatValue();
            bl2 = true;
        }
        int n = this.gv.getNumGlyphs();
        float f7 = 0.0f;
        float f8 = 0.0f;
        Point2D[] point2DArray = new Point2D[n];
        Point2D point2D = this.gv.getGlyphPosition(0);
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        Point2D.Double double_ = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(n - 1).getX() - (double)f9), this.advance.getY() - (this.gv.getGlyphPosition(n - 1).getY() - (double)f10));
        try {
            int n2;
            if (n > 1 && (bl3 || !bl)) {
                n2 = 1;
                while (n2 < n) {
                    Point2D point2D2 = this.gv.getGlyphPosition(n2);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    if (bl) {
                        if (this.isVertical()) {
                            f8 += f5;
                        } else {
                            f7 += f5;
                        }
                    } else if (this.isVertical()) {
                        f8 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getHeight() + f4 + f5;
                    } else {
                        f7 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getWidth() + f4 + f5;
                    }
                    point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    point2D = point2D2;
                    ++n2;
                }
                int n3 = 1;
                while (n3 < n) {
                    if (point2DArray[n3] != null) {
                        this.gv.setGlyphPosition(n3, point2DArray[n3]);
                    }
                    ++n3;
                }
            }
            if (bl) {
                if (this.isVertical()) {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + (double)f5);
                } else {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX() + (double)f5, ((Point2D)double_).getY());
                }
            } else if (this.isVertical()) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), this.gv.getGlyphMetrics(n - 2).getBounds2D().getHeight() + (double)f4 + (double)f5);
            } else {
                ((Point2D)double_).setLocation(this.gv.getGlyphMetrics(n - 2).getBounds2D().getWidth() + (double)f4 + (double)f5, ((Point2D)double_).getY());
            }
            f7 = 0.0f;
            f8 = 0.0f;
            point2D = this.gv.getGlyphPosition(0);
            f9 = (float)point2D.getX();
            f10 = (float)point2D.getY();
            if (n > 1 && bl2) {
                n2 = 1;
                while (n2 < n) {
                    Point2D point2D3 = this.gv.getGlyphPosition(n2);
                    f7 = (float)point2D3.getX() - (float)point2D.getX();
                    f8 = (float)point2D3.getY() - (float)point2D.getY();
                    boolean bl4 = false;
                    int n4 = n2;
                    int n5 = n2;
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    while (gVTGlyphMetrics.getBounds2D().getWidth() < 0.01 || gVTGlyphMetrics.isWhitespace()) {
                        if (!bl4) {
                            bl4 = true;
                        }
                        if (n2 == n - 1) break;
                        ++n5;
                        point2D3 = this.gv.getGlyphPosition(++n2);
                        gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    }
                    if (bl4) {
                        int n6 = n5 - n4;
                        float f11 = (float)point2D.getX();
                        float f12 = (float)point2D.getY();
                        f7 = (float)(point2D3.getX() - (double)f11) / (float)(n6 + 1);
                        f8 = (float)(point2D3.getY() - (double)f12) / (float)(n6 + 1);
                        if (this.isVertical()) {
                            f8 += f3.floatValue() / (float)(n6 + 1);
                        } else {
                            f7 += f3.floatValue() / (float)(n6 + 1);
                        }
                        int n7 = n4;
                        while (n7 <= n5) {
                            point2DArray[n7] = new Point2D.Float(f9 += f7, f10 += f8);
                            ++n7;
                        }
                    } else {
                        f7 = (float)(point2D3.getX() - point2D.getX());
                        f8 = (float)(point2D3.getY() - point2D.getY());
                        point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    }
                    point2D = point2D3;
                    ++n2;
                }
                int n8 = 1;
                while (n8 < n) {
                    if (point2DArray[n8] != null) {
                        this.gv.setGlyphPosition(n8, point2DArray[n8]);
                    }
                    ++n8;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = this.gv.getGlyphPosition(n - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double d2 = this.gv.getGlyphPosition(n - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double double_2 = new Point2D.Double(d + ((Point2D)double_).getX(), d2 + ((Point2D)double_).getY());
        return double_2;
    }

    protected void rescaleSpacing(float f, float f2) {
        Rectangle2D rectangle2D = this.gv.getVisualBounds();
        float f3 = (float)rectangle2D.getX();
        float f4 = (float)rectangle2D.getY();
        int n = this.gv.getNumGlyphs();
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            Point2D point2D = this.gv.getGlyphPosition(n2);
            f5 = (float)point2D.getX() - f3;
            f6 = (float)point2D.getY() - f4;
            this.gv.setGlyphPosition(n2, new Point2D.Float(f3 + f5 * f, f4 + f6 * f2));
            ++n2;
        }
        this.advance = new Point2D.Float((float)((double)(f3 + f5 * f) - this.offset.getX()), (float)((double)(f4 + f6 * f2) - this.offset.getY()));
    }

    protected boolean isLatinChar(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B;
    }

    protected boolean isGlyphOrientationAuto() {
        boolean bl = true;
        this.aci.first();
        if (this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) != null) {
            bl = this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) == GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
        }
        return bl;
    }

    protected int getGlyphOrientationAngle() {
        int n = 0;
        this.aci.first();
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE);
        if (f != null) {
            n = (int)f.floatValue();
        }
        if (n != 0 || n != 90 || n != 180 || n != 270) {
            while (n < 0) {
                n += 360;
            }
            while (n >= 360) {
                n -= 360;
            }
            n = n <= 45 || n > 315 ? 0 : (n > 45 && n <= 135 ? 90 : (n > 135 && n <= 225 ? 180 : 270));
        }
        return n;
    }

    protected void doExplicitGlyphLayout(boolean bl) {
        char c = this.aci.first();
        int n = 0;
        float f = this.isVertical() ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        this.textPath = (TextPath)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        int n2 = this.gv.getNumGlyphs();
        float[] fArray = new float[n2 * 2];
        fArray = (float[])this.gv.getGlyphPositions(0, n2, fArray).clone();
        float f2 = (float)this.offset.getX();
        float f3 = (float)this.offset.getY();
        float f4 = f2;
        float f5 = f3;
        boolean bl2 = true;
        float f6 = 0.0f;
        float f7 = 0.0f;
        boolean bl3 = this.isGlyphOrientationAuto();
        int n3 = 0;
        if (!bl3) {
            n3 = this.getGlyphOrientationAngle();
        }
        while (n < n2) {
            Object object;
            if (bl2) {
                f6 = bl3 ? (this.isLatinChar(c) ? 0.0f : (float)this.gv.getGlyphMetrics(n).getBounds2D().getHeight()) : (n3 == 0 ? (float)this.gv.getGlyphMetrics(n).getBounds2D().getHeight() : 0.0f);
            } else if (bl3 && f6 == 0.0f && !this.isLatinChar(c)) {
                f6 = (float)this.gv.getGlyphMetrics(n).getBounds2D().getHeight();
            }
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            Float f11 = null;
            if (c != '\uffff') {
                object = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float f12 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.DX);
                Float f13 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                Float f14 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.DY);
                f11 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION);
                if (this.isVertical()) {
                    f10 = bl3 ? (this.isLatinChar(c) ? 1.5707964f : 0.0f) : (float)Math.toRadians(n3);
                    if (this.textPath != null) {
                        object = null;
                    }
                } else if (this.textPath != null) {
                    f13 = null;
                }
                f11 = f11 == null || f11.isNaN() ? new Float(f10) : new Float(f11.floatValue() + f10);
                if (object != null && !((Float)object).isNaN()) {
                    if (n == 0) {
                        if (bl) {
                            f4 = (float)this.offset.getX();
                        } else {
                            f2 = f4 = ((Float)object).floatValue();
                        }
                    } else {
                        f4 = ((Float)object).floatValue();
                    }
                } else if (f12 != null && !f12.isNaN()) {
                    f4 += f12.floatValue();
                }
                if (f13 != null && !f13.isNaN()) {
                    if (n == 0) {
                        if (bl) {
                            f5 = (float)this.offset.getY();
                        } else {
                            f3 = f5 = f13.floatValue();
                        }
                    } else {
                        f5 = f13.floatValue();
                    }
                } else if (f14 != null && !f14.isNaN()) {
                    f5 += f14.floatValue();
                } else if (n > 0) {
                    f5 += fArray[n * 2 + 1] - fArray[n * 2 - 1];
                }
                float f15 = 0.0f;
                Object object2 = this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT);
                if (object2 != null) {
                    if (object2 instanceof Integer) {
                        if (object2 == TextAttribute.SUPERSCRIPT_SUPER) {
                            f15 = f * 0.5f;
                        } else if (object2 == TextAttribute.SUPERSCRIPT_SUB) {
                            f15 = -f * 0.5f;
                        }
                    } else if (object2 instanceof Float) {
                        f15 = ((Float)object2).floatValue();
                    }
                    if (this.isVertical()) {
                        f8 = f15;
                    } else {
                        f9 = -f15;
                    }
                }
                if (this.isVertical()) {
                    Point2D point2D;
                    Rectangle2D rectangle2D;
                    f9 += f6;
                    if (bl3) {
                        if (this.isLatinChar(c)) {
                            f8 += this.metrics.getStrikethroughOffset();
                        } else {
                            rectangle2D = this.gv.getGlyphVisualBounds(n).getBounds2D();
                            point2D = this.gv.getGlyphPosition(n);
                            f8 -= (float)(rectangle2D.getMaxX() - point2D.getX() - rectangle2D.getWidth() / 2.0);
                        }
                    } else {
                        rectangle2D = this.gv.getGlyphVisualBounds(n).getBounds2D();
                        point2D = this.gv.getGlyphPosition(n);
                        f8 = n3 == 0 ? (f8 -= (float)(rectangle2D.getMaxX() - point2D.getX() - rectangle2D.getWidth() / 2.0)) : (n3 == 180 ? (f8 += (float)(rectangle2D.getMaxX() - point2D.getX() - rectangle2D.getWidth() / 2.0)) : (n3 == 90 ? (f8 += this.metrics.getStrikethroughOffset()) : (f8 -= this.metrics.getStrikethroughOffset())));
                    }
                }
            }
            this.gv.setGlyphPosition(n, new Point2D.Float(f4 + f8, f5 + f9));
            if (!ArabicTextHandler.arabicCharTransparent(c)) {
                object = this.gv.getGlyphMetrics(n);
                if (this.isVertical()) {
                    float f16 = 0.0f;
                    if (bl3) {
                        f16 = this.isLatinChar(c) ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : ((GVTGlyphMetrics)object).getVerticalAdvance();
                    } else if (n3 == 0 || n3 == 180) {
                        f16 = ((GVTGlyphMetrics)object).getVerticalAdvance();
                    } else if (n3 == 90) {
                        f16 = ((GVTGlyphMetrics)object).getHorizontalAdvance();
                    } else {
                        f16 = ((GVTGlyphMetrics)object).getHorizontalAdvance();
                        this.gv.setGlyphTransform(n, AffineTransform.getTranslateInstance(0.0, f16));
                    }
                    f5 += f16;
                } else {
                    f4 += ((GVTGlyphMetrics)object).getHorizontalAdvance();
                }
            }
            if (f11.floatValue() != 0.0f) {
                object = this.gv.getGlyphTransform(n);
                if (object == null) {
                    object = new AffineTransform();
                }
                ((AffineTransform)object).rotate(f11.floatValue());
                this.gv.setGlyphTransform(n, (AffineTransform)object);
            }
            c = this.aci.setIndex(this.aci.getBeginIndex() + n + this.gv.getCharacterCount(n, n));
            ++n;
            bl2 = false;
        }
        this.advance = new Point2D.Float((float)((double)f4 - this.offset.getX()), (float)((double)f5 - this.offset.getY()));
        this.offset = new Point2D.Float(f2, f3);
    }
}

