/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.svg2svg;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.svg2svg.OutputManager;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.batik.xml.scanner.DocumentScanner;
import org.apache.batik.xml.scanner.LexicalException;

public class PrettyPrinter {
    public static final int DOCTYPE_CHANGE = 0;
    public static final int DOCTYPE_REMOVE = 1;
    public static final int DOCTYPE_KEEP_UNCHANGED = 2;
    protected DocumentScanner scanner;
    protected OutputManager output;
    protected Writer writer;
    protected ErrorHandler errorHandler = SVGTranscoder.DEFAULT_ERROR_HANDLER;
    protected String newline = "\n";
    protected boolean format = true;
    protected int tabulationWidth = 4;
    protected int documentWidth = 80;
    protected int doctypeOption = 2;
    protected String publicId;
    protected String systemId;
    protected String xmlDeclaration;

    public void setXMLDeclaration(String string) {
        this.xmlDeclaration = string;
    }

    public void setDoctypeOption(int n) {
        this.doctypeOption = n;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setNewline(String string) {
        this.newline = string;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setFormat(boolean bl) {
        this.format = bl;
    }

    public boolean getFormat() {
        return this.format;
    }

    public void setTabulationWidth(int n) {
        this.tabulationWidth = Math.max(n, 0);
    }

    public int getTabulationWidth() {
        return this.tabulationWidth;
    }

    public void setDocumentWidth(int n) {
        this.documentWidth = Math.max(n, 0);
    }

    public int getDocumentWidth() {
        return this.documentWidth;
    }

    public void print(Reader reader, Writer writer) throws TranscoderException, IOException {
        try {
            this.scanner = new DocumentScanner(reader);
            this.output = new OutputManager(this, writer);
            this.writer = writer;
            this.scanner.next();
            this.printXMLDecl();
            int n = this.scanner.currentType();
            block17: while (true) {
                switch (n) {
                    case 1: {
                        this.output.printTopSpaces(this.scanner.currentValue());
                        n = this.scanner.next();
                        continue block17;
                    }
                    case 7: {
                        this.output.printComment(this.scanner.currentValue());
                        n = this.scanner.next();
                        continue block17;
                    }
                    case 3: {
                        this.printPI();
                        n = this.scanner.currentType();
                        continue block17;
                    }
                }
                break;
            }
            this.printDoctype();
            n = this.scanner.currentType();
            block18: while (true) {
                switch (n) {
                    case 1: {
                        this.output.printTopSpaces(this.scanner.currentValue());
                        n = this.scanner.next();
                        continue block18;
                    }
                    case 7: {
                        this.output.printComment(this.scanner.currentValue());
                        n = this.scanner.next();
                        continue block18;
                    }
                    case 3: {
                        this.printPI();
                        n = this.scanner.currentType();
                        continue block18;
                    }
                }
                break;
            }
            if (n != 2) {
                throw this.fatalError("element", null);
            }
            this.printElement();
            n = this.scanner.currentType();
            block19: while (true) {
                switch (n) {
                    case 1: {
                        this.output.printTopSpaces(this.scanner.currentValue());
                        n = this.scanner.next();
                        continue block19;
                    }
                    case 7: {
                        this.output.printComment(this.scanner.currentValue());
                        n = this.scanner.next();
                        continue block19;
                    }
                    case 3: {
                        this.printPI();
                        n = this.scanner.currentType();
                        continue block19;
                    }
                }
                break;
            }
        }
        catch (LexicalException lexicalException) {
            this.errorHandler.fatalError(new TranscoderException(lexicalException.getMessage()));
        }
    }

    protected void printXMLDecl() throws TranscoderException, LexicalException, IOException {
        if (this.xmlDeclaration == null) {
            int n = this.scanner.currentType();
            if (n == 4) {
                if (this.scanner.next() != 1) {
                    throw this.fatalError("space", null);
                }
                char[] cArray = this.scanner.currentValue();
                if (this.scanner.next() != 20) {
                    throw this.fatalError("token", new Object[]{"version"});
                }
                n = this.scanner.next();
                char[] cArray2 = null;
                if (n == 1) {
                    cArray2 = this.scanner.currentValue();
                    n = this.scanner.next();
                }
                if (n != 12) {
                    throw this.fatalError("token", new Object[]{"="});
                }
                n = this.scanner.next();
                char[] cArray3 = null;
                if (n == 1) {
                    cArray3 = this.scanner.currentValue();
                    n = this.scanner.next();
                }
                if (n != 23) {
                    throw this.fatalError("string", null);
                }
                char[] cArray4 = this.scanner.currentValue();
                char c = this.scanner.getStringDelimiter();
                char[] cArray5 = null;
                char[] cArray6 = null;
                char[] cArray7 = null;
                char[] cArray8 = null;
                char c2 = '\u0000';
                char[] cArray9 = null;
                char[] cArray10 = null;
                char[] cArray11 = null;
                char[] cArray12 = null;
                char c3 = '\u0000';
                char[] cArray13 = null;
                n = this.scanner.next();
                if (n == 1) {
                    cArray5 = this.scanner.currentValue();
                    n = this.scanner.next();
                    if (n == 21) {
                        n = this.scanner.next();
                        if (n == 1) {
                            cArray6 = this.scanner.currentValue();
                            n = this.scanner.next();
                        }
                        if (n != 12) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        n = this.scanner.next();
                        if (n == 1) {
                            cArray7 = this.scanner.currentValue();
                            n = this.scanner.next();
                        }
                        if (n != 23) {
                            throw this.fatalError("string", null);
                        }
                        cArray8 = this.scanner.currentValue();
                        c2 = this.scanner.getStringDelimiter();
                        n = this.scanner.next();
                        if (n == 1) {
                            cArray9 = this.scanner.currentValue();
                            n = this.scanner.next();
                        }
                    }
                    if (n == 22) {
                        n = this.scanner.next();
                        if (n == 1) {
                            cArray10 = this.scanner.currentValue();
                            n = this.scanner.next();
                        }
                        if (n != 12) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        n = this.scanner.next();
                        if (n == 1) {
                            cArray11 = this.scanner.currentValue();
                            n = this.scanner.next();
                        }
                        if (n != 23) {
                            throw this.fatalError("string", null);
                        }
                        cArray12 = this.scanner.currentValue();
                        c3 = this.scanner.getStringDelimiter();
                        n = this.scanner.next();
                        if (n == 1) {
                            cArray13 = this.scanner.currentValue();
                            n = this.scanner.next();
                        }
                    }
                }
                if (n != 6) {
                    throw this.fatalError("pi.end", null);
                }
                this.output.printXMLDecl(cArray, cArray2, cArray3, cArray4, c, cArray5, cArray6, cArray7, cArray8, c2, cArray9, cArray10, cArray11, cArray12, c3, cArray13);
                this.scanner.next();
            }
        } else {
            this.output.printString(this.xmlDeclaration);
            this.output.printNewline();
            int n = this.scanner.currentType();
            if (n == 4) {
                if (this.scanner.next() != 1) {
                    throw this.fatalError("space", null);
                }
                if (this.scanner.next() != 20) {
                    throw this.fatalError("token", new Object[]{"version"});
                }
                n = this.scanner.next();
                if (n == 1) {
                    n = this.scanner.next();
                }
                if (n != 12) {
                    throw this.fatalError("token", new Object[]{"="});
                }
                n = this.scanner.next();
                if (n == 1) {
                    n = this.scanner.next();
                }
                if (n != 23) {
                    throw this.fatalError("string", null);
                }
                n = this.scanner.next();
                if (n == 1) {
                    n = this.scanner.next();
                    if (n == 21) {
                        n = this.scanner.next();
                        if (n == 1) {
                            n = this.scanner.next();
                        }
                        if (n != 12) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        n = this.scanner.next();
                        if (n == 1) {
                            n = this.scanner.next();
                        }
                        if (n != 23) {
                            throw this.fatalError("string", null);
                        }
                        n = this.scanner.next();
                        if (n == 1) {
                            n = this.scanner.next();
                        }
                    }
                    if (n == 22) {
                        n = this.scanner.next();
                        if (n == 1) {
                            n = this.scanner.next();
                        }
                        if (n != 12) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        n = this.scanner.next();
                        if (n == 1) {
                            n = this.scanner.next();
                        }
                        if (n != 23) {
                            throw this.fatalError("string", null);
                        }
                        n = this.scanner.next();
                        if (n == 1) {
                            n = this.scanner.next();
                        }
                    }
                }
                if (n != 6) {
                    throw this.fatalError("pi.end", null);
                }
                this.scanner.next();
            }
        }
    }

    protected void printPI() throws TranscoderException, LexicalException, IOException {
        char[] cArray = this.scanner.currentValue();
        int n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray2 = this.scanner.currentValue();
        n = this.scanner.next();
        if (n != 5) {
            throw this.fatalError("pi.data", null);
        }
        char[] cArray3 = this.scanner.currentValue();
        n = this.scanner.next();
        if (n != 6) {
            throw this.fatalError("pi.end", null);
        }
        this.output.printPI(cArray, cArray2, cArray3);
        this.scanner.next();
    }

    protected void printDoctype() throws TranscoderException, LexicalException, IOException {
        int n = this.scanner.currentType();
        switch (this.doctypeOption) {
            default: {
                if (n == 8) {
                    n = this.scanner.next();
                    if (n != 1) {
                        throw this.fatalError("space", null);
                    }
                    char[] cArray = this.scanner.currentValue();
                    n = this.scanner.next();
                    if (n != 11) {
                        throw this.fatalError("name", null);
                    }
                    char[] cArray2 = this.scanner.currentValue();
                    char[] cArray3 = null;
                    String string = null;
                    char[] cArray4 = null;
                    char[] cArray5 = null;
                    char c = '\u0000';
                    char[] cArray6 = null;
                    char[] cArray7 = null;
                    int n2 = 0;
                    char[] cArray8 = null;
                    n = this.scanner.next();
                    if (n == 1) {
                        cArray3 = this.scanner.currentValue();
                        n = this.scanner.next();
                        switch (n) {
                            case 25: {
                                string = "PUBLIC";
                                n = this.scanner.next();
                                if (n != 1) {
                                    throw this.fatalError("space", null);
                                }
                                cArray4 = this.scanner.currentValue();
                                n = this.scanner.next();
                                if (n != 23) {
                                    throw this.fatalError("string", null);
                                }
                                cArray5 = this.scanner.currentValue();
                                c = this.scanner.getStringDelimiter();
                                n = this.scanner.next();
                                if (n != 1) {
                                    throw this.fatalError("space", null);
                                }
                                cArray6 = this.scanner.currentValue();
                                n = this.scanner.next();
                                if (n != 23) {
                                    throw this.fatalError("string", null);
                                }
                                cArray7 = this.scanner.currentValue();
                                n2 = this.scanner.getStringDelimiter();
                                n = this.scanner.next();
                                if (n != 1) break;
                                cArray8 = this.scanner.currentValue();
                                n = this.scanner.next();
                                break;
                            }
                            case 24: {
                                string = "SYSTEM";
                                n = this.scanner.next();
                                if (n != 1) {
                                    throw this.fatalError("space", null);
                                }
                                cArray4 = this.scanner.currentValue();
                                n = this.scanner.next();
                                if (n != 23) {
                                    throw this.fatalError("string", null);
                                }
                                cArray5 = this.scanner.currentValue();
                                c = this.scanner.getStringDelimiter();
                                n = this.scanner.next();
                                if (n != 1) break;
                                cArray6 = this.scanner.currentValue();
                                n = this.scanner.next();
                            }
                        }
                    }
                    if (this.doctypeOption == 0) {
                        if (this.publicId != null) {
                            string = "PUBLIC";
                            cArray5 = this.publicId.toCharArray();
                            c = '\"';
                            if (this.systemId != null) {
                                cArray7 = this.systemId.toCharArray();
                                n2 = 34;
                            }
                        } else if (this.systemId != null) {
                            string = "SYSTEM";
                            cArray5 = this.systemId.toCharArray();
                            c = '\"';
                            cArray7 = null;
                        }
                    }
                    this.output.printDoctypeStart(cArray, cArray2, cArray3, string, cArray4, cArray5, c, cArray6, cArray7, (char)n2, cArray8);
                    if (n == 26) {
                        this.output.printCharacter('[');
                        n = this.scanner.next();
                        block22: while (true) {
                            switch (n) {
                                case 1: {
                                    this.output.printSpaces(this.scanner.currentValue(), true);
                                    n = this.scanner.next();
                                    continue block22;
                                }
                                case 7: {
                                    this.output.printComment(this.scanner.currentValue());
                                    n = this.scanner.next();
                                    continue block22;
                                }
                                case 3: {
                                    this.printPI();
                                    n = this.scanner.currentType();
                                    continue block22;
                                }
                                case 28: {
                                    this.output.printParameterEntityReference(this.scanner.currentValue());
                                    n = this.scanner.next();
                                    continue block22;
                                }
                                case 29: {
                                    this.printElementDeclaration();
                                    n = this.scanner.currentType();
                                    continue block22;
                                }
                                case 30: {
                                    this.printAttlist();
                                    n = this.scanner.currentType();
                                    continue block22;
                                }
                                case 32: {
                                    this.printNotation();
                                    n = this.scanner.currentType();
                                    continue block22;
                                }
                                case 31: {
                                    this.printEntityDeclaration();
                                    n = this.scanner.currentType();
                                    continue block22;
                                }
                                case 27: {
                                    this.output.printCharacter(']');
                                    n = this.scanner.next();
                                    break block22;
                                }
                                default: {
                                    throw this.fatalError("xml", null);
                                }
                            }
                            break;
                        }
                    }
                    char[] cArray9 = null;
                    if (n == 1) {
                        cArray9 = this.scanner.currentValue();
                        n = this.scanner.next();
                    }
                    if (n != 10) {
                        throw this.fatalError("end", null);
                    }
                    this.scanner.next();
                    this.output.printDoctypeEnd(cArray9);
                    break;
                }
                if (this.doctypeOption != 0) break;
                String string = "PUBLIC";
                char[] cArray = "-//W3C//DTD SVG 1.0//EN".toCharArray();
                char[] cArray10 = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd".toCharArray();
                if (this.publicId != null) {
                    cArray = this.publicId.toCharArray();
                    if (this.systemId != null) {
                        cArray10 = this.systemId.toCharArray();
                    }
                } else if (this.systemId != null) {
                    string = "SYSTEM";
                    cArray = this.systemId.toCharArray();
                    cArray10 = null;
                }
                this.output.printDoctypeStart(new char[]{' '}, new char[]{'s', 'v', 'g'}, new char[]{' '}, string, new char[]{' '}, cArray, '\"', new char[]{' '}, cArray10, '\"', null);
                this.output.printDoctypeEnd(null);
                break;
            }
            case 1: {
                if (n == 8) {
                    n = this.scanner.next();
                    if (n != 1) {
                        throw this.fatalError("space", null);
                    }
                    n = this.scanner.next();
                    if (n != 11) {
                        throw this.fatalError("name", null);
                    }
                    n = this.scanner.next();
                    if (n == 1) {
                        n = this.scanner.next();
                        switch (n) {
                            case 25: {
                                n = this.scanner.next();
                                if (n != 1) {
                                    throw this.fatalError("space", null);
                                }
                                n = this.scanner.next();
                                if (n != 23) {
                                    throw this.fatalError("string", null);
                                }
                                n = this.scanner.next();
                                if (n != 1) {
                                    throw this.fatalError("space", null);
                                }
                                n = this.scanner.next();
                                if (n != 23) {
                                    throw this.fatalError("string", null);
                                }
                                n = this.scanner.next();
                                if (n != 1) break;
                                n = this.scanner.next();
                                break;
                            }
                            case 24: {
                                n = this.scanner.next();
                                if (n != 1) {
                                    throw this.fatalError("space", null);
                                }
                                n = this.scanner.next();
                                if (n != 23) {
                                    throw this.fatalError("string", null);
                                }
                                n = this.scanner.next();
                                if (n != 1) break;
                                n = this.scanner.next();
                            }
                        }
                    }
                    if (n == 26) {
                        while ((n = this.scanner.next()) != 27) {
                        }
                    }
                    if (n == 1) {
                        n = this.scanner.next();
                    }
                    if (n != 10) {
                        throw this.fatalError("end", null);
                    }
                }
                this.scanner.next();
            }
        }
    }

    protected void printElement() throws TranscoderException, LexicalException, IOException {
        char[] cArray = this.scanner.currentValue();
        LinkedList<OutputManager.AttributeInfo> linkedList = new LinkedList<OutputManager.AttributeInfo>();
        char[] cArray2 = null;
        int n = this.scanner.next();
        while (n == 1) {
            cArray2 = this.scanner.currentValue();
            n = this.scanner.next();
            if (n != 11) continue;
            char[] cArray3 = this.scanner.currentValue();
            char[] cArray4 = null;
            n = this.scanner.next();
            if (n == 1) {
                cArray4 = this.scanner.currentValue();
                n = this.scanner.next();
            }
            if (n != 12) {
                throw this.fatalError("token", new Object[]{"="});
            }
            n = this.scanner.next();
            char[] cArray5 = null;
            if (n == 1) {
                cArray5 = this.scanner.currentValue();
                n = this.scanner.next();
            }
            if (n != 13) {
                throw this.fatalError("string", null);
            }
            char c = this.scanner.getStringDelimiter();
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.scanner.currentValue());
            block10: while (true) {
                n = this.scanner.next();
                switch (n) {
                    case 13: {
                        stringBuffer.append(this.scanner.currentValue());
                        continue block10;
                    }
                    case 15: {
                        bl = true;
                        stringBuffer.append("&#");
                        stringBuffer.append(this.scanner.currentValue());
                        stringBuffer.append(";");
                        continue block10;
                    }
                    case 14: {
                        bl = true;
                        stringBuffer.append("&");
                        stringBuffer.append(this.scanner.currentValue());
                        stringBuffer.append(";");
                        continue block10;
                    }
                }
                break;
            }
            linkedList.add(new OutputManager.AttributeInfo(cArray2, cArray3, cArray4, cArray5, new String(stringBuffer), c, bl));
            cArray2 = null;
        }
        this.output.printElementStart(cArray, linkedList, cArray2);
        switch (n) {
            default: {
                throw this.fatalError("xml", null);
            }
            case 9: {
                this.output.printElementEnd(null, null);
                break;
            }
            case 10: {
                this.output.printCharacter('>');
                this.scanner.next();
                this.printContent();
                if (this.scanner.currentType() != 17) {
                    throw this.fatalError("end.tag", null);
                }
                cArray = this.scanner.currentValue();
                n = this.scanner.next();
                cArray2 = null;
                if (n == 1) {
                    cArray2 = this.scanner.currentValue();
                    n = this.scanner.next();
                }
                this.output.printElementEnd(cArray, cArray2);
                if (n == 10) break;
                throw this.fatalError("end", null);
            }
        }
        this.scanner.next();
    }

    protected void printContent() throws TranscoderException, LexicalException, IOException {
        int n = this.scanner.currentType();
        block9: while (true) {
            switch (n) {
                case 7: {
                    this.output.printComment(this.scanner.currentValue());
                    n = this.scanner.next();
                    continue block9;
                }
                case 3: {
                    this.printPI();
                    n = this.scanner.currentType();
                    continue block9;
                }
                case 16: {
                    this.output.printCharacterData(this.scanner.currentValue());
                    n = this.scanner.next();
                    continue block9;
                }
                case 18: {
                    n = this.scanner.next();
                    if (n != 16) {
                        throw this.fatalError("character.data", null);
                    }
                    this.output.printCDATASection(this.scanner.currentValue());
                    n = this.scanner.next();
                    if (n != 19) {
                        throw this.fatalError("section.end", null);
                    }
                    n = this.scanner.next();
                    continue block9;
                }
                case 2: {
                    this.printElement();
                    n = this.scanner.currentType();
                    continue block9;
                }
                case 15: {
                    this.output.printCharacterEntityReference(this.scanner.currentValue());
                    n = this.scanner.next();
                    continue block9;
                }
                case 14: {
                    this.output.printEntityReference(this.scanner.currentValue());
                    n = this.scanner.next();
                    continue block9;
                }
            }
            break;
        }
    }

    protected void printNotation() throws TranscoderException, LexicalException, IOException {
        int n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray = this.scanner.currentValue();
        n = this.scanner.next();
        if (n != 11) {
            throw this.fatalError("name", null);
        }
        char[] cArray2 = this.scanner.currentValue();
        n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray3 = this.scanner.currentValue();
        n = this.scanner.next();
        String string = null;
        char[] cArray4 = null;
        char[] cArray5 = null;
        char c = '\u0000';
        char[] cArray6 = null;
        char[] cArray7 = null;
        char c2 = '\u0000';
        switch (n) {
            default: {
                throw this.fatalError("notation.definition", null);
            }
            case 25: {
                string = "PUBLIC";
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                cArray4 = this.scanner.currentValue();
                n = this.scanner.next();
                if (n != 23) {
                    throw this.fatalError("string", null);
                }
                cArray5 = this.scanner.currentValue();
                c = this.scanner.getStringDelimiter();
                n = this.scanner.next();
                if (n != 1) break;
                cArray6 = this.scanner.currentValue();
                n = this.scanner.next();
                if (n != 23) break;
                cArray7 = this.scanner.currentValue();
                c2 = this.scanner.getStringDelimiter();
                n = this.scanner.next();
                break;
            }
            case 24: {
                string = "SYSTEM";
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                cArray4 = this.scanner.currentValue();
                n = this.scanner.next();
                if (n != 23) {
                    throw this.fatalError("string", null);
                }
                cArray5 = this.scanner.currentValue();
                c = this.scanner.getStringDelimiter();
                n = this.scanner.next();
            }
        }
        char[] cArray8 = null;
        if (n == 1) {
            cArray8 = this.scanner.currentValue();
            n = this.scanner.next();
        }
        if (n != 10) {
            throw this.fatalError("end", null);
        }
        this.output.printNotation(cArray, cArray2, cArray3, string, cArray4, cArray5, c, cArray6, cArray7, c2, cArray8);
        this.scanner.next();
    }

    protected void printAttlist() throws TranscoderException, LexicalException, IOException {
        int n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray = this.scanner.currentValue();
        n = this.scanner.next();
        if (n != 11) {
            throw this.fatalError("name", null);
        }
        char[] cArray2 = this.scanner.currentValue();
        n = this.scanner.next();
        this.output.printAttlistStart(cArray, cArray2);
        while (n == 1) {
            cArray = this.scanner.currentValue();
            n = this.scanner.next();
            if (n != 11) break;
            cArray2 = this.scanner.currentValue();
            n = this.scanner.next();
            if (n != 1) {
                throw this.fatalError("space", null);
            }
            char[] cArray3 = this.scanner.currentValue();
            n = this.scanner.next();
            this.output.printAttName(cArray, cArray2, cArray3);
            switch (n) {
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.output.printCharacters(this.scanner.currentValue());
                    n = this.scanner.next();
                    break;
                }
                case 57: {
                    this.output.printCharacters(this.scanner.currentValue());
                    n = this.scanner.next();
                    if (n != 1) {
                        throw this.fatalError("space", null);
                    }
                    this.output.printSpaces(this.scanner.currentValue(), false);
                    n = this.scanner.next();
                    if (n != 40) {
                        throw this.fatalError("left.brace", null);
                    }
                    n = this.scanner.next();
                    LinkedList<OutputManager.NameInfo> linkedList = new LinkedList();
                    cArray = null;
                    if (n == 1) {
                        cArray = this.scanner.currentValue();
                        n = this.scanner.next();
                    }
                    if (n != 11) {
                        throw this.fatalError("name", null);
                    }
                    cArray2 = this.scanner.currentValue();
                    n = this.scanner.next();
                    cArray3 = null;
                    if (n == 1) {
                        cArray3 = this.scanner.currentValue();
                        n = this.scanner.next();
                    }
                    linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                    block22: while (true) {
                        switch (n) {
                            default: {
                                break block22;
                            }
                            case 42: {
                                n = this.scanner.next();
                                cArray = null;
                                if (n == 1) {
                                    cArray = this.scanner.currentValue();
                                    n = this.scanner.next();
                                }
                                if (n != 11) {
                                    throw this.fatalError("name", null);
                                }
                                cArray2 = this.scanner.currentValue();
                                n = this.scanner.next();
                                cArray3 = null;
                                if (n == 1) {
                                    cArray3 = this.scanner.currentValue();
                                    n = this.scanner.next();
                                }
                                linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                                continue block22;
                            }
                        }
                        break;
                    }
                    if (n != 41) {
                        throw this.fatalError("right.brace", null);
                    }
                    this.output.printEnumeration(linkedList);
                    n = this.scanner.next();
                    break;
                }
                case 40: {
                    n = this.scanner.next();
                    LinkedList<OutputManager.NameInfo> linkedList = new LinkedList<OutputManager.NameInfo>();
                    cArray = null;
                    if (n == 1) {
                        cArray = this.scanner.currentValue();
                        n = this.scanner.next();
                    }
                    if (n != 56) {
                        throw this.fatalError("nmtoken", null);
                    }
                    cArray2 = this.scanner.currentValue();
                    n = this.scanner.next();
                    cArray3 = null;
                    if (n == 1) {
                        cArray3 = this.scanner.currentValue();
                        n = this.scanner.next();
                    }
                    linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                    block23: while (true) {
                        switch (n) {
                            default: {
                                break block23;
                            }
                            case 42: {
                                n = this.scanner.next();
                                cArray = null;
                                if (n == 1) {
                                    cArray = this.scanner.currentValue();
                                    n = this.scanner.next();
                                }
                                if (n != 56) {
                                    throw this.fatalError("nmtoken", null);
                                }
                                cArray2 = this.scanner.currentValue();
                                n = this.scanner.next();
                                cArray3 = null;
                                if (n == 1) {
                                    cArray3 = this.scanner.currentValue();
                                    n = this.scanner.next();
                                }
                                linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                                continue block23;
                            }
                        }
                        break;
                    }
                    if (n != 41) {
                        throw this.fatalError("right.brace", null);
                    }
                    this.output.printEnumeration(linkedList);
                    n = this.scanner.next();
                }
            }
            if (n == 1) {
                this.output.printSpaces(this.scanner.currentValue(), true);
                n = this.scanner.next();
            }
            switch (n) {
                default: {
                    throw this.fatalError("default.decl", null);
                }
                case 53: 
                case 54: {
                    this.output.printCharacters(this.scanner.currentValue());
                    n = this.scanner.next();
                    break;
                }
                case 55: {
                    this.output.printCharacters(this.scanner.currentValue());
                    n = this.scanner.next();
                    if (n != 1) {
                        throw this.fatalError("space", null);
                    }
                    this.output.printSpaces(this.scanner.currentValue(), false);
                    n = this.scanner.next();
                    if (n != 13) {
                        throw this.fatalError("space", null);
                    }
                }
                case 13: {
                    this.output.printCharacter(this.scanner.getStringDelimiter());
                    this.output.printCharacters(this.scanner.currentValue());
                    block24: while (true) {
                        n = this.scanner.next();
                        switch (n) {
                            case 13: {
                                this.output.printCharacters(this.scanner.currentValue());
                                continue block24;
                            }
                            case 15: {
                                this.output.printString("&#");
                                this.output.printCharacters(this.scanner.currentValue());
                                this.output.printCharacter(';');
                                continue block24;
                            }
                            case 14: {
                                this.output.printCharacter('&');
                                this.output.printCharacters(this.scanner.currentValue());
                                this.output.printCharacter(';');
                                continue block24;
                            }
                        }
                        break;
                    }
                    this.output.printCharacter(this.scanner.getStringDelimiter());
                }
            }
            cArray = null;
        }
        if (n != 10) {
            throw this.fatalError("end", null);
        }
        this.output.printAttlistEnd(cArray);
        this.scanner.next();
    }

    protected void printEntityDeclaration() throws TranscoderException, LexicalException, IOException {
        this.writer.write("<!ENTITY");
        int n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.scanner.currentValue());
        n = this.scanner.next();
        boolean bl = false;
        switch (n) {
            default: {
                throw this.fatalError("xml", null);
            }
            case 11: {
                this.writer.write(this.scanner.currentValue());
                n = this.scanner.next();
                break;
            }
            case 33: {
                bl = true;
                this.writer.write(37);
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                this.writer.write(this.scanner.currentValue());
                n = this.scanner.next();
                if (n != 11) {
                    throw this.fatalError("name", null);
                }
                this.writer.write(this.scanner.currentValue());
                n = this.scanner.next();
            }
        }
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.scanner.currentValue());
        n = this.scanner.next();
        switch (n) {
            case 13: {
                this.writer.write("\"");
                block14: while (true) {
                    switch (n) {
                        case 13: {
                            this.writer.write(this.scanner.currentValue());
                            break;
                        }
                        case 14: {
                            this.writer.write(38);
                            this.writer.write(this.scanner.currentValue());
                            this.writer.write(59);
                            break;
                        }
                        case 28: {
                            this.writer.write(38);
                            this.writer.write(this.scanner.currentValue());
                            this.writer.write(59);
                            break;
                        }
                        default: {
                            break block14;
                        }
                    }
                    n = this.scanner.next();
                }
                this.writer.write("\"");
                if (n == 1) {
                    this.writer.write(this.scanner.currentValue());
                    n = this.scanner.next();
                }
                if (n != 10) {
                    throw this.fatalError("end", null);
                }
                this.writer.write(">");
                this.scanner.next();
                return;
            }
            case 25: {
                this.writer.write("PUBLIC");
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                n = this.scanner.next();
                if (n != 13) {
                    throw this.fatalError("string", null);
                }
                this.writer.write(" \"");
                this.writer.write(this.scanner.currentValue());
                this.writer.write("\" \"");
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                n = this.scanner.next();
                if (n != 13) {
                    throw this.fatalError("string", null);
                }
                this.writer.write(this.scanner.currentValue());
                this.writer.write(34);
                break;
            }
            case 24: {
                this.writer.write("SYSTEM");
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                n = this.scanner.next();
                if (n != 13) {
                    throw this.fatalError("string" + n, null);
                }
                this.writer.write(" \"");
                this.writer.write(this.scanner.currentValue());
                this.writer.write(34);
            }
        }
        n = this.scanner.next();
        if (n == 1) {
            this.writer.write(this.scanner.currentValue());
            n = this.scanner.next();
            if (!bl && n == 34) {
                this.writer.write("NDATA");
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                this.writer.write(this.scanner.currentValue());
                n = this.scanner.next();
                if (n != 11) {
                    throw this.fatalError("name", null);
                }
                this.writer.write(this.scanner.currentValue());
                n = this.scanner.next();
            }
            if (n == 1) {
                this.writer.write(this.scanner.currentValue());
                n = this.scanner.next();
            }
        }
        if (n != 10) {
            throw this.fatalError("end", null);
        }
        this.writer.write(62);
        this.scanner.next();
    }

    protected void printElementDeclaration() throws TranscoderException, LexicalException, IOException {
        this.writer.write("<!ELEMENT");
        int n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.scanner.currentValue());
        n = this.scanner.next();
        switch (n) {
            default: {
                throw this.fatalError("name", null);
            }
            case 11: 
        }
        this.writer.write(this.scanner.currentValue());
        n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.scanner.currentValue());
        n = this.scanner.next();
        block3 : switch (n) {
            case 35: {
                this.writer.write("EMPTY");
                n = this.scanner.next();
                break;
            }
            case 36: {
                this.writer.write("ANY");
                n = this.scanner.next();
                break;
            }
            case 40: {
                this.writer.write(40);
                n = this.scanner.next();
                if (n == 1) {
                    this.writer.write(this.scanner.currentValue());
                    n = this.scanner.next();
                }
                switch (n) {
                    case 44: {
                        this.writer.write("#PCDATA");
                        n = this.scanner.next();
                        while (true) {
                            switch (n) {
                                case 1: {
                                    this.writer.write(this.scanner.currentValue());
                                    n = this.scanner.next();
                                    break;
                                }
                                case 42: {
                                    this.writer.write(124);
                                    n = this.scanner.next();
                                    if (n == 1) {
                                        this.writer.write(this.scanner.currentValue());
                                        n = this.scanner.next();
                                    }
                                    if (n != 11) {
                                        throw this.fatalError("name", null);
                                    }
                                    this.writer.write(this.scanner.currentValue());
                                    n = this.scanner.next();
                                    break;
                                }
                                case 41: {
                                    this.writer.write(41);
                                    n = this.scanner.next();
                                    break block3;
                                }
                            }
                        }
                    }
                    case 11: 
                    case 40: {
                        this.printChildren();
                        n = this.scanner.currentType();
                        if (n != 41) {
                            throw this.fatalError("right.brace", null);
                        }
                        this.writer.write(41);
                        n = this.scanner.next();
                        if (n == 1) {
                            this.writer.write(this.scanner.currentValue());
                            n = this.scanner.next();
                        }
                        switch (n) {
                            case 37: {
                                this.writer.write(63);
                                n = this.scanner.next();
                                break block3;
                            }
                            case 39: {
                                this.writer.write(42);
                                n = this.scanner.next();
                                break block3;
                            }
                            case 38: {
                                this.writer.write(43);
                                n = this.scanner.next();
                            }
                        }
                    }
                }
            }
        }
        if (n == 1) {
            this.writer.write(this.scanner.currentValue());
            n = this.scanner.next();
        }
        if (n != 10) {
            throw this.fatalError("end" + n, null);
        }
        this.writer.write(62);
        this.scanner.next();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void printChildren() throws TranscoderException, LexicalException, IOException {
        int n = 0;
        int n2 = this.scanner.currentType();
        while (true) {
            switch (n2) {
                default: {
                    throw new RuntimeException("Invalid XML");
                }
                case 11: {
                    this.writer.write(this.scanner.currentValue());
                    n2 = this.scanner.next();
                    break;
                }
                case 40: {
                    this.writer.write(40);
                    n2 = this.scanner.next();
                    if (n2 == 1) {
                        this.writer.write(this.scanner.currentValue());
                        n2 = this.scanner.next();
                    }
                    this.printChildren();
                    n2 = this.scanner.currentType();
                    if (n2 != 41) {
                        throw this.fatalError("right.brace", null);
                    }
                    this.writer.write(41);
                    n2 = this.scanner.next();
                }
            }
            if (n2 == 1) {
                this.writer.write(this.scanner.currentValue());
                n2 = this.scanner.next();
            }
            switch (n2) {
                case 41: {
                    return;
                }
                case 39: {
                    this.writer.write(42);
                    n2 = this.scanner.next();
                    break;
                }
                case 37: {
                    this.writer.write(63);
                    n2 = this.scanner.next();
                    break;
                }
                case 38: {
                    this.writer.write(43);
                    n2 = this.scanner.next();
                }
            }
            if (n2 == 1) {
                this.writer.write(this.scanner.currentValue());
                n2 = this.scanner.next();
            }
            switch (n2) {
                case 42: {
                    if (n != 0 && n != n2) {
                        throw new RuntimeException("Invalid XML");
                    }
                    this.writer.write(124);
                    n = n2;
                    n2 = this.scanner.next();
                    break;
                }
                case 43: {
                    if (n != 0 && n != n2) {
                        throw new RuntimeException("Invalid XML");
                    }
                    this.writer.write(44);
                    n = n2;
                    n2 = this.scanner.next();
                    break;
                }
            }
            if (n2 != 1) continue;
            this.writer.write(this.scanner.currentValue());
            n2 = this.scanner.next();
        }
    }

    protected TranscoderException fatalError(String string, Object[] objectArray) throws TranscoderException {
        TranscoderException transcoderException = new TranscoderException(string);
        this.errorHandler.fatalError(transcoderException);
        return transcoderException;
    }
}

