/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class WriterTarget
extends AbstractOutputTarget {
    protected Writer m_output;

    protected synchronized void setWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("writer property must not be null");
        }
        this.m_output = writer;
    }

    protected void write(String data) {
        try {
            this.m_output.write(data);
            this.m_output.flush();
        }
        catch (IOException ioe) {
            this.error("Caught an IOException", ioe);
        }
    }

    public synchronized void close() {
        super.close();
        this.shutdownWriter();
    }

    protected synchronized void shutdownWriter() {
        Writer writer = this.m_output;
        this.m_output = null;
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException ioe) {
            this.error("Error closing Writer", ioe);
        }
    }

    public WriterTarget(Writer writer, Formatter formatter) {
        super(formatter);
        if (writer != null) {
            this.setWriter(writer);
            this.open();
        }
    }
}

