/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class DatagramOutputTarget
extends AbstractOutputTarget {
    private DatagramSocket m_socket = new DatagramSocket();

    protected void write(String stringData) {
        byte[] data = stringData.getBytes();
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length);
            this.m_socket.send(packet);
        }
        catch (IOException ioe) {
            this.error("Error sending datagram.", ioe);
        }
    }

    public synchronized void close() {
        super.close();
        this.m_socket = null;
    }

    public DatagramOutputTarget(InetAddress address, int port, Formatter formatter) throws IOException {
        super(formatter);
        this.m_socket.connect(address, port);
        this.open();
    }

    public DatagramOutputTarget(InetAddress address, int port) throws IOException {
        this(address, port, null);
    }
}

