/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Hashtable;

public final class ContextMap {
    private static final ThreadLocal c_context = new InheritableThreadLocal();
    private final ContextMap m_parent;
    private Hashtable m_map = new Hashtable();
    private boolean m_readOnly;

    public static final ContextMap getCurrentContext() {
        return ContextMap.getCurrentContext(true);
    }

    public static final ContextMap getCurrentContext(boolean autocreate) {
        ContextMap context = (ContextMap)c_context.get();
        if (context == null && autocreate) {
            context = new ContextMap();
            c_context.set(context);
        }
        return context;
    }

    public static final void bind(ContextMap context) {
        c_context.set(context);
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void clear() {
        this.checkReadable();
        this.m_map.clear();
    }

    public Object get(String key, Object defaultObject) {
        Object object = this.get(key);
        if (object != null) {
            return object;
        }
        return defaultObject;
    }

    public Object get(String key) {
        Object result = this.m_map.get(key);
        if (result == null && this.m_parent != null) {
            return this.m_parent.get(key);
        }
        return result;
    }

    public void set(String key, Object value) {
        this.checkReadable();
        if (value == null) {
            this.m_map.remove(key);
        } else {
            this.m_map.put(key, value);
        }
    }

    public int getSize() {
        return this.m_map.size();
    }

    private void checkReadable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("ContextMap is read only and can not be modified");
        }
    }

    public ContextMap() {
        this(null);
    }

    public ContextMap(ContextMap parent) {
        this.m_parent = parent;
    }
}

