/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;

public class Hierarchy {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";
    private static final Hierarchy c_hierarchy = new Hierarchy();
    private Logger m_rootLogger = new Logger(this, "", null, null);

    public static Hierarchy getDefaultHierarchy() {
        return c_hierarchy;
    }

    public void setDefaultLogTarget(LogTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("Can not set DefaultLogTarget to null");
        }
        LogTarget[] targets = new LogTarget[]{target};
        this.getRootLogger().setLogTargets(targets);
    }

    public void setDefaultPriority(Priority priority) {
        if (priority == null) {
            throw new IllegalArgumentException("Can not set default Hierarchy Priority to null");
        }
        this.getRootLogger().setPriority(priority);
    }

    public Logger getLoggerFor(String category) {
        return this.getRootLogger().getChildLogger(category);
    }

    public void log(String message, Throwable throwable) {
        System.err.println("Error: " + message);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public void log(String message) {
        this.log(message, null);
    }

    protected final Logger getRootLogger() {
        return this.m_rootLogger;
    }

    public Hierarchy() {
        PatternFormatter formatter = new PatternFormatter(FORMAT);
        StreamTarget target = new StreamTarget(System.out, formatter);
        this.setDefaultLogTarget(target);
    }
}

