/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;

public abstract class AbstractOutputTarget
implements LogTarget {
    protected Formatter m_formatter;
    private boolean m_isOpen;

    protected boolean isOpen() {
        return this.m_isOpen;
    }

    public Formatter getFormatter() {
        return this.m_formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.writeTail();
        this.m_formatter = formatter;
        this.writeHead();
    }

    protected void write(String data) {
        this.output(data);
    }

    protected void output(String data) {
    }

    public void processEvent(LogEvent event) {
        if (!this.isOpen()) {
            this.error("Writing event to closed stream.", null);
            return;
        }
        try {
            String data = this.format(event);
            this.write(data);
        }
        catch (Throwable throwable) {
            this.error("Unknown error writing event.", throwable);
        }
    }

    protected void open() {
        if (!this.isOpen()) {
            this.m_isOpen = true;
            this.writeHead();
        }
    }

    public void close() {
        if (this.isOpen()) {
            this.writeTail();
            this.m_isOpen = false;
        }
    }

    private String format(LogEvent event) {
        if (this.m_formatter != null) {
            return this.m_formatter.format(event);
        }
        return event.toString();
    }

    private void writeHead() {
        if (!this.isOpen()) {
            return;
        }
        String head = this.getHead();
        if (head != null) {
            this.write(head);
        }
    }

    private void writeTail() {
        if (!this.isOpen()) {
            return;
        }
        String tail = this.getTail();
        if (tail != null) {
            this.write(tail);
        }
    }

    private String getHead() {
        return null;
    }

    private String getTail() {
        return null;
    }

    protected final void error(String message, Throwable throwable) {
        Hierarchy.getDefaultHierarchy().log(message, throwable);
    }

    public AbstractOutputTarget() {
    }

    public AbstractOutputTarget(Formatter formatter) {
        this.m_formatter = formatter;
    }
}

