/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public class MemoryTarget
implements LogTarget {
    private final LogEvent[] m_buffer;
    private Priority m_threshold;
    private LogTarget m_target;
    private int m_used;
    private int m_index;
    private boolean m_overwrite;

    protected void setOverwrite(boolean overwrite) {
        this.m_overwrite = overwrite;
    }

    public synchronized void processEvent(LogEvent event) {
        if (this.isFull()) {
            if (this.m_overwrite) {
                --this.m_used;
            } else {
                this.error("Memory buffer is full", null);
                return;
            }
        }
        this.m_index = this.m_used == 0 ? 0 : (this.m_index + 1) % this.m_buffer.length;
        this.m_buffer[this.m_index] = event;
        ++this.m_used;
        if (this.shouldPush(event)) {
            this.push();
        }
    }

    public final boolean isFull() {
        return this.m_buffer.length == this.m_used;
    }

    protected boolean shouldPush(LogEvent event) {
        return this.m_threshold.isLowerOrEqual(event.getPriority()) || this.isFull();
    }

    public synchronized void push() {
        if (this.m_target == null) {
            this.error("Can not push events to a null target", null);
            return;
        }
        try {
            int size = this.m_used;
            int base = this.m_index - this.m_used + 1;
            if (base < 0) {
                base += this.m_buffer.length;
            }
            int i = 0;
            while (i < size) {
                int index = (base + i) % this.m_buffer.length;
                this.m_target.processEvent(this.m_buffer[index]);
                this.m_buffer[index] = null;
                --this.m_used;
                ++i;
            }
        }
        catch (Throwable throwable) {
            this.error("Unknown error pushing events.", throwable);
        }
    }

    protected final void error(String message, Throwable throwable) {
        Hierarchy.getDefaultHierarchy().log(message, throwable);
    }

    public MemoryTarget(LogTarget target, int size, Priority threshold) {
        this.m_target = target;
        this.m_buffer = new LogEvent[size];
        this.m_threshold = threshold;
    }
}

