/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;

public class SafeFileTarget
extends FileTarget {
    public synchronized void processEvent(LogEvent event) {
        if (!this.isOpen()) {
            this.error("Writing event to closed stream.", null);
            return;
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(this.getFile().getPath(), true);
            this.setOutputStream(outputStream);
        }
        catch (Throwable throwable) {
            this.error("Unable to open file to write log event.", throwable);
            return;
        }
        super.processEvent(event);
        this.shutdownStream();
    }

    public SafeFileTarget(File file, boolean append, Formatter formatter) throws IOException {
        super(file, append, formatter);
        this.shutdownStream();
    }
}

