/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.res.XResourceBundle;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemNumber
extends ElemTemplateElement {
    private XPath m_countMatchPattern = null;
    private XPath m_fromMatchPattern = null;
    private int m_level = 1;
    private XPath m_valueExpr = null;
    private AVT m_format_avt = null;
    private AVT m_lang_avt = null;
    private AVT m_lettervalue_avt = null;
    private AVT m_groupingSeparator_avt = null;
    private AVT m_groupingSize_avt = null;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static char[] m_alphaCountTable = null;

    public Node appendChild(Node node) throws DOMException {
        this.error(4, new Object[]{node.getNodeName(), this.getNodeName()});
        return null;
    }

    public void execute(TransformerImpl transformerImpl, Node node, QName qName) throws TransformerException {
        if (TransformerImpl.S_DEBUG) {
            transformerImpl.getTraceManager().fireTraceEvent(node, qName, this);
        }
        String string = this.getCountString(transformerImpl, node);
        try {
            transformerImpl.getResultTreeHandler().characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    Node findAncestor(XPathContext xPathContext, XPath xPath, XPath xPath2, Node node, Element element) throws TransformerException {
        while (node != null) {
            if (xPath != null && xPath.getMatchScore(xPathContext, node) != Double.NEGATIVE_INFINITY || xPath2 != null && xPath2.getMatchScore(xPathContext, node) != Double.NEGATIVE_INFINITY) break;
            node = xPathContext.getDOMHelper().getParentOfNode(node);
        }
        return node;
    }

    private Node findPrecedingOrAncestorOrSelf(XPathContext xPathContext, XPath xPath, XPath xPath2, Node node, Element element) throws TransformerException {
        while (node != null) {
            if (xPath != null && xPath.getMatchScore(xPathContext, node) != Double.NEGATIVE_INFINITY) {
                node = null;
                break;
            }
            if (xPath2 != null && xPath2.getMatchScore(xPathContext, node) != Double.NEGATIVE_INFINITY) break;
            Node node2 = node.getPreviousSibling();
            if (node2 == null) {
                node = xPathContext.getDOMHelper().getParentOfNode(node);
                continue;
            }
            node = node2.getLastChild();
            if (node != null) continue;
            node = node2;
        }
        return node;
    }

    String formatNumberList(TransformerImpl transformerImpl, int[] nArray, Node node) throws TransformerException {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            String string2;
            String string3;
            int n = nArray.length;
            int n2 = 1;
            char c = '1';
            String string4 = null;
            String string5 = null;
            String string6 = ".";
            boolean bl = true;
            String string7 = string3 = this.m_format_avt != null ? this.m_format_avt.evaluate(transformerImpl.getXPathContext(), node, this) : null;
            if (string3 == null) {
                string3 = "1";
            }
            NumberFormatStringTokenizer numberFormatStringTokenizer = new NumberFormatStringTokenizer(string3);
            int n3 = 0;
            while (n3 < n) {
                if (numberFormatStringTokenizer.hasMoreTokens()) {
                    string2 = numberFormatStringTokenizer.nextToken();
                    if (Character.isLetterOrDigit(string2.charAt(string2.length() - 1))) {
                        n2 = string2.length();
                        c = string2.charAt(n2 - 1);
                    } else if (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                        string5 = string2;
                        while (numberFormatStringTokenizer.nextIsSep()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string5 = String.valueOf(string5) + string2;
                        }
                        if (!bl) {
                            string6 = string5;
                        }
                        string2 = numberFormatStringTokenizer.nextToken();
                        n2 = string2.length();
                        c = string2.charAt(n2 - 1);
                    } else {
                        string4 = string2;
                        while (numberFormatStringTokenizer.hasMoreTokens()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string4 = String.valueOf(string4) + string2;
                        }
                    }
                }
                if (string5 != null && bl) {
                    fastStringBuffer.append(string5);
                } else if (string6 != null && !bl) {
                    fastStringBuffer.append(string6);
                }
                this.getFormattedNumber(transformerImpl, node, c, n2, nArray[n3], fastStringBuffer);
                bl = false;
                ++n3;
            }
            while (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                numberFormatStringTokenizer.nextToken();
            }
            if (string4 != null) {
                fastStringBuffer.append(string4);
            }
            while (numberFormatStringTokenizer.hasMoreTokens()) {
                string2 = numberFormatStringTokenizer.nextToken();
                fastStringBuffer.append(string2);
            }
            string = fastStringBuffer.toString();
        }
        finally {
            Object var7_17 = null;
            StringBufferPool.free(fastStringBuffer);
        }
        return string;
    }

    public XPath getCount() {
        return this.m_countMatchPattern;
    }

    XPath getCountMatchPattern(XPathContext xPathContext, Node node) throws TransformerException {
        XPath xPath = this.m_countMatchPattern;
        if (xPath == null) {
            switch (node.getNodeType()) {
                case 1: {
                    xPath = new XPath(node.getNodeName(), this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 2: {
                    xPath = new XPath("@" + node.getNodeName(), this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 3: 
                case 4: {
                    xPath = new XPath("text()", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 8: {
                    xPath = new XPath("comment()", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 9: {
                    xPath = new XPath("/", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 7: {
                    xPath = new XPath("pi(" + node.getNodeName() + ")", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                default: {
                    xPath = null;
                }
            }
        }
        return xPath;
    }

    String getCountString(TransformerImpl transformerImpl, Node node) throws TransformerException {
        int[] nArray = null;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        CountersTable countersTable = transformerImpl.getCountersTable();
        if (this.m_valueExpr != null) {
            XObject xObject = this.m_valueExpr.execute(xPathContext, node, this);
            int n = (int)xObject.num();
            nArray = new int[]{n};
        } else if (this.m_level == 3) {
            nArray = new int[]{countersTable.countNode(xPathContext, this, node)};
        } else {
            NodeVector nodeVector = this.getMatchingAncestors(xPathContext, node, this.m_level == 1);
            int n = nodeVector.size() - 1;
            if (n >= 0) {
                nArray = new int[n + 1];
                int n2 = n;
                while (n2 >= 0) {
                    Node node2 = nodeVector.elementAt(n2);
                    nArray[n - n2] = countersTable.countNode(xPathContext, this, node2);
                    --n2;
                }
            }
        }
        return nArray != null ? this.formatNumberList(transformerImpl, nArray, node) : "";
    }

    public AVT getFormat() {
        return this.m_format_avt;
    }

    private void getFormattedNumber(TransformerImpl transformerImpl, Node node, char c, int n, int n2, FastStringBuffer fastStringBuffer) throws TransformerException {
        DecimalFormat decimalFormat = this.getNumberFormatter(transformerImpl, node);
        String string = decimalFormat.format(0L);
        String string2 = this.m_lettervalue_avt != null ? this.m_lettervalue_avt.evaluate(transformerImpl.getXPathContext(), node, this) : null;
        switch (c) {
            case 'A': {
                if (m_alphaCountTable == null) {
                    XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformerImpl, node));
                    char[] cArray = (char[])xResourceBundle.getObject("alphabet");
                    m_alphaCountTable = cArray;
                }
                this.int2alphaCount(n2, m_alphaCountTable, fastStringBuffer);
                break;
            }
            case 'a': {
                Object object;
                if (m_alphaCountTable == null) {
                    object = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformerImpl, node));
                    char[] cArray = (char[])((ResourceBundle)object).getObject("alphabet");
                    m_alphaCountTable = cArray;
                }
                object = StringBufferPool.get();
                try {
                    this.int2alphaCount(n2, m_alphaCountTable, (FastStringBuffer)object);
                    fastStringBuffer.append(((FastStringBuffer)object).toString().toLowerCase(this.getLocale(transformerImpl, node)));
                    break;
                }
                finally {
                    Object var12_27 = null;
                    StringBufferPool.free((FastStringBuffer)object);
                }
            }
            case 'I': {
                fastStringBuffer.append(this.long2roman(n2, true));
                break;
            }
            case 'i': {
                fastStringBuffer.append(this.long2roman(n2, true).toLowerCase(this.getLocale(transformerImpl, node)));
                break;
            }
            case '\u3042': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HA"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n2, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u3044': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HI"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n2, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a2': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "A"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n2, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a4': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "I"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(n2, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u4e00': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "CN"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u58f9': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "TW"));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0e51': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("th", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u05d0': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("he", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u10d0': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ka", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u03b1': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("el", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0430': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("cy", ""));
                if (string2 != null && string2.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(n2, xResourceBundle));
                    break;
                }
                this.int2alphaCount(n2, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            default: {
                String string3 = decimalFormat.format(n2);
                int n3 = n - string3.length();
                int n4 = 0;
                while (n4 < n3) {
                    fastStringBuffer.append(string);
                    ++n4;
                }
                fastStringBuffer.append(string3);
            }
        }
    }

    public XPath getFrom() {
        return this.m_fromMatchPattern;
    }

    public AVT getGroupingSeparator() {
        return this.m_groupingSeparator_avt;
    }

    public AVT getGroupingSize() {
        return this.m_groupingSize_avt;
    }

    public AVT getLang() {
        return this.m_lang_avt;
    }

    public AVT getLetterValue() {
        return this.m_lettervalue_avt;
    }

    public int getLevel() {
        return this.m_level;
    }

    Locale getLocale(TransformerImpl transformerImpl, Node node) throws TransformerException {
        Locale locale = null;
        if (this.m_lang_avt != null) {
            String string = this.m_lang_avt.evaluate(transformerImpl.getXPathContext(), node, this);
            if (string != null && (locale = new Locale(string.toUpperCase(), "")) == null) {
                transformerImpl.getMsgMgr().warn(this, null, node, 5, new Object[]{string});
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    NodeVector getMatchingAncestors(XPathContext xPathContext, Node node, boolean bl) throws TransformerException {
        NodeSet nodeSet = new NodeSet();
        XPath xPath = this.getCountMatchPattern(xPathContext, node);
        while (node != null) {
            if (this.m_fromMatchPattern != null && this.m_fromMatchPattern.getMatchScore(xPathContext, node) != Double.NEGATIVE_INFINITY && !bl) break;
            if (xPath == null) {
                System.out.println("Programmers error! countMatchPattern should never be null!");
            }
            if (xPath.getMatchScore(xPathContext, node) != Double.NEGATIVE_INFINITY) {
                nodeSet.addElement(node);
                if (bl) break;
            }
            node = xPathContext.getDOMHelper().getParentOfNode(node);
        }
        return nodeSet;
    }

    public String getNodeName() {
        return "number";
    }

    private DecimalFormat getNumberFormatter(TransformerImpl transformerImpl, Node node) throws TransformerException {
        DecimalFormat decimalFormat;
        block2: {
            String string;
            Locale locale = (Locale)this.getLocale(transformerImpl, node).clone();
            decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            String string2 = this.m_groupingSeparator_avt != null ? this.m_groupingSeparator_avt.evaluate(transformerImpl.getXPathContext(), node, this) : null;
            String string3 = string = this.m_groupingSize_avt != null ? this.m_groupingSize_avt.evaluate(transformerImpl.getXPathContext(), node, this) : null;
            if (string2 == null || string == null) break block2;
            try {
                decimalFormat.setGroupingSize(Integer.valueOf(string));
                decimalFormat.getDecimalFormatSymbols().setGroupingSeparator(string2.charAt(0));
                ((NumberFormat)decimalFormat).setGroupingUsed(true);
            }
            catch (NumberFormatException numberFormatException) {
                ((NumberFormat)decimalFormat).setGroupingUsed(false);
            }
        }
        return decimalFormat;
    }

    /*
     * Unable to fully structure code
     */
    public Node getPreviousNode(XPathContext var1_1, Node var2_2) throws TransformerException {
        block7: {
            var3_3 = this.getCountMatchPattern(var1_1, var2_2);
            if (this.m_level != 3) ** GOTO lbl-1000
            var4_4 = this.m_fromMatchPattern;
            while (var2_2 != null) {
                var5_5 = var2_2.getPreviousSibling();
                if (var5_5 == null) {
                    var5_5 = var2_2.getParentNode();
                    if (var5_5 != null && (var4_4 != null && var4_4.getMatchScore(var1_1, var5_5) != -Infinity || var5_5.getNodeType() == 9)) {
                        var2_2 = null;
                        break block7;
                    }
                } else {
                    var6_6 = var5_5;
                    while (var6_6 != null) {
                        var6_6 = var5_5.getLastChild();
                        if (var6_6 == null) continue;
                        var5_5 = var6_6;
                    }
                }
                if ((var2_2 = var5_5) == null || var3_3 != null && var3_3.getMatchScore(var1_1, var2_2) == -Infinity) {
                    continue;
                }
                break block7;
            }
            break block7;
            while ((var2_2 = var2_2.getPreviousSibling()) == null || var3_3 != null && var3_3.getMatchScore(var1_1, var2_2) == -Infinity) lbl-1000:
            // 2 sources

            {
                if (var2_2 != null) continue;
            }
        }
        return var2_2;
    }

    public Node getTargetNode(XPathContext xPathContext, Node node) throws TransformerException {
        Node node2 = null;
        XPath xPath = this.getCountMatchPattern(xPathContext, node);
        node2 = this.m_level == 3 ? this.findPrecedingOrAncestorOrSelf(xPathContext, this.m_fromMatchPattern, xPath, node, this) : this.findAncestor(xPathContext, this.m_fromMatchPattern, xPath, node, this);
        return node2;
    }

    public XPath getValue() {
        return this.m_valueExpr;
    }

    public int getXSLToken() {
        return 35;
    }

    String getZeroString() {
        return "0";
    }

    protected void int2alphaCount(int n, char[] cArray, FastStringBuffer fastStringBuffer) {
        int n2 = cArray.length;
        char[] cArray2 = new char[cArray.length];
        int n3 = 0;
        while (n3 < cArray.length - 1) {
            cArray2[n3 + 1] = cArray[n3];
            ++n3;
        }
        cArray2[0] = cArray[n3];
        char[] cArray3 = new char[100];
        int n4 = cArray3.length - 1;
        int n5 = 1;
        int n6 = 0;
        while ((n5 = (n + (n6 = n5 == 0 || n6 != 0 && n5 == n2 - 1 ? n2 - 1 : 0)) % n2) != 0 || (n /= n2) != 0) {
            cArray3[n4--] = cArray2[n5];
            if (n > 0) continue;
        }
        fastStringBuffer.append(cArray3, n4 + 1, cArray3.length - n4 - 1);
    }

    protected String int2singlealphaCount(int n, char[] cArray) {
        int n2 = cArray.length;
        if (n > n2) {
            return this.getZeroString();
        }
        return new Character(cArray[n - 1]).toString();
    }

    protected String long2roman(long l, boolean bl) {
        if (l <= 0L) {
            return this.getZeroString();
        }
        String string = "";
        int n = 0;
        if (l <= 3999L) {
            while (true) {
                if (l >= ElemNumber.m_romanConvertTable[n].m_postValue) {
                    string = String.valueOf(string) + ElemNumber.m_romanConvertTable[n].m_postLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_postValue;
                    continue;
                }
                if (bl && l >= ElemNumber.m_romanConvertTable[n].m_preValue) {
                    string = String.valueOf(string) + ElemNumber.m_romanConvertTable[n].m_preLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_preValue;
                }
                ++n;
                if (l <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    public void setCount(XPath xPath) {
        this.m_countMatchPattern = xPath;
    }

    public void setFormat(AVT aVT) {
        this.m_format_avt = aVT;
    }

    public void setFrom(XPath xPath) {
        this.m_fromMatchPattern = xPath;
    }

    public void setGroupingSeparator(AVT aVT) {
        this.m_groupingSeparator_avt = aVT;
    }

    public void setGroupingSize(AVT aVT) {
        this.m_groupingSize_avt = aVT;
    }

    public void setLang(AVT aVT) {
        this.m_lang_avt = aVT;
    }

    public void setLetterValue(AVT aVT) {
        this.m_lettervalue_avt = aVT;
    }

    public void setLevel(int n) {
        this.m_level = n;
    }

    public void setValue(XPath xPath) {
        this.m_valueExpr = xPath;
    }

    protected String tradAlphaCount(int n, XResourceBundle xResourceBundle) {
        int n2;
        char[] cArray;
        char[] cArray2 = null;
        int n3 = 1;
        char[] cArray3 = new char[100];
        int n4 = 0;
        int[] nArray = (int[])xResourceBundle.getObject("numberGroups");
        String[] stringArray = (String[])xResourceBundle.getObject("tables");
        String string = xResourceBundle.getString("numbering");
        if (string.equals("multiplicative-additive")) {
            String string2 = xResourceBundle.getString("multiplierOrder");
            int[] nArray2 = (int[])xResourceBundle.getObject("multiplier");
            cArray = (char[])xResourceBundle.getObject("zero");
            n2 = 0;
            while (n2 < nArray2.length && n < nArray2[n2]) {
                ++n2;
            }
            while (n2 < nArray2.length) {
                if (n < nArray2[n2]) {
                    if (cArray.length == 0) {
                        ++n2;
                    } else {
                        if (cArray3[n4 - 1] != cArray[0]) {
                            cArray3[n4++] = cArray[0];
                        }
                        ++n2;
                    }
                } else if (n >= nArray2[n2]) {
                    int n5 = n / nArray2[n2];
                    n %= nArray2[n2];
                    for (int i = 0; i < nArray.length; ++i) {
                        n3 = 1;
                        if (n5 / nArray[i] <= 0) {
                            continue;
                        }
                        char[] cArray4 = (char[])xResourceBundle.getObject(stringArray[i]);
                        cArray2 = new char[cArray4.length + 1];
                        int n6 = 0;
                        while (n6 < cArray4.length) {
                            cArray2[n6 + 1] = cArray4[n6];
                            ++n6;
                        }
                        cArray2[0] = cArray4[n6 - 1];
                        n3 = n5 / nArray[i];
                        if (n3 == 0 && n5 == 0) break;
                        char c = ((char[])xResourceBundle.getObject("multiplierChar"))[n2];
                        if (n3 < cArray2.length) {
                            if (string2.equals("precedes")) {
                                cArray3[n4++] = c;
                                cArray3[n4++] = cArray2[n3];
                                break;
                            }
                            if (n3 != 1 || n2 != nArray2.length - 1) {
                                cArray3[n4++] = cArray2[n3];
                            }
                            cArray3[n4++] = c;
                            break;
                        }
                        return "#error";
                    }
                    ++n2;
                }
                if (n2 < nArray2.length) continue;
            }
        }
        int n7 = 0;
        while (n7 < nArray.length) {
            if (n / nArray[n7] <= 0) {
                ++n7;
                continue;
            }
            cArray = (char[])xResourceBundle.getObject(stringArray[n7]);
            cArray2 = new char[cArray.length + 1];
            n2 = 0;
            while (n2 < cArray.length) {
                cArray2[n2 + 1] = cArray[n2];
                ++n2;
            }
            cArray2[0] = cArray[n2 - 1];
            n3 = n / nArray[n7];
            if (n3 == 0 && (n %= nArray[n7]) == 0) break;
            if (n3 >= cArray2.length) {
                return "#error";
            }
            cArray3[n4++] = cArray2[n3];
            ++n7;
        }
        return new String(cArray3, 0, n4);
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String string) {
            this.str = string;
            this.maxPosition = string.length();
        }

        public int countTokens() {
            int n = 0;
            int n2 = this.currentPosition;
            while (n2 < this.maxPosition) {
                int n3 = n2;
                while (n2 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                if (n3 == n2 && !Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                ++n;
            }
            return n;
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public boolean isLetterOrDigitAhead() {
            int n = this.currentPosition;
            while (n < this.maxPosition) {
                if (Character.isLetterOrDigit(this.str.charAt(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean nextIsSep() {
            return !Character.isLetterOrDigit(this.str.charAt(this.currentPosition));
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n, this.currentPosition);
        }

        public void reset() {
            this.currentPosition = 0;
        }
    }
}

