/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import org.apache.xalan.stree.SaxEventDispatch;
import org.apache.xml.utils.AttList;
import org.apache.xml.utils.NodeConsumer;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.DOMHelper;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TreeWalker {
    private ContentHandler m_contentHandler = null;
    protected DOMHelper m_dh = new DOM2Helper();
    boolean nextIsRaw = false;

    public TreeWalker(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
    }

    private final void dispatachChars(Node node) throws SAXException {
        if (node.isSupported("http://xml.apache.org/xalan/features/feed-events", "1.0")) {
            ((SaxEventDispatch)((Object)node)).dispatchCharactersEvent(this.m_contentHandler);
        } else {
            String string = ((Text)node).getData();
            this.m_contentHandler.characters(string.toCharArray(), 0, string.length());
        }
    }

    protected void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                this.m_contentHandler.endDocument();
                break;
            }
            case 1: {
                String string = this.m_dh.getNamespaceOfNode(node);
                if (string == null) {
                    string = "";
                }
                this.m_contentHandler.endElement(string, this.m_dh.getLocalNameOfNode(node), node.getNodeName());
                NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = namedNodeMap.item(n2);
                    String string2 = node2.getNodeName();
                    if (string2.equals("xmlns") || string2.startsWith("xmlns:")) {
                        int n3 = string2.indexOf(":");
                        String string3 = n3 < 0 ? "" : string2.substring(n3 + 1);
                        this.m_contentHandler.endPrefixMapping(string3);
                    }
                    ++n2;
                }
                break;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node;
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_contentHandler);
                lexicalHandler.endEntity(entityReference.getNodeName());
                break;
            }
        }
    }

    public ContentHandler getcontentHandler() {
        return this.m_contentHandler;
    }

    protected void startNode(Node node) throws SAXException {
        if (this.m_contentHandler instanceof NodeConsumer) {
            ((NodeConsumer)((Object)this.m_contentHandler)).setOriginatingNode(node);
        }
        switch (node.getNodeType()) {
            case 8: {
                String string = ((Comment)node).getData();
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_contentHandler);
                lexicalHandler.comment(string.toCharArray(), 0, string.length());
                break;
            }
            case 9: {
                this.m_contentHandler.startDocument();
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = namedNodeMap.item(n2);
                    String string = node2.getNodeName();
                    if (string.equals("xmlns") || string.startsWith("xmlns:")) {
                        int n3 = string.indexOf(":");
                        String string2 = n3 < 0 ? "" : string.substring(n3 + 1);
                        this.m_contentHandler.startPrefixMapping(string2, node2.getNodeValue());
                    }
                    ++n2;
                }
                String string = this.m_dh.getNamespaceOfNode(node);
                if (string == null) {
                    string = "";
                }
                this.m_contentHandler.startElement(string, this.m_dh.getLocalNameOfNode(node), node.getNodeName(), new AttList(namedNodeMap, this.m_dh));
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                String string = processingInstruction.getNodeName();
                if (string.equals("xslt-next-is-raw")) {
                    this.nextIsRaw = true;
                    break;
                }
                this.m_contentHandler.processingInstruction(processingInstruction.getNodeName(), processingInstruction.getData());
                break;
            }
            case 4: {
                LexicalHandler lexicalHandler;
                boolean bl = this.m_contentHandler instanceof LexicalHandler;
                LexicalHandler lexicalHandler2 = lexicalHandler = bl ? (LexicalHandler)((Object)this.m_contentHandler) : null;
                if (bl) {
                    lexicalHandler.startCDATA();
                }
                this.dispatachChars(node);
                if (!bl) break;
                lexicalHandler.endCDATA();
                break;
            }
            case 3: {
                String string = ((Text)node).getData();
                if (this.nextIsRaw) {
                    this.nextIsRaw = false;
                    this.m_contentHandler.processingInstruction("javax.xml.transform.disable-output-escaping", "");
                    this.dispatachChars(node);
                    this.m_contentHandler.processingInstruction("javax.xml.transform.enable-output-escaping", "");
                    break;
                }
                this.dispatachChars(node);
                break;
            }
            case 5: {
                EntityReference entityReference = (EntityReference)node;
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                ((LexicalHandler)((Object)this.m_contentHandler)).startEntity(entityReference.getNodeName());
                break;
            }
        }
    }

    public void traverse(Node node) throws SAXException {
        Node node2 = node;
        while (node != null) {
            this.startNode(node);
            Node node3 = node.getFirstChild();
            while (node3 == null) {
                this.endNode(node);
                if (node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (node3 != null || (node = node.getParentNode()) != null && !node2.equals(node)) continue;
                if (node != null) {
                    this.endNode(node);
                }
                node3 = null;
                break;
            }
            node = node3;
        }
    }

    public void traverse(Node node, Node node2) throws SAXException {
        while (node != null) {
            this.startNode(node);
            Node node3 = node.getFirstChild();
            while (node3 == null) {
                this.endNode(node);
                if (node2 != null && node2.equals(node)) break;
                node3 = node.getNextSibling();
                if (node3 != null || (node = node.getParentNode()) != null && (node2 == null || !node2.equals(node))) continue;
                node3 = null;
                break;
            }
            node = node3;
        }
    }
}

