/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xpath.objects.XObject;

public class XNumber
extends XObject {
    double m_val;

    public XNumber(double d) {
        this.m_val = d;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public boolean equals(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.m_val == xObject.num();
    }

    public int getType() {
        return 2;
    }

    public String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.m_val;
    }

    public Object object() {
        return new Double(this.m_val);
    }

    public String str() {
        String string;
        int n;
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        double d = this.m_val;
        String string2 = Double.toString(d);
        if (string2.charAt((n = string2.length()) - 2) == '.' && string2.charAt(n - 1) == '0') {
            if ((string2 = string2.substring(0, n - 2)).equals("-0")) {
                return "0";
            }
            return string2;
        }
        int n2 = string2.indexOf(69);
        if (n2 < 0) {
            return string2;
        }
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        if (string2.charAt(0) == '-') {
            string = "-";
            string2 = string2.substring(1);
            --n2;
        } else {
            string = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return String.valueOf(string) + string2.substring(0, 1) + string2.substring(2, n2) + XNumber.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return String.valueOf(string) + string2.substring(0, 1) + string2.substring(2, 2 + n3) + "." + string2.substring(2 + n3, n2);
        }
        return String.valueOf(string) + "0." + XNumber.zeros(-1 - n3) + string2.substring(0, 1) + string2.substring(2, n2);
    }

    private static String zeros(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }
}

