/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XSLTInputSource {
    private StreamSource streamSource = null;
    private SAXSource saxSource = null;
    private DOMSource domSource = null;
    private String encoding = null;
    private String baseID = null;

    public XSLTInputSource() {
        this.saxSource = new SAXSource();
    }

    public XSLTInputSource(InputStream inputStream) {
        this.streamSource = new StreamSource();
        this.streamSource.setInputStream(inputStream);
    }

    public XSLTInputSource(Reader reader) {
        this.streamSource = new StreamSource();
        this.streamSource.setReader(reader);
    }

    public XSLTInputSource(String string) {
        this.saxSource = new SAXSource();
        this.saxSource.setSystemId(string);
        this.setSystemId(string);
    }

    public XSLTInputSource(Node node) {
        this.domSource = new DOMSource();
        this.domSource.setNode(node);
    }

    public XSLTInputSource(InputSource inputSource) {
        this.saxSource = new SAXSource();
        this.saxSource.setInputSource(inputSource);
        this.setEncoding(inputSource.getEncoding());
        this.saxSource.setSystemId(inputSource.getSystemId());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Source getSourceObject() {
        if (this.streamSource != null) {
            return this.streamSource;
        }
        if (this.domSource != null) {
            return this.domSource;
        }
        return this.saxSource;
    }

    public String getSystemId() {
        return this.baseID;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setSystemId(String string) {
        this.baseID = string;
    }
}

