/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.DocumentHandler;
import org.xml.sax.helpers.ParserAdapter;

public class XSLTResultTarget {
    private StreamResult sr = null;
    private DOMResult saxResult = null;
    private DOMResult dr = null;
    private String encoding;
    private DocumentHandler formatterListener = null;

    public XSLTResultTarget() {
        this.sr = new StreamResult();
    }

    public XSLTResultTarget(OutputStream outputStream) {
        this.sr = new StreamResult();
        this.sr.setOutputStream(outputStream);
    }

    public XSLTResultTarget(Writer writer) {
        this.sr = new StreamResult();
        this.sr.setWriter(writer);
    }

    public XSLTResultTarget(String string) {
        this.sr = new StreamResult();
        this.sr.setSystemId(string);
    }

    public XSLTResultTarget(Node node) {
        this.dr = new DOMResult();
        this.dr.setNode(node);
    }

    public XSLTResultTarget(DocumentHandler documentHandler) {
        SAXResult sAXResult = new SAXResult();
        if (documentHandler instanceof ParserAdapter) {
            sAXResult.setHandler(((ParserAdapter)documentHandler).getContentHandler());
        }
        this.setDocumentHandler(documentHandler);
    }

    public OutputStream getByteStream() {
        if (this.sr != null) {
            return this.sr.getOutputStream();
        }
        return null;
    }

    public Writer getCharacterStream() {
        if (this.sr != null) {
            return this.sr.getWriter();
        }
        return null;
    }

    public DocumentHandler getDocumentHandler() {
        return this.formatterListener;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        if (this.sr != null) {
            return this.sr.getSystemId();
        }
        return null;
    }

    public Node getNode() {
        if (this.dr != null) {
            return this.dr.getNode();
        }
        return null;
    }

    public Result getResultObject() {
        if (this.sr != null) {
            return this.sr;
        }
        if (this.dr != null) {
            return this.dr;
        }
        return this.saxResult;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.formatterListener = documentHandler;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setNode(Node node) {
        if (this.dr == null) {
            this.dr = new DOMResult();
        }
        this.dr.setNode(node);
    }
}

