/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class NodeImpl
implements Node,
NodeList,
EventTarget,
Cloneable,
Serializable {
    static final long serialVersionUID = -6316591992167219696L;
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected NodeImpl ownerNode;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short SYNCDATA = 2;
    protected static final short SYNCCHILDREN = 4;
    protected static final short OWNED = 8;
    protected static final short FIRSTCHILD = 16;
    protected static final short SPECIFIED = 32;
    protected static final short IGNORABLEWS = 64;
    protected static final short SETVALUE = 128;
    protected static final boolean MUTATIONEVENTS = true;
    protected static final int MUTATION_NONE = 0;
    protected static final int MUTATION_LOCAL = 1;
    protected static final int MUTATION_AGGREGATE = 2;
    protected static final int MUTATION_ALL = 65535;

    protected NodeImpl(DocumentImpl documentImpl) {
        this.ownerNode = documentImpl;
    }

    public NodeImpl() {
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        nodeImpl.ownerNode = this.ownerDocument();
        nodeImpl.isOwned(false);
        nodeImpl.isReadOnly(false);
        return nodeImpl;
    }

    public Document getOwnerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (Document)((Object)this.ownerNode);
    }

    DocumentImpl ownerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (DocumentImpl)this.ownerNode;
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.isOwned()) {
            this.ownerNode = documentImpl;
        }
    }

    public Node getParentNode() {
        return null;
    }

    NodeImpl parentNode() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    ChildNode previousSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DOMException(3, "DOM006 Hierarchy request error");
    }

    public Node removeChild(Node node) throws DOMException {
        throw new DOMException(8, "DOM008 Not found");
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DOMException(3, "DOM006 Hierarchy request error");
    }

    public int getLength() {
        return 0;
    }

    public Node item(int n) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return this.ownerDocument().getImplementation().hasFeature(string, string2);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
        throw new DOMException(14, "DOM003 Namespace error");
    }

    public String getLocalName() {
        return null;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (string == null || string.equals("") || eventListener == null) {
            return;
        }
        this.removeEventListener(string, eventListener, bl);
        Vector<LEntry> vector = this.ownerDocument().getEventListeners(this);
        if (vector == null) {
            vector = new Vector<LEntry>();
            this.ownerDocument().setEventListeners(this, vector);
        }
        vector.addElement(new LEntry(string, eventListener, bl));
        LCount lCount = LCount.lookup(string);
        if (bl) {
            ++lCount.captures;
        } else {
            ++lCount.bubbles;
        }
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        Vector vector = this.ownerDocument().getEventListeners(this);
        if (vector == null || string == null || string.equals("") || eventListener == null) {
            return;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            LEntry lEntry = (LEntry)vector.elementAt(n);
            if (lEntry.useCapture == bl && lEntry.listener == eventListener && lEntry.type.equals(string)) {
                vector.removeElementAt(n);
                if (vector.size() == 0) {
                    this.ownerDocument().setEventListeners(this, null);
                }
                LCount lCount = LCount.lookup(string);
                if (bl) {
                    --lCount.captures;
                    break;
                }
                --lCount.bubbles;
                break;
            }
            --n;
        }
    }

    public boolean dispatchEvent(Event event) {
        LEntry lEntry;
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (event == null) {
            return false;
        }
        EventImpl eventImpl = (EventImpl)event;
        if (!eventImpl.initialized || eventImpl.type == null || eventImpl.type.equals("")) {
            throw new EventException(0, "DOM010 Unspecified event type");
        }
        LCount lCount = LCount.lookup(eventImpl.getType());
        if (lCount.captures + lCount.bubbles + lCount.defaults == 0) {
            return eventImpl.preventDefault;
        }
        eventImpl.target = this;
        eventImpl.stopPropagation = false;
        eventImpl.preventDefault = false;
        Vector<Node> vector = new Vector<Node>(10, 10);
        Node node = this;
        Node node2 = node.getParentNode();
        while (node2 != null) {
            vector.addElement(node2);
            node = node2;
            node2 = node2.getParentNode();
        }
        if (lCount.captures > 0) {
            eventImpl.eventPhase = 1;
            int n = vector.size() - 1;
            while (n >= 0) {
                if (eventImpl.stopPropagation) break;
                cloneable2 = (NodeImpl)vector.elementAt(n);
                eventImpl.currentTarget = cloneable2;
                cloneable = this.ownerDocument().getEventListeners((NodeImpl)cloneable2);
                if (cloneable != null) {
                    object = (Vector)cloneable.clone();
                    int n2 = ((Vector)object).size() - 1;
                    while (n2 >= 0) {
                        lEntry = (LEntry)((Vector)object).elementAt(n2);
                        if (lEntry.useCapture && lEntry.type.equals(eventImpl.type)) {
                            try {
                                lEntry.listener.handleEvent(eventImpl);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --n2;
                    }
                }
                --n;
            }
        }
        if (lCount.bubbles > 0) {
            eventImpl.eventPhase = (short)2;
            eventImpl.currentTarget = this;
            Vector vector2 = this.ownerDocument().getEventListeners(this);
            if (!eventImpl.stopPropagation && vector2 != null) {
                cloneable2 = (Vector)vector2.clone();
                int n = ((Vector)cloneable2).size() - 1;
                while (n >= 0) {
                    object = (LEntry)((Vector)cloneable2).elementAt(n);
                    if (object != null && !((LEntry)object).useCapture && ((LEntry)object).type.equals(eventImpl.type)) {
                        try {
                            ((LEntry)object).listener.handleEvent(eventImpl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    --n;
                }
            }
            if (eventImpl.bubbles) {
                eventImpl.eventPhase = (short)3;
                int n = 0;
                while (n < vector.size()) {
                    if (eventImpl.stopPropagation) break;
                    cloneable = (NodeImpl)vector.elementAt(n);
                    eventImpl.currentTarget = cloneable;
                    vector2 = this.ownerDocument().getEventListeners((NodeImpl)cloneable);
                    if (vector2 != null) {
                        object = (Vector)vector2.clone();
                        int n3 = ((Vector)object).size() - 1;
                        while (n3 >= 0) {
                            lEntry = (LEntry)((Vector)object).elementAt(n3);
                            if (!lEntry.useCapture && lEntry.type.equals(eventImpl.type)) {
                                try {
                                    lEntry.listener.handleEvent(eventImpl);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            --n3;
                        }
                    }
                    ++n;
                }
            }
        }
        if (lCount.defaults <= 0 || !eventImpl.cancelable || !eventImpl.preventDefault) {
            // empty if block
        }
        return eventImpl.preventDefault;
    }

    void dispatchEventToSubtree(Node node, Event event) {
        if (this.ownerDocument().mutationEvents) {
            Vector vector = this.ownerDocument().getEventListeners(this);
            if (vector == null || node == null) {
                return;
            }
            ((NodeImpl)node).dispatchEvent(event);
            if (node.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength() - 1;
                while (n >= 0) {
                    this.dispatchEventToSubtree(namedNodeMap.item(n), event);
                    --n;
                }
            }
            this.dispatchEventToSubtree(node.getFirstChild(), event);
            this.dispatchEventToSubtree(node.getNextSibling(), event);
        }
    }

    EnclosingAttr getEnclosingAttr() {
        if (this.ownerDocument().mutationEvents) {
            NodeImpl nodeImpl = this;
            while (true) {
                if (nodeImpl == null) {
                    return null;
                }
                short s = nodeImpl.getNodeType();
                if (s == 2) {
                    EnclosingAttr enclosingAttr = new EnclosingAttr();
                    enclosingAttr.node = (AttrImpl)nodeImpl;
                    enclosingAttr.oldvalue = enclosingAttr.node.getNodeValue();
                    return enclosingAttr;
                }
                if (s != 5) break;
                nodeImpl = nodeImpl.parentNode();
            }
            return null;
        }
        return null;
    }

    void dispatchAggregateEvents(EnclosingAttr enclosingAttr) {
        if (enclosingAttr != null) {
            this.dispatchAggregateEvents(enclosingAttr.node, enclosingAttr.oldvalue, (short)1);
        } else {
            this.dispatchAggregateEvents(null, null, (short)0);
        }
    }

    void dispatchAggregateEvents(AttrImpl attrImpl, String string, short s) {
        if (this.ownerDocument().mutationEvents) {
            MutationEventImpl mutationEventImpl;
            LCount lCount;
            NodeImpl nodeImpl = null;
            if (attrImpl != null) {
                lCount = LCount.lookup("DOMAttrModified");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0 && (nodeImpl = (NodeImpl)((Object)attrImpl.getOwnerElement())) != null) {
                    mutationEventImpl = new MutationEventImpl();
                    mutationEventImpl.initMutationEvent("DOMAttrModified", true, false, null, string, attrImpl.getNodeValue(), attrImpl.getNodeName(), (short)0);
                    mutationEventImpl.attrChange = s;
                    nodeImpl.dispatchEvent(mutationEventImpl);
                }
            }
            lCount = LCount.lookup("DOMSubtreeModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                mutationEventImpl = new MutationEventImpl();
                mutationEventImpl.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
                if (attrImpl != null) {
                    attrImpl.dispatchEvent(mutationEventImpl);
                    if (nodeImpl != null) {
                        nodeImpl.dispatchEvent(mutationEventImpl);
                    }
                } else {
                    this.dispatchEvent(mutationEventImpl);
                }
            }
        }
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isReadOnly(bl);
    }

    public boolean getReadOnly() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isReadOnly();
    }

    public void setUserData(Object object) {
        this.ownerDocument().setUserData(this, object);
    }

    public Object getUserData() {
        return this.ownerDocument().getUserData(this);
    }

    protected void changed() {
        this.ownerDocument().changed();
    }

    protected int changes() {
        return this.ownerDocument().changes();
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean bl) {
        this.flags = bl ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    final boolean needsSyncData() {
        return (this.flags & 2) != 0;
    }

    final void needsSyncData(boolean bl) {
        this.flags = bl ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    final boolean needsSyncChildren() {
        return (this.flags & 4) != 0;
    }

    final void needsSyncChildren(boolean bl) {
        this.flags = bl ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    final boolean isOwned() {
        return (this.flags & 8) != 0;
    }

    final void isOwned(boolean bl) {
        this.flags = bl ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    final boolean isFirstChild() {
        return (this.flags & 0x10) != 0;
    }

    final void isFirstChild(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
    }

    final boolean isSpecified() {
        return (this.flags & 0x20) != 0;
    }

    final void isSpecified(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x20) : (short)(this.flags & 0xFFFFFFDF);
    }

    final boolean internalIsIgnorableWhitespace() {
        return (this.flags & 0x40) != 0;
    }

    final void isIgnorableWhitespace(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x40) : (short)(this.flags & 0xFFFFFFBF);
    }

    final boolean setValueCalled() {
        return (this.flags & 0x80) != 0;
    }

    final void setValueCalled(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x80) : (short)(this.flags & 0xFFFFFF7F);
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        objectOutputStream.defaultWriteObject();
    }

    class EnclosingAttr {
        AttrImpl node;
        String oldvalue;

        EnclosingAttr() {
        }
    }

    class LEntry {
        String type;
        EventListener listener;
        boolean useCapture;

        LEntry(String string, EventListener eventListener, boolean bl) {
            this.type = string;
            this.listener = eventListener;
            this.useCapture = bl;
        }
    }
}

