/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.layout.Page;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.awt.AWTRenderer;
import org.xml.sax.XMLReader;

public class PrintStarter
extends CommandLineStarter {
    public PrintStarter(CommandLineOptions commandLineOptions) throws FOPException {
        super(commandLineOptions);
    }

    int getIntProperty(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return n;
            }
        }
        return n;
    }

    public void run() throws FOPException {
        Driver driver = new Driver();
        if (this.errorDump) {
            driver.setErrorDump(true);
        }
        String string = Version.getVersion();
        MessageHandler.errorln(string);
        XMLReader xMLReader = this.inputHandler.getParser();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (System.getProperty("dialog") != null && !printerJob.printDialog()) {
            throw new FOPException("Printing cancelled by operator");
        }
        PrintRenderer printRenderer = new PrintRenderer(printerJob);
        int n = this.getIntProperty("copies", 1);
        printerJob.setCopies(n);
        try {
            driver.setRenderer(printRenderer);
            driver.render(xMLReader, this.inputHandler.getInputSource());
        }
        catch (Exception exception) {
            if (exception instanceof FOPException) {
                throw (FOPException)exception;
            }
            throw new FOPException(exception);
        }
        System.exit(0);
    }

    class PrintRenderer
    extends AWTRenderer {
        private static final int EVEN_AND_ALL = 0;
        private static final int EVEN = 1;
        private static final int ODD = 2;
        private int startNumber;
        private int endNumber;
        private int mode;
        private int copies;
        private PrinterJob printerJob;

        PrintRenderer(PrinterJob printerJob) {
            block2: {
                super(null);
                this.mode = 0;
                this.copies = 1;
                this.printerJob = printerJob;
                this.startNumber = PrintStarter.this.getIntProperty("start", 1) - 1;
                this.endNumber = PrintStarter.this.getIntProperty("end", -1);
                printerJob.setPageable(this);
                this.mode = 0;
                String string = System.getProperty("even");
                if (string == null) break block2;
                try {
                    this.mode = Boolean.valueOf(string) != false ? 1 : 2;
                }
                catch (Exception exception) {}
            }
        }

        private Vector getInvalidPageNumbers() {
            Vector<String> vector = new Vector<String>();
            int n = this.getPageCount();
            int n2 = 0;
            while (n2 < n) {
                boolean bl = true;
                if (n2 < this.startNumber || n2 > this.endNumber) {
                    bl = false;
                } else if (this.mode != 0) {
                    if (this.mode == 1 && (n2 + 1) % 2 != 0) {
                        bl = false;
                    } else if (this.mode == 2 && (n2 + 1) % 2 != 1) {
                        bl = false;
                    }
                }
                if (!bl) {
                    vector.add(String.valueOf(n2));
                }
                ++n2;
            }
            return vector;
        }

        public void renderPage(Page page) {
            this.pageWidth = (int)((float)page.getWidth() / 1000.0f);
            this.pageHeight = (int)((float)page.getHeight() / 1000.0f);
            super.renderPage(page);
        }

        public void stopRenderer(OutputStream outputStream) throws IOException {
            super.stopRenderer(outputStream);
            if (this.endNumber == -1) {
                this.endNumber = this.getPageCount();
            }
            Vector vector = this.getInvalidPageNumbers();
            int n = vector.size() - 1;
            while (n > -1) {
                this.removePage(Integer.parseInt((String)vector.elementAt(n)));
                --n;
            }
            try {
                this.printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
                throw new IOException("Unable to print: " + printerException.getClass().getName() + ": " + printerException.getMessage());
            }
        }
    }
}

