/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;

public class FontInfo {
    private String metricsFile;
    private String embedFile;
    private String name;
    private boolean kerning;
    private Vector fontTriplets;
    private String baseDir;

    public FontInfo(String string, String string2, boolean bl, Vector vector, String string3) {
        this.name = string;
        this.metricsFile = string2;
        this.embedFile = string3;
        this.kerning = bl;
        this.fontTriplets = vector;
    }

    private String getBaseDir() throws FOPException {
        this.baseDir = Configuration.getStringValue("baseDir");
        URL uRL = null;
        try {
            uRL = new URL(this.baseDir);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("file:" + this.baseDir);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new FOPException("Error with baseDir: " + malformedURLException2.getMessage());
            }
        }
        this.baseDir = uRL.getFile();
        return this.baseDir;
    }

    public String getEmbedFile() throws FOPException {
        try {
            this.embedFile = new URL(this.embedFile).getFile();
        }
        catch (MalformedURLException malformedURLException) {}
        if (new File(this.embedFile).isAbsolute()) {
            return this.embedFile;
        }
        return String.valueOf(this.getBaseDir()) + this.embedFile;
    }

    public Vector getFontTriplets() {
        return this.fontTriplets;
    }

    public boolean getKerning() {
        return this.kerning;
    }

    public String getMetricsFile() throws FOPException {
        try {
            this.metricsFile = new URL(this.metricsFile).getFile();
        }
        catch (MalformedURLException malformedURLException) {}
        if (new File(this.metricsFile).isAbsolute()) {
            return this.metricsFile;
        }
        return String.valueOf(this.getBaseDir()) + this.metricsFile;
    }
}

