/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.ColumnArea;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;

public class PropertyManager {
    private PropertyList properties;
    private FontState fontState = null;
    private BorderAndPadding borderAndPadding = null;
    private HyphenationProps hyphProps = null;
    private BackgroundProps bgProps = null;
    private String[] saLeft;
    private String[] saRight;
    private String[] saTop;
    private String[] saBottom;
    private static MessageFormat msgColorFmt = new MessageFormat("border-{0}-color");
    private static MessageFormat msgStyleFmt = new MessageFormat("border-{0}-style");
    private static MessageFormat msgWidthFmt = new MessageFormat("border-{0}-width");
    private static MessageFormat msgPaddingFmt = new MessageFormat("padding-{0}");

    public PropertyManager(PropertyList propertyList) {
        this.properties = propertyList;
    }

    public int checkBreakAfter(Area area) {
        switch (this.properties.get("break-after").getEnum()) {
            case 59: {
                return 4;
            }
            case 56: {
                return 6;
            }
            case 26: {
                return 5;
            }
            case 15: {
                return 7;
            }
        }
        return 1;
    }

    public int checkBreakBefore(Area area) {
        if (!(area instanceof ColumnArea)) {
            switch (this.properties.get("break-before").getEnum()) {
                case 59: {
                    return 4;
                }
                case 56: {
                    return 6;
                }
                case 26: {
                    return 5;
                }
                case 15: {
                    return 7;
                }
            }
            return 1;
        }
        ColumnArea columnArea = (ColumnArea)area;
        switch (this.properties.get("break-before").getEnum()) {
            case 59: {
                if (!columnArea.hasChildren() && columnArea.getColumnIndex() == 1) {
                    return 1;
                }
                return 4;
            }
            case 56: {
                if (!columnArea.hasChildren() && columnArea.getColumnIndex() == 1 && columnArea.getPage().getNumber() % 2 != 0) {
                    return 1;
                }
                return 6;
            }
            case 26: {
                if (!columnArea.hasChildren() && columnArea.getColumnIndex() == 1 && columnArea.getPage().getNumber() % 2 == 0) {
                    return 1;
                }
                return 5;
            }
            case 15: {
                if (!area.hasChildren()) {
                    return 1;
                }
                return 7;
            }
        }
        return 1;
    }

    public AbsolutePositionProps getAbsolutePositionProps() {
        AbsolutePositionProps absolutePositionProps = new AbsolutePositionProps();
        return absolutePositionProps;
    }

    public AccessibilityProps getAccessibilityProps() {
        AccessibilityProps accessibilityProps = new AccessibilityProps();
        String string = this.properties.get("source-document").getString();
        if (!"none".equals(string)) {
            accessibilityProps.sourceDoc = string;
        }
        if (!"none".equals(string = this.properties.get("role").getString())) {
            accessibilityProps.role = string;
        }
        return accessibilityProps;
    }

    public AuralProps getAuralProps() {
        AuralProps auralProps = new AuralProps();
        return auralProps;
    }

    public BackgroundProps getBackgroundProps() {
        if (this.bgProps == null) {
            this.bgProps = new BackgroundProps();
            this.bgProps.backColor = this.properties.get("background-color").getColorType();
            String string = this.properties.get("background-image").getString();
            if (string.equalsIgnoreCase("none")) {
                this.bgProps.backImage = null;
            } else if (string.equalsIgnoreCase("inherit")) {
                this.bgProps.backImage = null;
            } else {
                try {
                    this.bgProps.backImage = FopImageFactory.Make(string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.bgProps.backImage = null;
                    System.out.println("Error creating background image: " + malformedURLException.getMessage());
                }
                catch (FopImageException fopImageException) {
                    this.bgProps.backImage = null;
                    System.out.println("Error creating background image: " + fopImageException.getMessage());
                }
            }
            this.bgProps.backRepeat = this.properties.get("background-repeat").getEnum();
        }
        return this.bgProps;
    }

    public BorderAndPadding getBorderAndPadding() {
        if (this.borderAndPadding == null) {
            this.borderAndPadding = new BorderAndPadding();
            this.initDirections();
            this.initBorderInfo(0, this.saTop);
            this.initBorderInfo(2, this.saBottom);
            this.initBorderInfo(3, this.saLeft);
            this.initBorderInfo(1, this.saRight);
        }
        return this.borderAndPadding;
    }

    public FontState getFontState(FontInfo fontInfo) throws FOPException {
        if (this.fontState == null) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            int n2 = this.properties.get("font-variant").getEnum();
            this.fontState = new FontState(fontInfo, string, string2, string3, n, n2);
        }
        return this.fontState;
    }

    public HyphenationProps getHyphenationProps() {
        if (this.hyphProps == null) {
            this.hyphProps = new HyphenationProps();
            this.hyphProps.hyphenate = this.properties.get("hyphenate").getEnum();
            this.hyphProps.hyphenationChar = this.properties.get("hyphenation-character").getCharacter();
            this.hyphProps.hyphenationPushCharacterCount = this.properties.get("hyphenation-push-character-count").getNumber().intValue();
            this.hyphProps.hyphenationRemainCharacterCount = this.properties.get("hyphenation-remain-character-count").getNumber().intValue();
            this.hyphProps.language = this.properties.get("language").getString();
            this.hyphProps.country = this.properties.get("country").getString();
        }
        return this.hyphProps;
    }

    public MarginInlineProps getMarginInlineProps() {
        MarginInlineProps marginInlineProps = new MarginInlineProps();
        return marginInlineProps;
    }

    public MarginProps getMarginProps() {
        MarginProps marginProps = new MarginProps();
        marginProps.marginTop = this.properties.get("margin-top").getLength().mvalue();
        marginProps.marginBottom = this.properties.get("margin-bottom").getLength().mvalue();
        marginProps.marginLeft = this.properties.get("margin-left").getLength().mvalue();
        marginProps.marginRight = this.properties.get("margin-right").getLength().mvalue();
        return marginProps;
    }

    public RelativePositionProps getRelativePositionProps() {
        RelativePositionProps relativePositionProps = new RelativePositionProps();
        return relativePositionProps;
    }

    public TextState getTextDecoration(FObj fObj) throws FOPException {
        int n;
        Object object;
        TextState textState = null;
        boolean bl = false;
        do {
            if (((String)(object = fObj.getName())).equals("fo:flow") || ((String)object).equals("fo:static-content")) {
                bl = true;
            } else if (((String)object).equals("fo:block") || ((String)object).equals("fo:inline")) {
                FObjMixed fObjMixed = (FObjMixed)fObj;
                textState = fObjMixed.getTextState();
                bl = true;
            }
            fObj = fObj.getParent();
        } while (!bl);
        object = new TextState();
        if (textState != null) {
            ((TextState)object).setUnderlined(textState.getUnderlined());
            ((TextState)object).setOverlined(textState.getOverlined());
            ((TextState)object).setLineThrough(textState.getLineThrough());
        }
        if ((n = this.properties.get("text-decoration").getEnum()) == 86) {
            ((TextState)object).setUnderlined(true);
        }
        if (n == 58) {
            ((TextState)object).setOverlined(true);
        }
        if (n == 40) {
            ((TextState)object).setLineThrough(true);
        }
        if (n == 49) {
            ((TextState)object).setUnderlined(false);
        }
        if (n == 47) {
            ((TextState)object).setOverlined(false);
        }
        if (n == 46) {
            ((TextState)object).setLineThrough(false);
        }
        return object;
    }

    private void initBorderInfo(int n, String[] stringArray) {
        this.borderAndPadding.setPadding(n, this.properties.get(msgPaddingFmt.format(stringArray)).getCondLength());
        int n2 = this.properties.get(msgStyleFmt.format(stringArray)).getEnum();
        if (n2 != 52) {
            this.borderAndPadding.setBorder(n, n2, this.properties.get(msgWidthFmt.format(stringArray)).getCondLength(), this.properties.get(msgColorFmt.format(stringArray)).getColorType());
        }
    }

    private void initDirections() {
        this.saLeft = new String[1];
        this.saRight = new String[1];
        this.saTop = new String[1];
        this.saBottom = new String[1];
        this.saTop[0] = this.properties.wmAbsToRel(2);
        this.saBottom[0] = this.properties.wmAbsToRel(3);
        this.saLeft[0] = this.properties.wmAbsToRel(0);
        this.saRight[0] = this.properties.wmAbsToRel(1);
    }
}

