/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.net.MalformedURLException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;

public class ExternalGraphic
extends FObj {
    int breakAfter;
    int breakBefore;
    int align;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    String src;
    int height;
    int width;
    String id;
    ImageArea imageArea;

    public ExternalGraphic(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:external-graphic";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (this.marker == -1000) {
            object2 = this.propMgr.getAccessibilityProps();
            AuralProps auralProps = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
            MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
            object = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.src = this.properties.get("src").getString();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.id = this.properties.get("id").getString();
            area.getIDReferences().createID(this.id);
            this.marker = 0;
        }
        try {
            object2 = FopImageFactory.Make(this.src);
            if (this.width == 0 || this.height == 0) {
                double d = object2.getWidth();
                double d2 = object2.getHeight();
                if (this.width == 0 && this.height == 0) {
                    this.width = (int)(d * 1000.0);
                    this.height = (int)(d2 * 1000.0);
                } else if (this.height == 0) {
                    this.height = (int)(d2 * (double)this.width / d);
                } else if (this.width == 0) {
                    this.width = (int)(d * (double)this.height / d2);
                }
            }
            double d = (double)this.width / (double)this.height;
            int n = area.getAllocationWidth() - this.startIndent - this.endIndent;
            int n2 = area.getPage().getBody().getMaxHeight() - this.spaceBefore;
            if (this.height > n2) {
                this.height = n2;
                this.width = (int)(d * (double)this.height);
            }
            if (this.width > n) {
                this.width = n;
                this.height = (int)((double)this.width / d);
            }
            if (area.spaceLeft() < this.height + this.spaceBefore) {
                return new Status(2);
            }
            this.imageArea = new ImageArea(this.propMgr.getFontState(area.getFontInfo()), (FopImage)object2, area.getAllocationWidth(), this.width, this.height, this.startIndent, this.endIndent, this.align);
            if (this.spaceBefore != 0 && this.marker == 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.marker == 0) {
                area.getIDReferences().configureID(this.id, area);
            }
            this.imageArea.start();
            this.imageArea.end();
            if (this.spaceAfter != 0) {
                area.addDisplaySpace(this.spaceAfter);
            }
            if (this.breakBefore == 59 || this.spaceBefore + this.imageArea.getHeight() > area.spaceLeft()) {
                return new Status(4);
            }
            if (this.breakBefore == 56) {
                return new Status(6);
            }
            if (this.breakBefore == 26) {
                return new Status(5);
            }
            if (area instanceof BlockArea) {
                object = (BlockArea)area;
                LineArea lineArea = ((BlockArea)object).getCurrentLineArea();
                if (lineArea == null) {
                    return new Status(2);
                }
                lineArea.addPending();
                if (this.imageArea.getContentWidth() > lineArea.getRemainingWidth() && (lineArea = ((BlockArea)object).createNextLineArea()) == null) {
                    return new Status(2);
                }
                lineArea.addInlineArea(this.imageArea);
            } else {
                area.addChild(this.imageArea);
                area.increaseHeight(this.imageArea.getContentHeight());
            }
            this.imageArea.setPage(area.getPage());
            if (this.breakAfter == 59) {
                this.marker = -1001;
                return new Status(4);
            }
            if (this.breakAfter == 56) {
                this.marker = -1001;
                return new Status(6);
            }
            if (this.breakAfter == 26) {
                this.marker = -1001;
                return new Status(5);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.log.error("Error while creating area : " + malformedURLException.getMessage());
        }
        catch (FopImageException fopImageException) {
            this.log.error("Error while creating area : " + fopImageException.getMessage());
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ExternalGraphic(fObj, propertyList);
        }
    }
}

