/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.LengthRange;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.LengthRangeProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;

public class BlockProgressionDimensionMaker
extends LengthRangeProperty.Maker {
    private static final Property.Maker s_MinimumMaker = new SP_MinimumMaker("block-progression-dimension.minimum");
    private static final Property.Maker s_OptimumMaker = new SP_OptimumMaker("block-progression-dimension.optimum");
    private static final Property.Maker s_MaximumMaker = new SP_MaximumMaker("block-progression-dimension.maximum");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("minimum");
    private Property m_defaultProp = null;

    protected BlockProgressionDimensionMaker(String string) {
        super(string);
    }

    public Property checkEnumValues(String string) {
        return this.m_shorthandMaker.checkEnumValues(string);
    }

    public Property compute(PropertyList propertyList) throws FOPException {
        FObj fObj = propertyList.getParentFObj();
        StringBuffer stringBuffer = new StringBuffer();
        Property property = null;
        stringBuffer.append(propertyList.wmRelToAbs(4));
        property = propertyList.getExplicitOrShorthand(stringBuffer.toString());
        property = property != null ? this.convertProperty(property, propertyList, fObj) : this.makeCompound(propertyList, fObj);
        stringBuffer.setLength(0);
        stringBuffer.append("min-");
        stringBuffer.append(propertyList.wmRelToAbs(4));
        Property property2 = propertyList.getExplicitOrShorthand(stringBuffer.toString());
        if (property2 != null) {
            this.setSubprop(property, "minimum", property2);
        }
        stringBuffer.setLength(0);
        stringBuffer.append("max-");
        stringBuffer.append(propertyList.wmRelToAbs(4));
        property2 = propertyList.getExplicitOrShorthand(stringBuffer.toString());
        if (property2 != null) {
            this.setSubprop(property, "maximum", property2);
        }
        return property;
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws FOPException {
        if (property instanceof LengthRangeProperty) {
            return property;
        }
        if (!(property instanceof EnumProperty)) {
            property = this.m_shorthandMaker.convertProperty(property, propertyList, fObj);
        }
        if (property != null) {
            Property property2 = this.makeCompound(propertyList, fObj);
            LengthRange lengthRange = property2.getLengthRange();
            lengthRange.setComponent("minimum", property, false);
            lengthRange.setComponent("optimum", property, false);
            lengthRange.setComponent("maximum", property, false);
            return property2;
        }
        return null;
    }

    protected String getDefaultForMaximum() {
        return "auto";
    }

    protected String getDefaultForMinimum() {
        return "auto";
    }

    protected String getDefaultForOptimum() {
        return "auto";
    }

    protected Property.Maker getSubpropMaker(String string) {
        if (string.equals("minimum")) {
            return s_MinimumMaker;
        }
        if (string.equals("optimum")) {
            return s_OptimumMaker;
        }
        if (string.equals("maximum")) {
            return s_MaximumMaker;
        }
        return super.getSubpropMaker(string);
    }

    public Property getSubpropValue(Property property, String string) {
        LengthRange lengthRange = property.getLengthRange();
        return lengthRange.getComponent(string);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    public boolean isCorrespondingForced(PropertyList propertyList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        stringBuffer.append(propertyList.wmRelToAbs(4));
        if (propertyList.getExplicit(stringBuffer.toString()) != null) {
            return true;
        }
        stringBuffer.setLength(0);
        stringBuffer.append("min-");
        stringBuffer.append(propertyList.wmRelToAbs(4));
        if (propertyList.getExplicit(stringBuffer.toString()) != null) {
            return true;
        }
        stringBuffer.setLength(0);
        stringBuffer.append("max-");
        stringBuffer.append(propertyList.wmRelToAbs(4));
        return propertyList.getExplicit(stringBuffer.toString()) != null;
    }

    public boolean isInherited() {
        return false;
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList propertyList, FObj fObj) throws FOPException {
        LengthRange lengthRange = new LengthRange();
        Property property = this.getSubpropMaker("minimum").make(propertyList, this.getDefaultForMinimum(), fObj);
        lengthRange.setComponent("minimum", property, true);
        property = this.getSubpropMaker("optimum").make(propertyList, this.getDefaultForOptimum(), fObj);
        lengthRange.setComponent("optimum", property, true);
        property = this.getSubpropMaker("maximum").make(propertyList, this.getDefaultForMaximum(), fObj);
        lengthRange.setComponent("maximum", property, true);
        return new LengthRangeProperty(lengthRange);
    }

    public static Property.Maker maker(String string) {
        return new BlockProgressionDimensionMaker(string);
    }

    protected Property setSubprop(Property property, String string, Property property2) {
        LengthRange lengthRange = property.getLengthRange();
        lengthRange.setComponent(string, property2, false);
        return property;
    }

    private static class SP_MinimumMaker
    extends LengthProperty.Maker {
        SP_MinimumMaker(String string) {
            super(string);
        }

        public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
            return new LengthBase(fObj, propertyList, 3);
        }

        protected boolean isAutoLengthAllowed() {
            return true;
        }
    }

    private static class SP_OptimumMaker
    extends LengthProperty.Maker {
        SP_OptimumMaker(String string) {
            super(string);
        }

        public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
            return new LengthBase(fObj, propertyList, 3);
        }

        protected boolean isAutoLengthAllowed() {
            return true;
        }
    }

    private static class SP_MaximumMaker
    extends LengthProperty.Maker {
        SP_MaximumMaker(String string) {
            super(string);
        }

        public PercentBase getPercentBase(FObj fObj, PropertyList propertyList) {
            return new LengthBase(fObj, propertyList, 3);
        }

        protected boolean isAutoLengthAllowed() {
            return true;
        }
    }
}

