/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.TTFCmapEntry;
import org.apache.fop.fonts.TTFDirTabEntry;
import org.apache.fop.fonts.TTFMtxEntry;
import org.apache.fop.fonts.UnicodeMapping;

public class TTFFile {
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    static String encoding = "WinAnsiEncoding";
    short firstChar = 0;
    boolean is_embeddable = true;
    boolean hasSerifs = true;
    Hashtable dirTabs;
    Hashtable kerningTab;
    Hashtable ansiKerningTab;
    Vector cmaps;
    Vector unicodeMapping;
    int upem;
    int nhmtx;
    int post_format;
    int loca_format;
    long lastLoca = 0L;
    int nglyphs;
    int nmglyphs;
    TTFMtxEntry[] mtx_tab;
    int[] mtx_encoded = null;
    String fontName = "";
    String fullName = "";
    String notice = "";
    String familyName = "";
    String subFamilyName = "";
    long italicAngle = 0L;
    long isFixedPitch = 0L;
    int fontBBox1 = 0;
    int fontBBox2 = 0;
    int fontBBox3 = 0;
    int fontBBox4 = 0;
    int capHeight = 0;
    int underlinePosition = 0;
    int underlineThickness = 0;
    int xHeight = 0;
    int ascender = 0;
    int descender = 0;
    short lastChar = 0;
    int[] ansiWidth;
    Hashtable ansiIndex;

    protected final boolean checkTTC(FontFileReader fontFileReader, String string, boolean bl) throws IOException {
        String string2 = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string2)) {
            fontFileReader.skip(4L);
            int n = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                lArray[n2] = fontFileReader.readTTFULong();
                ++n2;
            }
            if (bl) {
                System.out.println("This is a TrueType collection file with" + n + " fonts");
                System.out.println("Containing the following fonts: ");
            }
            boolean bl2 = false;
            long l = 0L;
            int n3 = 0;
            while (n3 < n) {
                fontFileReader.seek_set(lArray[n3]);
                this.readDirTabs(fontFileReader);
                this.readName(fontFileReader);
                if (this.fullName.equals(string)) {
                    bl2 = true;
                    l = lArray[n3];
                    if (bl) {
                        System.out.println("* " + this.fullName);
                    }
                } else if (bl) {
                    System.out.println(this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
                ++n3;
            }
            fontFileReader.seek_set(l);
            return bl2;
        }
        fontFileReader.seek_set(0L);
        return true;
    }

    private void createCMaps() {
        UnicodeMapping unicodeMapping;
        this.cmaps = new Vector();
        TTFCmapEntry tTFCmapEntry = new TTFCmapEntry();
        Enumeration enumeration = this.unicodeMapping.elements();
        UnicodeMapping unicodeMapping2 = unicodeMapping = (UnicodeMapping)enumeration.nextElement();
        tTFCmapEntry.unicodeStart = unicodeMapping.uIdx;
        tTFCmapEntry.glyphStartIndex = unicodeMapping.gIdx;
        while (enumeration.hasMoreElements()) {
            unicodeMapping = (UnicodeMapping)enumeration.nextElement();
            if (unicodeMapping2.uIdx + 1 != unicodeMapping.uIdx || unicodeMapping2.gIdx + 1 != unicodeMapping.gIdx) {
                tTFCmapEntry.unicodeEnd = unicodeMapping2.uIdx;
                this.cmaps.addElement(tTFCmapEntry);
                tTFCmapEntry = new TTFCmapEntry();
                tTFCmapEntry.unicodeStart = unicodeMapping.uIdx;
                tTFCmapEntry.glyphStartIndex = unicodeMapping.gIdx;
            }
            unicodeMapping2 = unicodeMapping;
        }
        tTFCmapEntry.unicodeEnd = unicodeMapping.uIdx;
        this.cmaps.addElement(tTFCmapEntry);
    }

    public Hashtable getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public Vector getCMaps() {
        return this.cmaps;
    }

    public int getCapHeight() {
        return this.get_ttf_funit(this.capHeight);
    }

    public String getCharSetName() {
        return encoding;
    }

    public int getCharWidth(int n) {
        return this.get_ttf_funit(this.ansiWidth[n]);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public int getFlags() {
        int n = 32;
        if (this.italicAngle != 0L) {
            n |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            n |= 2;
        }
        if (this.hasSerifs) {
            n |= 1;
        }
        return n;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{this.get_ttf_funit(this.fontBBox1), this.get_ttf_funit(this.fontBBox2), this.get_ttf_funit(this.fontBBox3), this.get_ttf_funit(this.fontBBox4)};
        return nArray;
    }

    public String getItalicAngle() {
        String string = Short.toString((short)(this.italicAngle / 65536L));
        return string;
    }

    public Hashtable getKerning() {
        return this.kerningTab;
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public int getLowerCaseAscent() {
        return this.get_ttf_funit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.get_ttf_funit(this.descender);
    }

    protected void getNumGlyphs(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "maxp", 4L);
        this.nglyphs = fontFileReader.readTTFUShort();
    }

    public String getPostscriptName() {
        if ("Regular".equals(this.subFamilyName) || "Roman".equals(this.subFamilyName)) {
            return this.familyName;
        }
        return String.valueOf(this.familyName) + "," + this.subFamilyName;
    }

    public String getStemV() {
        return "0";
    }

    public int[] getWidths() {
        int[] nArray = new int[this.mtx_tab.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.get_ttf_funit(this.mtx_tab[n].wx);
            ++n;
        }
        return nArray;
    }

    public String getWindowsName() {
        return new String(String.valueOf(this.familyName) + "," + this.subFamilyName);
    }

    public int getXHeight() {
        return this.get_ttf_funit(this.xHeight);
    }

    int get_ttf_funit(int n) {
        int n2;
        if (n < 0) {
            long l = n % this.upem;
            long l2 = 1000L * l;
            long l3 = l / l2;
            n2 = -(-1000 * n / this.upem - (int)l3);
        } else {
            n2 = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return n2;
    }

    private void initAnsiWidths() {
        this.ansiWidth = new int[256];
        int n = 0;
        while (n < 256) {
            this.ansiWidth[n] = this.mtx_tab[0].wx;
            ++n;
        }
        this.ansiIndex = new Hashtable();
        int n2 = 32;
        while (n2 < Glyphs.winAnsiEncoding.length) {
            Integer n3 = new Integer(n2);
            Integer n4 = new Integer(Glyphs.winAnsiEncoding[n2]);
            Vector<Integer> vector = (Vector<Integer>)this.ansiIndex.get(n4);
            if (vector == null) {
                vector = new Vector<Integer>();
                this.ansiIndex.put(n4, vector);
            }
            vector.addElement(n3);
            ++n2;
        }
    }

    public boolean isEmbeddable() {
        return this.is_embeddable;
    }

    public static void main(String[] stringArray) {
        try {
            TTFFile tTFFile = new TTFFile();
            FontFileReader fontFileReader = new FontFileReader(stringArray[0]);
            String string = null;
            if (stringArray.length >= 2) {
                string = stringArray[1];
            }
            tTFFile.readFont(fontFileReader, string);
            tTFFile.printStuff();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    public void printStuff() {
        System.out.println("Font name: " + this.fontName);
        System.out.println("Full name: " + this.fullName);
        System.out.println("Family name: " + this.familyName);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:    " + this.notice);
        System.out.println("xHeight:   " + this.get_ttf_funit(this.xHeight));
        System.out.println("capheight: " + this.get_ttf_funit(this.capHeight));
        int n = (int)(this.italicAngle >> 16);
        System.out.println("Italic: " + n);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.get_ttf_funit(this.ascender));
        System.out.println("Descender:   " + this.get_ttf_funit(this.descender));
        System.out.println("FontBBox:    [" + this.get_ttf_funit(this.fontBBox1) + " " + this.get_ttf_funit(this.fontBBox2) + " " + this.get_ttf_funit(this.fontBBox3) + " " + this.get_ttf_funit(this.fontBBox4) + "]");
    }

    private void print_max_min() {
        int n = 255;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mtx_tab.length) {
            if (this.mtx_tab[n3].index < n) {
                n = this.mtx_tab[n3].index;
            }
            if (this.mtx_tab[n3].index > n2) {
                n2 = this.mtx_tab[n3].index;
            }
            ++n3;
        }
        System.out.println("Min: " + n);
        System.out.println("Max: " + n2);
    }

    private boolean readCMAP(FontFileReader fontFileReader) throws IOException {
        int n;
        int n2;
        this.unicodeMapping = new Vector();
        int n3 = 0;
        this.seek_tab(fontFileReader, "cmap", 2L);
        int n4 = fontFileReader.readTTFUShort();
        long l = 0L;
        int n5 = 0;
        while (n5 < n4) {
            n2 = fontFileReader.readTTFUShort();
            n = fontFileReader.readTTFUShort();
            long l2 = fontFileReader.readTTFULong();
            if (n2 == 3 && n == 1) {
                l = l2;
            }
            ++n5;
        }
        if (l <= 0L) {
            System.out.println("Unicode cmap table not present");
            return false;
        }
        this.seek_tab(fontFileReader, "cmap", l);
        n2 = fontFileReader.readTTFUShort();
        n = fontFileReader.readTTFUShort();
        if (n2 == 4) {
            fontFileReader.skip(2L);
            int n6 = fontFileReader.readTTFUShort();
            int n7 = fontFileReader.readTTFUShort();
            int n8 = fontFileReader.readTTFUShort();
            int n9 = fontFileReader.readTTFUShort();
            int[] nArray = new int[n6 / 2];
            int[] nArray2 = new int[n6 / 2];
            int[] nArray3 = new int[n6 / 2];
            int[] nArray4 = new int[n6 / 2];
            int n10 = 0;
            while (n10 < n6 / 2) {
                nArray[n10] = fontFileReader.readTTFUShort();
                ++n10;
            }
            fontFileReader.skip(2L);
            int n11 = 0;
            while (n11 < n6 / 2) {
                nArray2[n11] = fontFileReader.readTTFUShort();
                ++n11;
            }
            int n12 = 0;
            while (n12 < n6 / 2) {
                nArray3[n12] = fontFileReader.readTTFShort();
                ++n12;
            }
            int n13 = fontFileReader.getCurrentPos();
            int n14 = 0;
            while (n14 < n6 / 2) {
                nArray4[n14] = fontFileReader.readTTFUShort();
                ++n14;
            }
            int n15 = fontFileReader.getCurrentPos();
            int n16 = 0;
            while (n16 < nArray2.length) {
                int n17 = nArray2[n16];
                while (n17 <= nArray[n16]) {
                    if (n17 < 256 && n17 > this.lastChar) {
                        this.lastChar = (short)n17;
                    }
                    if (n3 < this.mtx_tab.length) {
                        Object object;
                        Object object2;
                        int n18;
                        if (nArray4[n16] != 0) {
                            int n19 = n15 + (nArray4[n16] / 2 + (n17 - nArray2[n16]) + n16 - n6 / 2) * 2;
                            fontFileReader.seek_set(n19);
                            n18 = fontFileReader.readTTFUShort() + nArray3[n16] & 0xFFFF;
                            this.unicodeMapping.addElement(new UnicodeMapping(n18, n17));
                            this.mtx_tab[n18].unicodeIndex.addElement(new Integer(n17));
                            object2 = (Vector)this.ansiIndex.get(new Integer(n17));
                            if (object2 != null) {
                                object = ((Vector)object2).elements();
                                while (object.hasMoreElements()) {
                                    Integer n20 = (Integer)object.nextElement();
                                    this.ansiWidth[n20.intValue()] = this.mtx_tab[n18].wx;
                                }
                            }
                        } else {
                            n18 = n17 + nArray3[n16] & 0xFFFF;
                            if (n18 < this.mtx_tab.length) {
                                this.mtx_tab[n18].unicodeIndex.addElement(new Integer(n17));
                            } else {
                                System.out.println("Glyph " + n18 + " out of range: " + this.mtx_tab.length);
                            }
                            this.unicodeMapping.addElement(new UnicodeMapping(n18, n17));
                            if (n18 < this.mtx_tab.length) {
                                this.mtx_tab[n18].unicodeIndex.addElement(new Integer(n17));
                            } else {
                                System.out.println("Glyph " + n18 + " out of range: " + this.mtx_tab.length);
                            }
                            Vector vector = (Vector)this.ansiIndex.get(new Integer(n17));
                            if (vector != null) {
                                object2 = vector.elements();
                                while (object2.hasMoreElements()) {
                                    object = (Integer)object2.nextElement();
                                    this.ansiWidth[((Integer)object).intValue()] = this.mtx_tab[n18].wx;
                                }
                            }
                        }
                        if (n18 < this.mtx_tab.length && this.mtx_tab[n18].unicodeIndex.size() < 2) {
                            ++n3;
                        }
                    }
                    ++n17;
                }
                ++n16;
            }
        }
        return true;
    }

    protected void readDirTabs(FontFileReader fontFileReader) throws IOException {
        fontFileReader.skip(4L);
        int n = fontFileReader.readTTFUShort();
        fontFileReader.skip(6L);
        this.dirTabs = new Hashtable();
        TTFDirTabEntry[] tTFDirTabEntryArray = new TTFDirTabEntry[n];
        int n2 = 0;
        while (n2 < n) {
            tTFDirTabEntryArray[n2] = new TTFDirTabEntry();
            this.dirTabs.put(tTFDirTabEntryArray[n2].read(fontFileReader), tTFDirTabEntryArray[n2]);
            ++n2;
        }
    }

    public void readFont(FontFileReader fontFileReader) throws IOException {
        this.readFont(fontFileReader, null);
    }

    public void readFont(FontFileReader fontFileReader, String string) throws IOException {
        if (!this.checkTTC(fontFileReader, string, true)) {
            throw new IOException("Failed to read font");
        }
        this.readDirTabs(fontFileReader);
        this.readFontHeader(fontFileReader);
        this.getNumGlyphs(fontFileReader);
        System.out.println("Number of glyphs in font: " + this.nglyphs);
        this.readHorizontalHeader(fontFileReader);
        this.readHorizontalMetrics(fontFileReader);
        this.initAnsiWidths();
        this.readPostscript(fontFileReader);
        this.readOS2(fontFileReader);
        this.readIndexToLocation(fontFileReader);
        this.readGlyf(fontFileReader);
        this.readName(fontFileReader);
        this.readPCLT(fontFileReader);
        this.readCMAP(fontFileReader);
        this.createCMaps();
        this.readKerning(fontFileReader);
    }

    protected void readFontHeader(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "head", 18L);
        this.upem = fontFileReader.readTTFUShort();
        fontFileReader.skip(16L);
        this.fontBBox1 = fontFileReader.readTTFShort();
        this.fontBBox2 = fontFileReader.readTTFShort();
        this.fontBBox3 = fontFileReader.readTTFShort();
        this.fontBBox4 = fontFileReader.readTTFShort();
        fontFileReader.skip(6L);
        this.loca_format = fontFileReader.readTTFShort();
    }

    private final void readGlyf(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int n = 0;
        while (n < this.nglyphs - 1) {
            if (this.mtx_tab[n].offset != this.mtx_tab[n + 1].offset) {
                fontFileReader.seek_set(tTFDirTabEntry.offset + this.mtx_tab[n].offset);
                fontFileReader.skip(2L);
                this.mtx_tab[n].bbox[0] = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[1] = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[2] = fontFileReader.readTTFShort();
                this.mtx_tab[n].bbox[3] = fontFileReader.readTTFShort();
            } else {
                this.mtx_tab[n].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n].bbox[1] = this.mtx_tab[0].bbox[1];
                this.mtx_tab[n].bbox[2] = this.mtx_tab[0].bbox[2];
                this.mtx_tab[n].bbox[3] = this.mtx_tab[0].bbox[3];
            }
            ++n;
        }
        long l = ((TTFDirTabEntry)this.dirTabs.get((Object)"glyf")).offset;
        int n2 = 0;
        while (n2 < this.nglyphs) {
            if (n2 + 1 >= this.mtx_tab.length || this.mtx_tab[n2].offset != this.mtx_tab[n2 + 1].offset) {
                fontFileReader.seek_set(l + this.mtx_tab[n2].offset);
                fontFileReader.skip(2L);
                this.mtx_tab[n2].bbox[0] = fontFileReader.readTTFShort();
                this.mtx_tab[n2].bbox[1] = fontFileReader.readTTFShort();
                this.mtx_tab[n2].bbox[2] = fontFileReader.readTTFShort();
                this.mtx_tab[n2].bbox[3] = fontFileReader.readTTFShort();
            } else {
                this.mtx_tab[n2].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n2].bbox[1] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n2].bbox[2] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n2].bbox[3] = this.mtx_tab[0].bbox[0];
            }
            ++n2;
        }
    }

    protected void readHorizontalHeader(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "hhea", 4L);
        this.ascender = fontFileReader.readTTFShort();
        this.descender = fontFileReader.readTTFShort();
        fontFileReader.skip(26L);
        this.nhmtx = fontFileReader.readTTFUShort();
    }

    protected void readHorizontalMetrics(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "hmtx", 0L);
        int n = this.nglyphs > this.nhmtx ? this.nglyphs : this.nhmtx;
        this.mtx_tab = new TTFMtxEntry[n];
        int n2 = 0;
        while (n2 < n) {
            this.mtx_tab[n2] = new TTFMtxEntry();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.nhmtx) {
            this.mtx_tab[n3].wx = fontFileReader.readTTFUShort();
            this.mtx_tab[n3].lsb = fontFileReader.readTTFShort();
            ++n3;
        }
        if (this.nhmtx < n) {
            int n4 = this.mtx_tab[this.nhmtx - 1].wx;
            int n5 = this.nhmtx;
            while (n5 < n) {
                this.mtx_tab[n5].wx = n4;
                this.mtx_tab[n5].lsb = fontFileReader.readTTFShort();
                ++n5;
            }
        }
    }

    protected final void readIndexToLocation(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "loca", 0L);
        int n = 0;
        while (n < this.nglyphs) {
            this.mtx_tab[n].offset = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
            ++n;
        }
        this.lastLoca = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
    }

    private final void readKerning(FontFileReader fontFileReader) throws IOException {
        this.kerningTab = new Hashtable();
        this.ansiKerningTab = new Hashtable();
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (tTFDirTabEntry != null) {
            Hashtable hashtable;
            Object object;
            this.seek_tab(fontFileReader, "kern", 2L);
            int n = fontFileReader.readTTFUShort();
            while (n > 0) {
                fontFileReader.skip(4L);
                int n2 = fontFileReader.readTTFUShort();
                if ((n2 & 1) == 0 || (n2 & 2) != 0 || (n2 & 4) != 0) {
                    return;
                }
                if (n2 >> 8 == 0) {
                    n2 = fontFileReader.readTTFUShort();
                    fontFileReader.skip(6L);
                    while (n2-- > 0) {
                        int n3 = fontFileReader.readTTFUShort();
                        int n4 = fontFileReader.readTTFUShort();
                        short s = fontFileReader.readTTFShort();
                        if (s == 0) continue;
                        object = new Integer(n3);
                        hashtable = (Hashtable)this.kerningTab.get(object);
                        if (hashtable == null) {
                            hashtable = new Hashtable();
                        }
                        hashtable.put(new Integer(n4), new Integer(this.get_ttf_funit(s)));
                        this.kerningTab.put(object, hashtable);
                    }
                }
                --n;
            }
            Enumeration enumeration = this.kerningTab.keys();
            while (enumeration.hasMoreElements()) {
                Integer[] integerArray;
                Integer n5;
                Integer n6 = (Integer)enumeration.nextElement();
                Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
                Hashtable hashtable3 = (Hashtable)this.kerningTab.get(n6);
                object = hashtable3.keys();
                while (object.hasMoreElements()) {
                    hashtable = (Integer)object.nextElement();
                    n5 = (Integer)hashtable3.get(hashtable);
                    integerArray = this.mtx_tab[((Integer)((Object)hashtable)).intValue()].unicodeIndex.elements();
                    while (integerArray.hasMoreElements()) {
                        Integer n7 = (Integer)integerArray.nextElement();
                        Integer[] integerArray2 = this.unicodeToWinAnsi(n7);
                        int n8 = 0;
                        while (n8 < integerArray2.length) {
                            hashtable2.put(integerArray2[n8], n5);
                            ++n8;
                        }
                    }
                }
                if (hashtable2.size() <= 0) continue;
                hashtable = this.mtx_tab[n6.intValue()].unicodeIndex.elements();
                while (hashtable.hasMoreElements()) {
                    n5 = (Integer)hashtable.nextElement();
                    integerArray = this.unicodeToWinAnsi(n5);
                    int n9 = 0;
                    while (n9 < integerArray.length) {
                        this.ansiKerningTab.put(integerArray[n9], hashtable2);
                        ++n9;
                    }
                }
            }
        }
    }

    private final void readName(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "name", 2L);
        int n = fontFileReader.getCurrentPos();
        int n2 = fontFileReader.readTTFUShort();
        int n3 = fontFileReader.readTTFUShort() + n - 2;
        n += 4;
        while (n2-- > 0) {
            fontFileReader.seek_set(n);
            int n4 = fontFileReader.readTTFUShort();
            int n5 = fontFileReader.readTTFUShort();
            int n6 = fontFileReader.readTTFUShort();
            int n7 = fontFileReader.readTTFUShort();
            int n8 = fontFileReader.readTTFUShort();
            if (!(n4 != 1 && n4 != 3 || n5 != 0 && n5 != 1 || n7 != 1 && n7 != 2 && n7 != 0 && n7 != 4 && n7 != 6)) {
                fontFileReader.seek_set(n3 + fontFileReader.readTTFUShort());
                String string = fontFileReader.readTTFString(n8);
                switch (n7) {
                    case 0: {
                        this.notice = string;
                        break;
                    }
                    case 1: {
                        this.familyName = string;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = string;
                        break;
                    }
                    case 4: {
                        this.fullName = string;
                        break;
                    }
                    case 6: {
                        this.fontName = string;
                        break;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            n += 12;
        }
    }

    private final void readOS2(FontFileReader fontFileReader) throws IOException {
        if (this.dirTabs.get("OS/2") != null) {
            this.seek_tab(fontFileReader, "OS/2", 8L);
            int n = fontFileReader.readTTFUShort();
            this.is_embeddable = n != 2;
        } else {
            this.is_embeddable = true;
        }
    }

    private final void readPCLT(FontFileReader fontFileReader) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (tTFDirTabEntry != null) {
            fontFileReader.seek_set(tTFDirTabEntry.offset + 4L + 4L + 2L);
            this.xHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(4L);
            this.capHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(34L);
            int n = fontFileReader.readTTFUByte();
            n >>= 6;
            this.hasSerifs = (n &= 3) != 1;
        } else {
            int n = 0;
            while (n < this.mtx_tab.length) {
                if ("H".equals(this.mtx_tab[n].name)) {
                    this.capHeight = this.mtx_tab[n].bbox[3] - this.mtx_tab[n].bbox[1];
                }
                ++n;
            }
        }
    }

    private final void readPostscript(FontFileReader fontFileReader) throws IOException {
        this.seek_tab(fontFileReader, "post", 0L);
        this.post_format = fontFileReader.readTTFLong();
        this.italicAngle = fontFileReader.readTTFULong();
        this.underlinePosition = fontFileReader.readTTFShort();
        this.underlineThickness = fontFileReader.readTTFShort();
        this.isFixedPitch = fontFileReader.readTTFULong();
        fontFileReader.skip(16L);
        switch (this.post_format) {
            case 65536: {
                int n = 0;
                while (n < Glyphs.mac_glyph_names.length) {
                    this.mtx_tab[n].name = Glyphs.mac_glyph_names[n];
                    ++n;
                }
                break;
            }
            case 131072: {
                int n = 0;
                int n2 = fontFileReader.readTTFUShort();
                int n3 = 0;
                while (n3 < n2) {
                    this.mtx_tab[n3].index = fontFileReader.readTTFUShort();
                    if (this.mtx_tab[n3].index > 257) {
                        ++n;
                    }
                    ++n3;
                }
                String[] stringArray = new String[n];
                n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray[n3] = fontFileReader.readTTFString(fontFileReader.readTTFUByte());
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    if (this.mtx_tab[n3].index < 258) {
                        this.mtx_tab[n3].name = Glyphs.mac_glyph_names[this.mtx_tab[n3].index];
                    } else {
                        int n4 = this.mtx_tab[n3].index - 258;
                        this.mtx_tab[n3].name = stringArray[n4];
                    }
                    ++n3;
                }
                break;
            }
            case 196608: {
                System.out.println("Postscript format 3");
                break;
            }
            default: {
                System.out.println("Unknown Postscript format : " + this.post_format);
            }
        }
    }

    void seek_tab(FontFileReader fontFileReader, String string, long l) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(string);
        if (tTFDirTabEntry == null) {
            System.out.println("Dirtab " + string + " not found.");
            return;
        }
        fontFileReader.seek_set(tTFDirTabEntry.offset + l);
    }

    private Integer[] unicodeToWinAnsi(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 32;
        while (n2 < Glyphs.winAnsiEncoding.length) {
            if (n == Glyphs.winAnsiEncoding[n2]) {
                vector.addElement(new Integer(n2));
            }
            ++n2;
        }
        Object[] objectArray = new Integer[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

