/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.JpegImage;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFXObject
extends PDFObject {
    private boolean isPS = false;
    private PDFDocument pdfDoc;
    private PDFICCStream pdfICCStream;
    FopImage fopimage;
    int Xnum;

    public PDFXObject(int n, int n2, FopImage fopImage) {
        this(n, n2, fopImage, null);
    }

    public PDFXObject(int n, int n2, FopImage fopImage, PDFDocument pDFDocument) {
        super(n);
        this.Xnum = n2;
        if (fopImage == null) {
            MessageHandler.errorln("FISH");
        }
        this.fopimage = fopImage;
        this.pdfDoc = pDFDocument;
        this.pdfICCStream = null;
        try {
            if (this.fopimage instanceof JpegImage) {
                this.fopimage.getBitmaps();
                JpegImage jpegImage = (JpegImage)this.fopimage;
                if (jpegImage.getColorSpace().hasICCProfile()) {
                    this.pdfICCStream = this.pdfDoc.makePDFICCStream();
                    this.pdfICCStream.setColorSpace(jpegImage.getColorSpace());
                    this.pdfICCStream.addDefaultFilters();
                }
            }
        }
        catch (Exception exception) {
            MessageHandler.errorln("Error while reading image " + this.fopimage.getURL() + ": " + exception.getMessage());
        }
    }

    public int getXNumber() {
        return this.Xnum;
    }

    protected int output(OutputStream outputStream) throws IOException {
        int n;
        block20: {
            n = 0;
            boolean bl = false;
            try {
                Object object;
                if (this.fopimage instanceof EPSImage) {
                    byte[] byArray;
                    byte[] byArray2;
                    byte[] byArray3;
                    this.isPS = true;
                    EPSImage ePSImage = (EPSImage)this.fopimage;
                    int[] nArray = ePSImage.getBBox();
                    int n2 = nArray[2] - nArray[0];
                    int n3 = nArray[3] - nArray[1];
                    PDFStream pDFStream = new PDFStream(0);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("%%BeginDocument: " + ePSImage.getDocName() + "\n");
                    stringBuffer.append("userdict begin                 % Push userdict on dict stack\n");
                    stringBuffer.append("/PreEPS_state save def\n");
                    stringBuffer.append("/dict_stack countdictstack def\n");
                    stringBuffer.append("/ops_count count 1 sub def\n");
                    stringBuffer.append("/showpage {} def\n");
                    stringBuffer.append(String.valueOf(1.0 / (double)n2) + " " + 1.0 / (double)n3 + " scale\n");
                    stringBuffer.append(String.valueOf(-nArray[0]) + " " + -nArray[1] + " translate\n");
                    stringBuffer.append(String.valueOf(nArray[0]) + " " + nArray[1] + " " + n2 + " " + n3 + " rectclip\n");
                    stringBuffer.append("newpath\n");
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("%%EndDocument\n");
                    stringBuffer2.append("count ops_count sub {pop} repeat\n");
                    stringBuffer2.append("countdictstack dict_stack sub {end} repeat\n");
                    stringBuffer2.append("PreEPS_state restore\n");
                    stringBuffer2.append("end % userdict\n");
                    try {
                        byArray3 = stringBuffer.toString().getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        byArray3 = stringBuffer.toString().getBytes();
                    }
                    try {
                        byArray2 = stringBuffer2.toString().getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        byArray2 = stringBuffer2.toString().getBytes();
                    }
                    byte[] byArray4 = new byte[byArray3.length + byArray2.length + this.fopimage.getBitmaps().length];
                    System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                    System.arraycopy(this.fopimage.getBitmaps(), 0, byArray4, byArray3.length, this.fopimage.getBitmaps().length);
                    System.arraycopy(byArray2, 0, byArray4, byArray3.length + this.fopimage.getBitmaps().length, byArray2.length);
                    pDFStream.setData(byArray4);
                    pDFStream.addDefaultFilters();
                    String string = pDFStream.applyFilters();
                    String string2 = String.valueOf(this.number) + " " + this.generation + " obj\n";
                    string2 = String.valueOf(string2) + "<</Type /XObject\n";
                    string2 = String.valueOf(string2) + "/Subtype /PS\n";
                    string2 = String.valueOf(string2) + "/Length " + pDFStream.getDataLength();
                    this.fopimage.close();
                    string2 = String.valueOf(string2) + string;
                    string2 = String.valueOf(string2) + ">>\n";
                    try {
                        byArray = string2.getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        byArray = string2.getBytes();
                    }
                    outputStream.write(byArray);
                    n += byArray.length;
                    n += pDFStream.outputStreamData(outputStream);
                    try {
                        byArray = "endobj\n".getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        byArray = "endobj\n".getBytes();
                    }
                    outputStream.write(byArray);
                    n += byArray.length;
                    break block20;
                }
                PDFStream pDFStream = new PDFStream(0);
                pDFStream.setData(this.fopimage.getBitmaps());
                if (this.fopimage.getPDFFilter() != null) {
                    pDFStream.addFilter(this.fopimage.getPDFFilter());
                }
                pDFStream.addDefaultFilters();
                String string = pDFStream.applyFilters();
                String string3 = String.valueOf(this.number) + " " + this.generation + " obj\n";
                string3 = String.valueOf(string3) + "<</Type /XObject\n";
                string3 = String.valueOf(string3) + "/Subtype /Image\n";
                string3 = String.valueOf(string3) + "/Name /Im" + this.Xnum + "\n";
                string3 = String.valueOf(string3) + "/Length " + pDFStream.getDataLength() + "\n";
                string3 = String.valueOf(string3) + "/Width " + this.fopimage.getWidth() + "\n";
                string3 = String.valueOf(string3) + "/Height " + this.fopimage.getHeight() + "\n";
                string3 = String.valueOf(string3) + "/BitsPerComponent " + this.fopimage.getBitsPerPixel() + "\n";
                if (this.pdfICCStream != null) {
                    string3 = String.valueOf(string3) + "/ColorSpace [/ICCBased " + this.pdfICCStream.referencePDF() + "]\n";
                } else {
                    object = this.fopimage.getColorSpace();
                    string3 = String.valueOf(string3) + "/ColorSpace /" + ((ColorSpace)object).getColorSpacePDFString() + "\n";
                }
                if (this.fopimage.getColorSpace().getColorSpace() == ColorSpace.DEVICE_CMYK && this.fopimage.invertImage()) {
                    string3 = String.valueOf(string3) + "/Decode [ 1.0 0.0 1.0 0.0 1.0 0.0 1.1 0.0 ]\n";
                }
                if (this.fopimage.isTransparent()) {
                    object = this.fopimage.getTransparentColor();
                    string3 = String.valueOf(string3) + "/Mask [" + ((PDFColor)object).red255() + " " + ((PDFColor)object).red255() + " " + ((PDFColor)object).green255() + " " + ((PDFColor)object).green255() + " " + ((PDFColor)object).blue255() + " " + ((PDFColor)object).blue255() + "]\n";
                }
                string3 = String.valueOf(string3) + string;
                string3 = String.valueOf(string3) + ">>\n";
                this.fopimage.close();
                try {
                    object = string3.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = string3.getBytes();
                }
                outputStream.write((byte[])object);
                n += ((Object)object).length;
                n += pDFStream.outputStreamData(outputStream);
                try {
                    object = "endobj\n".getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = "endobj\n".getBytes();
                }
                outputStream.write((byte[])object);
                n += ((Object)object).length;
            }
            catch (FopImageException fopImageException) {
                MessageHandler.errorln("Error in XObject : " + fopImageException.getMessage());
            }
        }
        return n;
    }

    byte[] toPDF() {
        return null;
    }
}

