/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.awt.FontMetricsMapper;
import org.apache.fop.render.awt.FontSetup;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class AWTRenderer
extends AbstractRenderer
implements Printable,
Pageable {
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected double scaleFactor = 100.0;
    protected int pageNumber = 0;
    protected Vector pageList = new Vector();
    protected ProgressListener progressListener = null;
    protected Translator res = null;
    protected Hashtable fontNames = new Hashtable();
    protected Hashtable fontStyles = new Hashtable();
    protected Color saveColor = null;
    protected IDReferences idReferences = null;
    private BufferedImage pageImage = null;
    protected Graphics2D graphics = null;
    protected String currentFontName;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected Font lastFont = null;
    protected Color lastColor = null;
    protected Component parent;
    protected Hashtable options;

    public AWTRenderer(Translator translator) {
        this.res = translator;
    }

    protected void addFilledRect(int n, int n2, int n3, int n4, ColorType colorType) {
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        this.addRect(n, n2, n3, n4, f, f2, f3, f, f2, f3);
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, float f, float f2, float f3) {
        int n6;
        int n7;
        this.graphics.setColor(new Color(f, f2, f3));
        int n8 = n;
        int n9 = n2;
        if (n == n3) {
            n7 = n4 - n2;
            if (n7 > 0) {
                n7 = -n7;
                n9 = n4;
            }
            if ((n6 = n5) < 0) {
                n6 = -n6;
                n8 -= n6;
            }
        } else {
            n6 = n3 - n;
            if (n6 < 0) {
                n6 = -n6;
                n8 = n3;
            }
            if ((n7 = n5) > 0) {
                n7 = -n7;
                n9 -= n7;
            }
        }
        this.addRect(n8, n9, n6, n7, false);
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3) {
        this.graphics.setColor(new Color(f, f2, f3));
        this.addRect(n, n2, n3, n4, true);
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6) {
        this.graphics.setColor(new Color(f, f2, f3));
        this.addRect(n, n2, n3, n4, true);
        this.graphics.setColor(new Color(f4, f5, f6));
        this.addRect(n, n2, n3, n4, false);
    }

    protected void addRect(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = (n + 500) / 1000;
        int n6 = this.pageHeight - (n2 + 500) / 1000;
        int n7 = (n + n3 + 500) / 1000;
        int n8 = this.pageHeight - (n2 + n4 + 500) / 1000;
        if (bl) {
            this.graphics.drawRect(n5, n6, n7 - n5, n8 - n6);
        } else {
            if (n3 != 0 && n7 == n5) {
                ++n7;
            }
            if (n4 != 0 && n8 == n6) {
                ++n8;
            }
            this.graphics.fillRect(n5, n6, n7 - n5, n8 - n6);
        }
    }

    public static Color colorType2Color(ColorType colorType) {
        if (colorType == null) {
            return null;
        }
        return new Color(colorType.red(), colorType.green(), colorType.blue());
    }

    protected void doFrame(Area area) {
        ColorType colorType;
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, n -= area.getPaddingLeft(), n4 += area.getPaddingTop(), n2, n3);
        n -= area.getBorderLeftWidth();
        n4 += area.getBorderTopWidth();
        n2 = n2 + area.getBorderLeftWidth() + area.getBorderRightWidth();
        n3 = n3 + area.getBorderTopWidth() + area.getBorderBottomWidth();
        BorderAndPadding borderAndPadding = area.getBorderAndPadding();
        if (area.getBorderTopWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(0);
            this.addLine(n, n4, n + n2, n4, -area.getBorderTopWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
        if (area.getBorderLeftWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(3);
            this.addLine(n, n4, n, n4 - n3, area.getBorderLeftWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
        if (area.getBorderRightWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(1);
            this.addLine(n + n2, n4, n + n2, n4 - n3, -area.getBorderRightWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
        if (area.getBorderBottomWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(2);
            this.addLine(n, n4 - n3, n + n2, n4 - n3, area.getBorderBottomWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
    }

    protected void drawFrame() {
        int n = this.pageWidth;
        int n2 = this.pageHeight;
        this.graphics.setColor(Color.white);
        this.graphics.fillRect(0, 0, n, n2);
        this.graphics.setColor(Color.black);
        this.graphics.drawRect(-1, -1, n + 2, n2 + 2);
        this.graphics.drawLine(n + 2, 0, n + 2, n2 + 2);
        this.graphics.drawLine(n + 3, 1, n + 3, n2 + 3);
        this.graphics.drawLine(0, n2 + 2, n + 2, n2 + 2);
        this.graphics.drawLine(1, n2 + 3, n + 3, n2 + 3);
    }

    protected void drawImageClipped(int n, int n2, int n3, int n4, int n5, int n6, FopImage fopImage, FontState fontState) {
    }

    protected void drawImageScaled(int n, int n2, int n3, int n4, FopImage fopImage, FontState fontState) {
    }

    protected Rectangle2D getBounds(Area area) {
        return new Rectangle2D.Double(this.currentAreaContainerXPosition, this.currentYPosition, area.getAllocationWidth(), area.getHeight());
    }

    public BufferedImage getLastRenderedPage() {
        return this.pageImage;
    }

    public int getNumberOfPages() {
        return this.pageList.size();
    }

    public int getPageCount() {
        return this.pageList.size();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        double d;
        if (n >= this.pageList.size()) {
            return null;
        }
        Page page = (Page)this.pageList.elementAt(n);
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        double d2 = page.getWidth();
        if (d2 > (d = (double)page.getHeight())) {
            paper.setImageableArea(0.0, 0.0, d / 1000.0, d2 / 1000.0);
            paper.setSize(d / 1000.0, d2 / 1000.0);
            pageFormat.setOrientation(0);
        } else {
            paper.setImageableArea(0.0, 0.0, d2 / 1000.0, d / 1000.0);
            paper.setSize(d2 / 1000.0, d / 1000.0);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.pageList.size()) {
            return 1;
        }
        Graphics2D graphics2D = this.graphics;
        int n2 = this.pageNumber;
        this.graphics = (Graphics2D)graphics;
        Page page = (Page)this.pageList.elementAt(n);
        this.renderPage(page);
        this.graphics = graphics2D;
        return 0;
    }

    public void removePage(int n) {
        this.pageList.removeElementAt(n);
    }

    public void render(int n) {
        if (n >= this.pageList.size()) {
            return;
        }
        try {
            this.render((Page)this.pageList.elementAt(n));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void render(Page page) throws IOException {
        this.idReferences = page.getIDReferences();
        this.pageWidth = (int)((double)((float)page.getWidth() / 1000.0f) + 0.5);
        this.pageHeight = (int)((double)((float)page.getHeight() / 1000.0f) + 0.5);
        this.pageImage = new BufferedImage(this.pageWidth * (int)this.scaleFactor / 100, this.pageHeight * (int)this.scaleFactor / 100, 1);
        this.graphics = this.pageImage.createGraphics();
        this.transform(this.graphics, this.scaleFactor, 0.0);
        this.drawFrame();
        this.renderPage(page);
    }

    public void render(Page page, OutputStream outputStream) throws IOException {
        this.pageList.addElement(page);
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        foreignObjectArea.getObject().render(this);
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage == null) {
            this.log.error("Error while loading image : area.getImage() is null");
            this.addRect(n, n2, n3, n4, true);
            Font font = this.graphics.getFont();
            Font font2 = new Font(font.getFontName(), font.getStyle(), 8);
            this.graphics.setFont(font2);
            this.graphics.drawString("area.getImage() is null", (n + 500) / 1000, this.pageHeight - (n2 + 500) / 1000);
            this.graphics.setFont(font);
        } else if (fopImage instanceof SVGImage) {
            try {
                SVGDocument sVGDocument = ((SVGImage)fopImage).getSVGDocument();
                this.renderSVGDocument((Document)sVGDocument, n, n2);
            }
            catch (FopImageException fopImageException) {}
        } else {
            String string = fopImage.getURL();
            try {
                URL uRL = new URL(string);
                ImageIcon imageIcon = new ImageIcon(uRL);
                Image image = imageIcon.getImage();
                int n5 = (n + 500) / 1000;
                int n6 = this.pageHeight - (n2 + 500) / 1000;
                int n7 = (n + n3 + 500) / 1000;
                int n8 = this.pageHeight - (n2 + n4 + 500) / 1000;
                this.graphics.drawImage(image, n5, n6, n7 - n5, n6 - n8, null);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.currentXPosition += imageArea.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        if (inlineSpace.getUnderlined() || inlineSpace.getOverlined() || inlineSpace.getLineThrough()) {
            int n = this.currentXPosition;
            int n2 = this.currentYPosition;
            Font font = this.graphics.getFont();
            if (this.lastFont != null) {
                this.graphics.setFont(this.lastFont);
            }
            Color color = this.graphics.getColor();
            if (this.lastColor != null) {
                this.graphics.setColor(this.lastColor);
            }
            int n3 = (inlineSpace.getSize() + 500) / 1000;
            this.renderTextDecoration(n, n2, n3, this.graphics.getFont(), " ", inlineSpace.getUnderlined(), inlineSpace.getOverlined(), inlineSpace.getLineThrough());
            this.graphics.setFont(font);
            this.graphics.setColor(color);
        }
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getLeaderLength();
        int n4 = leaderArea.getHeight();
        int n5 = leaderArea.getRuleThickness();
        int n6 = leaderArea.getRuleStyle();
        float f = leaderArea.getRed();
        float f2 = leaderArea.getGreen();
        float f3 = leaderArea.getBlue();
        Color color = this.graphics.getColor();
        this.graphics.setColor(new Color(f, f2, f3));
        this.addRect(n, n2, n3, -n5, false);
        this.graphics.setColor(color);
        this.currentXPosition += leaderArea.getContentWidth();
    }

    public void renderPage(Page page) {
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = sVGArea.getContentWidth();
        int n4 = sVGArea.getHeight();
        Document document = sVGArea.getSVGDocument();
        this.renderSVGDocument(document, n, n2);
        this.currentXPosition += sVGArea.getContentWidth();
    }

    protected void renderSVGDocument(Document document, int n, int n2) {
        GraphicsNode graphicsNode;
        MUserAgent mUserAgent = new MUserAgent(new AffineTransform());
        mUserAgent.setLogger(this.log);
        GVTBuilder gVTBuilder = new GVTBuilder();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)mUserAgent);
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, document);
        }
        catch (Exception exception) {
            this.log.error("svg graphic could not be built: " + exception.getMessage(), (Throwable)exception);
            return;
        }
        float f = (float)bridgeContext.getDocumentSize().getWidth() * 1000.0f;
        float f2 = (float)bridgeContext.getDocumentSize().getHeight() * 1000.0f;
        this.graphics.translate((n + 500) / 1000, this.pageHeight - (n2 + 500) / 1000);
        SVGSVGElement sVGSVGElement = ((SVGDocument)document).getRootElement();
        AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform((Element)sVGSVGElement, (float)(f / 1000.0f), (float)(f2 / 1000.0f));
        AffineTransform affineTransform2 = null;
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        if (!affineTransform.isIdentity()) {
            this.graphics.transform(affineTransform);
        }
        try {
            graphicsNode.paint(this.graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (affineTransform2 != null && !affineTransform2.isIdentity()) {
            this.graphics.transform(affineTransform2);
        }
        this.graphics.translate(-(n + 500) / 1000, (n2 + 500) / 1000 - this.pageHeight);
    }

    protected void renderTextDecoration(int n, int n2, int n3, Font font, String string, boolean bl, boolean bl2, boolean bl3) {
        int n4;
        if (!(bl || bl2 || bl3)) {
            return;
        }
        int n5 = (n + 500) / 1000;
        int n6 = this.pageHeight - (n2 + 500) / 1000;
        FontMetrics fontMetrics = this.graphics.getFontMetrics(font);
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, this.graphics);
        int n7 = (int)lineMetrics.getUnderlineThickness();
        if (n7 < 1) {
            n7 = 1;
        }
        if (bl) {
            n4 = fontMetrics.getDescent() / 2;
            this.graphics.fillRect(n5, n6 + n4, n3, n7);
        }
        if (bl2) {
            n4 = -((int)((double)lineMetrics.getAscent() * 0.8));
            this.graphics.fillRect(n5, n6 + n4, n3, n7);
        }
        if (bl3) {
            n4 = (int)lineMetrics.getStrikethroughThickness();
            if (n4 < 1) {
                n4 = 1;
            }
            int n8 = (int)lineMetrics.getStrikethroughOffset();
            this.graphics.fillRect(n5, n6 + n8, n3, n4);
        }
    }

    public void renderWordArea(WordArea wordArea) {
        String string;
        FontMetricsMapper fontMetricsMapper;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = wordArea.getFontState().getFontName();
        int n = wordArea.getFontState().getFontSize();
        float f = wordArea.getRed();
        float f2 = wordArea.getGreen();
        float f3 = wordArea.getBlue();
        try {
            fontMetricsMapper = (FontMetricsMapper)wordArea.getFontState().getFontInfo().getMetricsFor(string2);
        }
        catch (FOPException fOPException) {
            fontMetricsMapper = new FontMetricsMapper("MonoSpaced", 0, this.graphics);
        }
        if (!string2.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string2;
            this.currentFontSize = n;
        }
        if (f != this.currentRed || f2 != this.currentGreen || f3 != this.currentBlue) {
            this.currentRed = f;
            this.currentGreen = f2;
            this.currentBlue = f3;
        }
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        if (wordArea.getPageNumberID() != null) {
            string = this.idReferences.getPageNumber(wordArea.getPageNumberID());
            if (string == null) {
                string = "";
            }
        } else {
            string = wordArea.getText();
        }
        Color color = this.graphics.getColor();
        Font font = this.graphics.getFont();
        Font font2 = fontMetricsMapper.getFont(n);
        if (this.saveColor != null) {
            if ((float)this.saveColor.getRed() != f || (float)this.saveColor.getGreen() != f2 || (float)this.saveColor.getBlue() != f3) {
                this.saveColor = new Color(f, f2, f3);
            }
        } else {
            this.saveColor = new Color(f, f2, f3);
        }
        this.graphics.setColor(this.saveColor);
        this.graphics.setFont(font2);
        int n4 = (n2 + 500) / 1000;
        int n5 = this.pageHeight - (n3 + 500) / 1000;
        this.graphics.drawString(string, n4, n5);
        FontMetrics fontMetrics = this.graphics.getFontMetrics(font2);
        int n6 = (int)fontMetrics.getStringBounds(string, this.graphics).getWidth();
        this.renderTextDecoration(n2, n3, n6, font2, " ", wordArea.getUnderlined(), wordArea.getOverlined(), wordArea.getLineThrough());
        this.lastFont = this.graphics.getFont();
        this.lastColor = this.graphics.getColor();
        this.graphics.setFont(font);
        this.graphics.setColor(color);
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setComponent(Component component) {
        this.parent = component;
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public void setProducer(String string) {
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        FontSetup.setup(fontInfo, bufferedImage.createGraphics());
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.render(0);
    }

    public void transform(Graphics2D graphics2D, double d, double d2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.rotate(d2);
        affineTransform.scale(d / 100.0, d / 100.0);
        graphics2D.setTransform(affineTransform);
    }

    protected class MUserAgent
    extends SVGUserAgent {
        protected MUserAgent(AffineTransform affineTransform) {
            super(affineTransform);
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point(0, 0);
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public Dimension2D getViewportSize() {
            return new Dimension(100, 100);
        }

        public void openLink(SVGAElement sVGAElement) {
        }

        public void setSVGCursor(Cursor cursor) {
        }
    }
}

