/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.fonts;

import java.util.Hashtable;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.FontReader;

public class LazyFont
extends Font
implements FontDescriptor {
    private String metricsFileName = null;
    private String fontEmbedPath = null;
    private boolean useKerning = false;
    private boolean isMetricsLoaded = false;
    private Font realFont = null;
    private FontDescriptor realFontDescriptor = null;

    public LazyFont(String string, String string2, boolean bl) {
        this.metricsFileName = string2;
        this.fontEmbedPath = string;
        this.useKerning = bl;
    }

    public String encoding() {
        this.load();
        return this.realFont.encoding();
    }

    public String fontName() {
        this.load();
        return this.realFont.fontName();
    }

    public int getAscender() {
        this.load();
        return this.realFontDescriptor.getAscender();
    }

    public int getAscender(int n) {
        this.load();
        return this.realFont.getAscender(n);
    }

    public int getCapHeight() {
        this.load();
        return this.realFontDescriptor.getCapHeight();
    }

    public int getCapHeight(int n) {
        this.load();
        return this.realFont.getCapHeight(n);
    }

    public int getDescender() {
        this.load();
        return this.realFontDescriptor.getDescender();
    }

    public int getDescender(int n) {
        this.load();
        return this.realFont.getDescender(n);
    }

    public int getFirstChar() {
        this.load();
        return this.realFont.getFirstChar();
    }

    public int getFlags() {
        this.load();
        return this.realFontDescriptor.getFlags();
    }

    public int[] getFontBBox() {
        this.load();
        return this.realFontDescriptor.getFontBBox();
    }

    public PDFStream getFontFile(int n) {
        this.load();
        return this.realFontDescriptor.getFontFile(n);
    }

    public int getItalicAngle() {
        this.load();
        return this.realFontDescriptor.getItalicAngle();
    }

    public Hashtable getKerningInfo() {
        this.load();
        return this.realFontDescriptor.getKerningInfo();
    }

    public int getLastChar() {
        this.load();
        return this.realFont.getLastChar();
    }

    public Font getRealFont() {
        return this.realFont;
    }

    public int getStemV() {
        this.load();
        return this.realFontDescriptor.getStemV();
    }

    public byte getSubType() {
        this.load();
        return this.realFont.getSubType();
    }

    public int[] getWidths(int n) {
        this.load();
        return this.realFont.getWidths(n);
    }

    public int getXHeight(int n) {
        this.load();
        return this.realFont.getXHeight(n);
    }

    public boolean hasKerningInfo() {
        this.load();
        return this.realFontDescriptor.hasKerningInfo();
    }

    public boolean isEmbeddable() {
        this.load();
        return this.realFontDescriptor.isEmbeddable();
    }

    private void load() {
        block3: {
            if (this.isMetricsLoaded) break block3;
            this.isMetricsLoaded = true;
            try {
                FontReader fontReader = new FontReader(this.metricsFileName);
                fontReader.useKerning(this.useKerning);
                fontReader.setFontEmbedPath(this.fontEmbedPath);
                this.realFont = fontReader.getFont();
                if (this.realFont instanceof FontDescriptor) {
                    this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                }
            }
            catch (Exception exception) {
                MessageHandler.error("Failed to read font metrics file " + this.metricsFileName + " : " + exception.getMessage());
            }
        }
    }

    public char mapChar(char c) {
        this.load();
        return this.realFont.mapChar(c);
    }

    public int width(int n, int n2) {
        this.load();
        return this.realFont.width(n, n2);
    }
}

