/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.render.ps.PSRenderer;

public class PSGraphics2D
extends AbstractGraphics2D {
    boolean standalone = false;
    protected PSRenderer psRenderer;
    protected FontState fontState;
    protected String currentFontName;
    protected int currentFontSize;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    PDFColor currentColour = new PDFColor(0, 0, 0);
    FontInfo fontInfo;
    private Graphics2D fmg;

    public PSGraphics2D(PSGraphics2D pSGraphics2D) {
        super((AbstractGraphics2D)pSGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PSGraphics2D(boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PSGraphics2D(boolean bl, FontState fontState, PSRenderer pSRenderer, String string, int n, int n2, int n3) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.psRenderer = pSRenderer;
        this.currentFontName = string;
        this.currentFontSize = n;
        this.currentYPosition = n3;
        this.currentXPosition = n2;
        this.fontState = fontState;
    }

    protected void applyPaint(Paint paint, boolean bl) {
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            Color color = gradientPaint.getColor1();
            Color color2 = gradientPaint.getColor2();
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            boolean bl2 = gradientPaint.isCyclic();
            Vector<Double> vector = new Vector<Double>();
            vector.addElement(new Double(point2D.getX()));
            vector.addElement(new Double(point2D.getY()));
            vector.addElement(new Double(point2D2.getX()));
            vector.addElement(new Double(point2D2.getY()));
            Vector<Boolean> vector2 = new Vector<Boolean>();
            vector2.addElement(new Boolean(true));
            vector2.addElement(new Boolean(true));
            Vector<Double> vector3 = new Vector<Double>();
            vector3.addElement(new Double(0.0));
            vector3.addElement(new Double(1.0));
            Vector<Double> vector4 = new Vector<Double>();
            vector4.addElement(new Double(0.0));
            vector4.addElement(new Double(1.0));
            vector4.addElement(new Double(0.0));
            vector4.addElement(new Double(1.0));
            Vector<Double> vector5 = new Vector<Double>();
            vector5.addElement(new Double(0.0));
            vector5.addElement(new Double(1.0));
            Vector vector6 = new Vector();
            Vector<PDFColor> vector7 = new Vector<PDFColor>();
            PDFColor pDFColor = new PDFColor(color.getRed(), color.getGreen(), color.getBlue());
            vector7.addElement(pDFColor);
            PDFColor pDFColor2 = new PDFColor(color2.getRed(), color2.getGreen(), color2.getBlue());
            vector7.addElement(pDFColor2);
            ColorSpace colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
        }
    }

    protected void applyStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            int n;
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                this.psRenderer.write("[");
                n = 0;
                while (n < fArray.length) {
                    this.psRenderer.write(String.valueOf(1000 * (int)fArray[n]));
                    if (n < fArray.length - 1) {
                        this.psRenderer.write(" ");
                    }
                    ++n;
                }
                this.psRenderer.write("] ");
                float f = basicStroke.getDashPhase();
                this.psRenderer.write(String.valueOf(1000 * (int)f) + " setdash");
            }
            n = basicStroke.getEndCap();
            switch (n) {
                case 0: {
                    this.psRenderer.write("0 setlinecap");
                    break;
                }
                case 1: {
                    this.psRenderer.write("1 setlinecap");
                    break;
                }
                case 2: {
                    this.psRenderer.write("2 setlinecap");
                    break;
                }
            }
            int n2 = basicStroke.getLineJoin();
            switch (n2) {
                case 0: {
                    this.psRenderer.write("0 setlinejoin");
                    break;
                }
                case 1: {
                    this.psRenderer.write("1 setlinejoin");
                    break;
                }
                case 2: {
                    this.psRenderer.write("2 setlinejoin");
                    break;
                }
            }
            float f = basicStroke.getLineWidth();
            this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0f * f)) + " setlinewidth");
            float f2 = basicStroke.getMiterLimit();
            this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0f * f2)) + " setmiterlimit");
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("copyArea");
    }

    public Graphics create() {
        return new PSGraphics2D(this);
    }

    public void dispose() {
        this.psRenderer = null;
        this.fontState = null;
        this.currentFontName = null;
        this.currentColour = null;
        this.fontInfo = null;
    }

    protected void doDrawing(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl2) {
                if (!bl3) {
                    this.psRenderer.write("stroke");
                } else {
                    this.psRenderer.write("stroke");
                }
            } else if (!bl3) {
                this.psRenderer.write("fill");
            } else {
                this.psRenderer.write("fill");
            }
        } else {
            this.psRenderer.write("stroke");
        }
    }

    public void draw(Shape shape) {
        this.psRenderer.write("gsave");
        Shape shape2 = this.getClip();
        this.writeClip(shape2);
        Color color = this.getColor();
        this.psRenderer.write(String.valueOf(color.getRed()) + " " + color.getGreen() + " " + color.getBlue() + " setrgbcolor");
        this.applyPaint(this.getPaint(), false);
        this.applyStroke(this.getStroke());
        this.psRenderer.write("newpath");
        PathIterator pathIterator = shape.getPathIterator(this.getTransform());
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " " + PDFNumber.doubleOut(1000.0 * dArray[2]) + " " + PDFNumber.doubleOut(1000.0 * dArray[3]) + " " + PDFNumber.doubleOut(1000.0 * dArray[4]) + " " + PDFNumber.doubleOut(1000.0 * dArray[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " M");
                    break;
                }
                case 4: {
                    this.psRenderer.write("closepath");
                    break;
                }
            }
            pathIterator.next();
        }
        this.doDrawing(false, true, false);
        this.psRenderer.write("grestore");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        System.out.println("drawImage");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Object object;
        int n3 = image.getWidth(imageObserver);
        int n4 = image.getHeight(imageObserver);
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        Dimension dimension = new Dimension(n3, n4);
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setBackground(new Color(1, 1, 1, 0));
        graphics2D.setPaint(new Color(1, 1, 1, 0));
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        if (!graphics2D.drawImage(image, 0, 0, imageObserver)) {
            return false;
        }
        graphics2D.dispose();
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() * 3];
        byte[] byArray2 = new byte[bufferedImage.getWidth() * bufferedImage.getHeight()];
        Raster raster = bufferedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        int n5 = 0;
        boolean bl = false;
        switch (dataBuffer.getDataType()) {
            case 3: {
                object = ((DataBufferInt)dataBuffer).getBankData();
                int n6 = 0;
                while (n6 < ((int[][])object).length) {
                    int n7 = 0;
                    while (n7 < object[n6].length) {
                        if ((object[n6][n7] >> 24 & 0xFF) != 255) {
                            byArray[n5++] = -1;
                            byArray[n5++] = -1;
                            byArray[n5++] = -1;
                        } else {
                            byArray[n5++] = (byte)(object[n6][n7] >> 16 & 0xFF);
                            byArray[n5++] = (byte)(object[n6][n7] >> 8 & 0xFF);
                            byArray[n5++] = (byte)(object[n6][n7] & 0xFF);
                        }
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
        }
        try {
            object = new TempImage(n3, n4, byArray, byArray2);
            AffineTransform affineTransform = this.getTransform();
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.psRenderer.write("gsave");
            Shape shape = this.getClip();
            this.writeClip(shape);
            this.psRenderer.renderBitmap((FopImage)object, n, n2, n3, n4);
            this.psRenderer.write("grestore");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        System.out.println("drawRenderableImage");
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        System.out.println("drawRenderedImage");
    }

    public void drawString(String string, float f, float f2) {
        System.out.println("drawString(String)");
        this.psRenderer.write("BT");
        Shape shape = this.getClip();
        this.writeClip(shape);
        Color color = this.getColor();
        this.psRenderer.write(String.valueOf(color.getRed()) + " " + color.getGreen() + " " + color.getBlue() + " setrgbcolor");
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(f, f2);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " " + PDFNumber.doubleOut(dArray[6]) + " Tm [" + string + "]");
        this.psRenderer.write("ET");
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        System.err.println("drawString(AttributedCharacterIterator)");
        this.psRenderer.write("BT");
        Shape shape = this.getClip();
        this.writeClip(shape);
        Color color = this.getColor();
        this.currentColour = new PDFColor(color.getRed(), color.getGreen(), color.getBlue());
        this.psRenderer.write(this.currentColour.getColorSpaceOut(true));
        color = this.getBackground();
        PDFColor pDFColor = new PDFColor(color.getRed(), color.getGreen(), color.getBlue());
        this.psRenderer.write(pDFColor.getColorSpaceOut(false));
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(f, f2);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " " + PDFNumber.doubleOut(dArray[6]) + " Tm [" + c + "]");
            c = attributedCharacterIterator.next();
        }
        this.psRenderer.write("ET");
    }

    public void fill(Shape shape) {
        this.psRenderer.write("gsave");
        Shape shape2 = this.getClip();
        this.writeClip(shape2);
        Color color = this.getColor();
        this.psRenderer.write(String.valueOf(color.getRed()) + " " + color.getGreen() + " " + color.getBlue() + " setrgbcolor");
        this.applyPaint(this.getPaint(), true);
        this.psRenderer.write("newpath");
        PathIterator pathIterator = shape.getPathIterator(this.getTransform());
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " " + PDFNumber.doubleOut(1000.0 * dArray[2]) + " " + PDFNumber.doubleOut(1000.0 * dArray[3]) + " " + PDFNumber.doubleOut(1000.0 * dArray[4]) + " " + PDFNumber.doubleOut(1000.0 * dArray[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " M");
                    break;
                }
                case 4: {
                    this.psRenderer.write("closepath");
                    break;
                }
            }
            pathIterator.next();
        }
        this.doDrawing(true, false, pathIterator.getWindingRule() == 0);
        this.psRenderer.write("grestore");
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
    }

    public void setXORMode(Color color) {
        System.out.println("setXORMode");
    }

    protected void writeClip(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(this.getTransform());
        this.psRenderer.write("newpath");
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " " + PDFNumber.doubleOut(1000.0 * dArray[2]) + " " + PDFNumber.doubleOut(1000.0 * dArray[3]) + " " + PDFNumber.doubleOut(1000.0 * dArray[4]) + " " + PDFNumber.doubleOut(1000.0 * dArray[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.psRenderer.write(String.valueOf(PDFNumber.doubleOut(1000.0 * dArray[0])) + " " + PDFNumber.doubleOut(1000.0 * dArray[1]) + " M");
                    break;
                }
                case 4: {
                    this.psRenderer.write("closepath");
                    break;
                }
            }
            pathIterator.next();
        }
        this.psRenderer.write("clippath");
    }

    class TempImage
    implements FopImage {
        int m_height;
        int m_width;
        int m_bitsPerPixel;
        ColorSpace m_colorSpace;
        int m_bitmapSiye;
        byte[] m_bitmaps;
        byte[] m_mask;
        PDFColor transparent = new PDFColor(255, 255, 255);

        TempImage(int n, int n2, byte[] byArray, byte[] byArray2) throws FopImageException {
            this.m_height = n2;
            this.m_width = n;
            this.m_bitsPerPixel = 8;
            this.m_colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
            this.m_bitmaps = byArray;
            this.m_mask = byArray2;
        }

        public void close() {
        }

        public byte[] getBitmaps() throws FopImageException {
            return this.m_bitmaps;
        }

        public int getBitmapsSize() throws FopImageException {
            return this.m_width * this.m_height * 3;
        }

        public int getBitsPerPixel() throws FopImageException {
            return this.m_bitsPerPixel;
        }

        public ColorSpace getColorSpace() throws FopImageException {
            return this.m_colorSpace;
        }

        public int getHeight() throws FopImageException {
            return this.m_height;
        }

        public byte[] getMask() throws FopImageException {
            return this.m_mask;
        }

        public PDFFilter getPDFFilter() throws FopImageException {
            return null;
        }

        public byte[] getRessourceBytes() throws FopImageException {
            return null;
        }

        public int getRessourceBytesSize() throws FopImageException {
            return 0;
        }

        public PDFColor getTransparentColor() throws FopImageException {
            return this.transparent;
        }

        public String getURL() {
            return String.valueOf(this.m_bitmaps);
        }

        public int getWidth() throws FopImageException {
            return this.m_width;
        }

        public boolean invertImage() {
            return false;
        }

        public boolean isTransparent() throws FopImageException {
            return this.transparent != null;
        }
    }
}

