/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.JpegImage;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.ps.ASCII85OutputStream;
import org.apache.fop.render.ps.Finalizable;
import org.apache.fop.render.ps.FlateEncodeOutputStream;
import org.apache.fop.render.ps.PSGraphics2D;
import org.apache.fop.render.ps.PSStream;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;

public class PSRenderer
extends AbstractRenderer {
    protected String producer;
    int imagecount = 0;
    int pagecount = 0;
    private boolean enableComments = true;
    protected PSStream out;
    private boolean ioTrouble = false;
    private String currentFontName;
    private int currentFontSize;
    private int pageHeight;
    private int pageWidth;
    private float currRed;
    private float currGreen;
    private float currBlue;
    private FontInfo fontInfo;
    protected IDReferences idReferences;
    protected Hashtable options;

    protected void addFilledRect(int n, int n2, int n3, int n4, ColorType colorType) {
        if (n4 < 0) {
            n4 = -n4;
        }
        this.write("newpath");
        this.write(String.valueOf(n) + " " + n2 + " " + n3 + " " + -n4 + " re");
        this.useColor(colorType);
        this.write("fill");
    }

    protected void comment(String string) {
        if (this.enableComments) {
            this.write(string);
        }
    }

    protected void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        BorderAndPadding borderAndPadding = area.getBorderAndPadding();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        n2 = n2 + area.getBorderLeftWidth() + area.getBorderRightWidth();
        n3 = n3 + area.getBorderTopWidth() + area.getBorderBottomWidth();
        this.doBackground(area, n -= area.getBorderLeftWidth(), n4 += area.getBorderTopWidth(), n2, n3);
        if (area.getBorderTopWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(n) + " " + n4 + " M");
            this.write(String.valueOf(n2) + " 0 rlineto");
            this.write(String.valueOf(area.getBorderTopWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(borderAndPadding.getBorderColor(0));
            this.write("stroke");
        }
        if (area.getBorderLeftWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(n) + " " + n4 + " M");
            this.write("0 " + -n3 + " rlineto");
            this.write(String.valueOf(area.getBorderLeftWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(borderAndPadding.getBorderColor(3));
            this.write("stroke");
        }
        if (area.getBorderRightWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(n + n2) + " " + n4 + " M");
            this.write("0 " + -n3 + " rlineto");
            this.write(String.valueOf(area.getBorderRightWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(borderAndPadding.getBorderColor(1));
            this.write("stroke");
        }
        if (area.getBorderBottomWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(n) + " " + (n4 - n3) + " M");
            this.write(String.valueOf(n2) + " 0 rlineto");
            this.write(String.valueOf(area.getBorderBottomWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(borderAndPadding.getBorderColor(2));
            this.write("stroke");
        }
    }

    protected void drawImageClipped(int n, int n2, int n3, int n4, int n5, int n6, FopImage fopImage, FontState fontState) {
        this.write("gsave");
        this.write(String.valueOf(n3) + " " + n4 + " " + n5 + " " + n6 + " re");
        this.write("clippath");
        try {
            int n7 = fopImage.getWidth() * 1000;
            int n8 = fopImage.getHeight() * 1000;
            this.drawImageScaled(n, n2, n7, n8, fopImage, fontState);
        }
        catch (FopImageException fopImageException) {
            this.log.error("Error getting image extents", (Throwable)fopImageException);
        }
        this.write("grestore");
    }

    protected void drawImageScaled(int n, int n2, int n3, int n4, FopImage fopImage, FontState fontState) {
        if (fopImage instanceof SVGImage) {
            try {
                this.renderSVGDocument((Document)((SVGImage)fopImage).getSVGDocument(), n, n2, fontState);
            }
            catch (FopImageException fopImageException) {
                this.log.error("Error rendering SVG image", (Throwable)fopImageException);
            }
        } else if (fopImage instanceof EPSImage) {
            this.renderEPS(fopImage, n, n2, n3, n4);
        } else {
            this.renderBitmap(fopImage, n, n2, n3, n4);
        }
    }

    protected void movetoCurrPosition() {
        this.write(String.valueOf(this.currentXPosition) + " " + this.currentYPosition + " M");
    }

    public void render(Page page, OutputStream outputStream) {
        this.renderPage(page);
    }

    public void renderBitmap(FopImage fopImage, int n, int n2, int n3, int n4) {
        try {
            boolean bl = fopImage.getColorSpace().getColorSpace() != ColorSpace.DEVICE_GRAY;
            byte[] byArray = fopImage.getBitmaps();
            this.write("gsave");
            if (fopImage.getColorSpace().getColorSpace() == ColorSpace.DEVICE_CMYK) {
                this.write("/DeviceCMYK setcolorspace");
            } else {
                this.write("/DeviceRGB setcolorspace");
            }
            this.write(String.valueOf(n) + " " + (n2 - n4) + " translate");
            this.write(String.valueOf(n3) + " " + n4 + " scale");
            this.write("<<");
            this.write("  /ImageType 1");
            this.write("  /Width " + fopImage.getWidth());
            this.write("  /Height " + fopImage.getHeight());
            this.write("  /BitsPerComponent 8");
            if (fopImage.getColorSpace().getColorSpace() == ColorSpace.DEVICE_CMYK) {
                if (fopImage.invertImage()) {
                    this.write("  /Decode [1 0 1 0 1 0 1 0]");
                } else {
                    this.write("  /Decode [0 1 0 1 0 1 0 1]");
                }
            } else if (bl) {
                this.write("  /Decode [0 1 0 1 0 1]");
            } else {
                this.write("  /Decode [0 1]");
            }
            this.write("  /ImageMatrix [" + fopImage.getWidth() + " 0 0 -" + fopImage.getHeight() + " 0 " + fopImage.getHeight() + "]");
            if (fopImage instanceof JpegImage) {
                this.write("  /DataSource currentfile /ASCII85Decode filter /DCTDecode filter");
            } else {
                this.write("  /DataSource currentfile /ASCII85Decode filter /FlateDecode filter");
            }
            this.write(">>");
            this.write("image");
            try {
                FilterOutputStream filterOutputStream = this.out;
                filterOutputStream = new ASCII85OutputStream(filterOutputStream);
                if (!(fopImage instanceof JpegImage)) {
                    filterOutputStream = new FlateEncodeOutputStream(filterOutputStream);
                }
                ((OutputStream)filterOutputStream).write(byArray);
                ((Finalizable)((Object)filterOutputStream)).finalizeStream();
            }
            catch (IOException iOException) {
                if (!this.ioTrouble) {
                    iOException.printStackTrace();
                }
                this.ioTrouble = true;
            }
            this.write("");
            this.write("grestore");
        }
        catch (FopImageException fopImageException) {
            this.log.error("PSRenderer.renderImageArea(): Error rendering bitmap (" + fopImageException.getMessage() + ")", (Throwable)fopImageException);
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        this.currentYPosition -= displaySpace.getSize();
        this.movetoCurrPosition();
    }

    public void renderEPS(FopImage fopImage, int n, int n2, int n3, int n4) {
        try {
            EPSImage ePSImage = (EPSImage)fopImage;
            int[] nArray = ePSImage.getBBox();
            int n5 = nArray[2] - nArray[0];
            int n6 = nArray[3] - nArray[1];
            this.write("%%BeginDocument: " + ePSImage.getDocName());
            this.write("BeginEPSF");
            this.write(String.valueOf(n) + " " + (n2 - n4) + " translate");
            this.write("0.0 rotate");
            this.write(String.valueOf((long)(n3 / n5)) + " " + (long)(n4 / n6) + " scale");
            this.write(String.valueOf(-nArray[0]) + " " + -nArray[1] + " translate");
            this.write(String.valueOf(nArray[0]) + " " + nArray[1] + " " + n5 + " " + n6 + " rectclip");
            this.write("newpath");
            this.out.writeByteArr(fopImage.getBitmaps());
            this.write("%%EndDocument");
            this.write("EndEPSF");
            this.write("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error("PSRenderer.renderImageArea(): Error rendering bitmap (" + exception.getMessage() + ")", (Throwable)exception);
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        this.currentXPosition += foreignObjectArea.getXOffset();
        int n = 0;
        Area area = foreignObjectArea.getParent();
        if (area instanceof LineArea) {
            n = ((LineArea)area).getPlacementOffset();
        }
        this.currentYPosition += n;
        foreignObjectArea.getObject().render(this);
        this.currentXPosition += foreignObjectArea.getEffectiveWidth();
        this.currentYPosition -= n;
        this.movetoCurrPosition();
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentXPosition + imageArea.getXOffset();
        int n2 = 0;
        if (imageArea.getParent() instanceof LineArea) {
            n2 = ((LineArea)imageArea.getParent()).getPlacementOffset();
        }
        int n3 = this.currentYPosition + n2;
        int n4 = imageArea.getContentWidth();
        int n5 = imageArea.getHeight();
        this.currentXPosition += n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage == null) {
            this.log.error("Error while loading image: area.getImage() is null");
        } else {
            this.drawImageScaled(n, n3, n4, n5, fopImage, imageArea.getFontState());
        }
        this.movetoCurrPosition();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        if (inlineSpace.getUnderlined() || inlineSpace.getLineThrough() || inlineSpace.getOverlined()) {
            this.movetoCurrPosition();
            this.write("ULS");
            this.write(String.valueOf(inlineSpace.getSize()) + " 0 RM");
            if (inlineSpace.getUnderlined()) {
                this.write("ULE");
            }
            if (inlineSpace.getLineThrough()) {
                this.write("SOE");
            }
            if (inlineSpace.getOverlined()) {
                this.write("OLE");
            }
        }
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getContentWidth();
        int n4 = leaderArea.getRuleThickness();
        int n5 = n4 / 2;
        int n6 = n4 / 3;
        int n7 = n4 / 4;
        switch (leaderArea.getLeaderPattern()) {
            case 70: {
                if (leaderArea.getRuleStyle() == 52) break;
                this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                this.write("gsave");
                this.write("0 setlinecap");
                switch (leaderArea.getRuleStyle()) {
                    case 20: {
                        this.write("newpath");
                        this.write("[1000 3000] 0 setdash");
                        this.write(String.valueOf(n4) + " setlinewidth");
                        this.write(String.valueOf(n) + " " + n2 + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 16: {
                        this.write("newpath");
                        this.write("[3000 3000] 0 setdash");
                        this.write(String.valueOf(n4) + " setlinewidth");
                        this.write(String.valueOf(n) + " " + n2 + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 74: {
                        this.write("newpath");
                        this.write(String.valueOf(n4) + " setlinewidth");
                        this.write(String.valueOf(n) + " " + n2 + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 21: {
                        this.write("newpath");
                        this.write(String.valueOf(n6) + " setlinewidth");
                        this.write(String.valueOf(n) + " " + (n2 - n6) + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.write(String.valueOf(n) + " " + (n2 + n6) + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 33: {
                        this.write(String.valueOf(n5) + " setlinewidth");
                        this.write("newpath");
                        this.write(String.valueOf(n) + " " + (n2 - n7) + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                        this.write("stroke");
                        this.write("newpath");
                        this.write(String.valueOf(n) + " " + (n2 + n7) + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(1.0f, 1.0f, 1.0f);
                        this.write("stroke");
                        break;
                    }
                    case 68: {
                        this.write(String.valueOf(n5) + " setlinewidth");
                        this.write("newpath");
                        this.write(String.valueOf(n) + " " + (n2 - n7) + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(1.0f, 1.0f, 1.0f);
                        this.write("stroke");
                        this.write("newpath");
                        this.write(String.valueOf(n) + " " + (n2 + n7) + " M");
                        this.write(String.valueOf(n3) + " 0 rlineto");
                        this.useColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue());
                        this.write("stroke");
                        break;
                    }
                }
                this.write("grestore");
                break;
            }
            case 19: {
                this.comment("% --- Leader dots NYI");
                this.log.error("Leader dots: Not yet implemented");
                break;
            }
            case 88: {
                this.comment("% --- Leader use-content NYI");
                this.log.error("Leader use-content: Not yet implemented");
                break;
            }
        }
        this.currentXPosition += leaderArea.getContentWidth();
        this.write(String.valueOf(leaderArea.getContentWidth()) + " 0 RM");
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        this.movetoCurrPosition();
        String string = lineArea.getFontState().getFontWeight();
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            this.currentYPosition = n2 - lineArea.getPlacementOffset();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
        this.currentXPosition = n;
    }

    public void renderPage(Page page) {
        ++this.pagecount;
        this.idReferences = page.getIDReferences();
        this.write("%%Page: " + page.getNumber() + " " + page.getNumber());
        this.write("%%PageBoundingBox: 0 0 " + Math.round((float)page.getWidth() / 1000.0f) + " " + Math.round((float)page.getHeight() / 1000.0f));
        this.write("%%BeginPageSetup");
        this.write("FOPprocs begin");
        this.write("FOPFonts begin");
        this.write("0.001 0.001 scale");
        this.write("%%EndPageSetup");
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        this.write("showpage");
        this.write("%%PageTrailer");
        this.write("%%EndPage");
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        this.renderSVGDocument(sVGArea.getSVGDocument(), n, n2, sVGArea.getFontState());
    }

    protected void renderSVGDocument(Document document, int n, int n2, FontState fontState) {
        GraphicsNode graphicsNode;
        SVGUserAgent sVGUserAgent = new SVGUserAgent(new AffineTransform());
        sVGUserAgent.setLogger(this.log);
        GVTBuilder gVTBuilder = new GVTBuilder();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)sVGUserAgent);
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, document);
        }
        catch (Exception exception) {
            this.log.error("svg graphic could not be built: " + exception.getMessage(), (Throwable)exception);
            return;
        }
        float f = (float)bridgeContext.getDocumentSize().getWidth() * 1000.0f;
        float f2 = (float)bridgeContext.getDocumentSize().getHeight() * 1000.0f;
        bridgeContext = null;
        gVTBuilder = null;
        float f3 = 1.0f;
        float f4 = -1.0f;
        int n3 = n;
        int n4 = n2;
        this.comment("% --- SVG Area");
        this.write("gsave");
        if (f != 0.0f && f2 != 0.0f) {
            this.write("newpath");
            this.write(String.valueOf(n) + " " + n2 + " M");
            this.write(String.valueOf((float)n + f) + " " + n2 + " rlineto");
            this.write(String.valueOf((float)n + f) + " " + ((float)n2 - f2) + " rlineto");
            this.write(String.valueOf(n) + " " + ((float)n2 - f2) + " rlineto");
            this.write("closepath");
            this.write("clippath");
        }
        this.write(String.valueOf(n3) + " " + n4 + " translate");
        this.write(String.valueOf(f3) + " " + f4 + " scale");
        PSGraphics2D pSGraphics2D = new PSGraphics2D(false, fontState, this, this.currentFontName, this.currentFontSize, this.currentXPosition, this.currentYPosition);
        pSGraphics2D.setGraphicContext(new GraphicContext());
        try {
            graphicsNode.paint((Graphics2D)((Object)pSGraphics2D));
        }
        catch (Exception exception) {
            this.log.error("svg graphic could not be rendered: " + exception.getMessage(), (Throwable)exception);
        }
        this.write("grestore");
        this.comment("% --- SVG Area end");
    }

    public void renderWordArea(WordArea wordArea) {
        String string;
        this.movetoCurrPosition();
        FontState fontState = wordArea.getFontState();
        String string2 = fontState.getFontWeight();
        StringBuffer stringBuffer = new StringBuffer();
        if (wordArea.getPageNumberID() != null) {
            string = this.idReferences.getPageNumber(wordArea.getPageNumberID());
            if (string == null) {
                string = "";
            }
        } else {
            string = wordArea.getText();
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            char c2 = fontState.mapChar(c);
            if (c2 > '\u007f') {
                stringBuffer = stringBuffer.append("\\" + Integer.toOctalString(c2));
            } else {
                String string3 = "\\()[]{}";
                if (string3.indexOf(c2) >= 0) {
                    stringBuffer.append("\\");
                }
                stringBuffer = stringBuffer.append(c2);
            }
            ++n2;
        }
        String string4 = null;
        if (wordArea.getFontState().getLetterSpacing() > 0) {
            float f = wordArea.getFontState().getLetterSpacing();
            string4 = f + " 0.0 (" + stringBuffer + ") A";
        } else {
            string4 = "(" + stringBuffer + ") t";
        }
        this.useFont(fontState.getFontName(), fontState.getFontSize());
        this.useColor(wordArea.getRed(), wordArea.getGreen(), wordArea.getBlue());
        if (wordArea.getUnderlined() || wordArea.getLineThrough() || wordArea.getOverlined()) {
            this.write("ULS");
        }
        this.write(string4);
        if (wordArea.getUnderlined()) {
            this.write("ULE");
        }
        if (wordArea.getLineThrough()) {
            this.write("SOE");
        }
        if (wordArea.getOverlined()) {
            this.write("OLE");
        }
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setProducer(String string) {
        this.producer = string;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        FontSetup.setup(fontInfo);
        this.fontInfo = fontInfo;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.debug("rendering areas to PostScript");
        this.pagecount = 0;
        this.out = new PSStream(outputStream);
        this.write("%!PS-Adobe-3.0");
        if (this.producer == null) {
            this.producer = Version.getVersion();
        }
        this.write("%%Creator: " + this.producer);
        this.write("%%Pages: (atend)");
        this.write("%%DocumentProcessColors: Black");
        this.write("%%DocumentSuppliedResources: procset FOPFonts");
        this.write("%%EndComments");
        this.write("%%BeginDefaults");
        this.write("%%EndDefaults");
        this.write("%%BeginProlog");
        this.write("%%EndProlog");
        this.write("%%BeginSetup");
        this.writeProcs();
        this.writeFontDict(this.fontInfo);
        this.write("%%BeginResource: procset EPSprocs");
        this.write("%%Title: EPS encapsulation procs");
        this.write("/BeginEPSF { %def");
        this.write("/b4_Inc_state save def         % Save state for cleanup");
        this.write("/dict_count countdictstack def % Count objects on dict stack");
        this.write("/op_count count 1 sub def      % Count objects on operand stack");
        this.write("userdict begin                 % Push userdict on dict stack");
        this.write("/showpage { } def              % Redefine showpage, { } = null proc");
        this.write("0 setgray 0 setlinecap         % Prepare graphics state");
        this.write("1 setlinewidth 0 setlinejoin");
        this.write("10 setmiterlimit [ ] 0 setdash newpath");
        this.write("/languagelevel where           % If level not equal to 1 then");
        this.write("{pop languagelevel             % set strokeadjust and");
        this.write("1 ne                           % overprint to their defaults.");
        this.write("{false setstrokeadjust false setoverprint");
        this.write("} if");
        this.write("} if");
        this.write("} bind def");
        this.write("/EndEPSF { %def");
        this.write("count op_count sub {pop} repeat            % Clean up stacks");
        this.write("countdictstack dict_count sub {end} repeat");
        this.write("b4_Inc_state restore");
        this.write("} bind def");
        this.write("%%EndResource");
        this.write("%%EndSetup");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.write("%%Trailer");
        this.write("%%Pages: " + this.pagecount);
        this.write("%%EOF");
        this.out.flush();
        this.log.debug("written out PostScript");
    }

    private void useColor(float f, float f2, float f3) {
        if (f != this.currRed || f2 != this.currGreen || f3 != this.currBlue) {
            this.write(String.valueOf(f) + " " + f2 + " " + f3 + " setrgbcolor");
            this.currRed = f;
            this.currGreen = f2;
            this.currBlue = f3;
        }
    }

    private void useColor(ColorType colorType) {
        this.useColor(colorType.red(), colorType.green(), colorType.blue());
    }

    public void useFont(String string, int n) {
        if (this.currentFontName != string || this.currentFontSize != n) {
            this.write(String.valueOf(string) + " " + n + " F");
            this.currentFontName = string;
            this.currentFontSize = n;
        }
    }

    protected void write(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            if (!this.ioTrouble) {
                iOException.printStackTrace();
            }
            this.ioTrouble = true;
        }
    }

    protected void writeFontDict(FontInfo fontInfo) {
        Font font;
        String string;
        this.write("%%BeginResource: procset FOPFonts");
        this.write("%%Title: Font setup (shortcuts) for this file");
        this.write("/FOPFonts 100 dict dup begin");
        Hashtable hashtable = fontInfo.getFonts();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            font = (Font)hashtable.get(string);
            this.write("/" + string + " /" + font.fontName() + " def");
        }
        this.write("end def");
        this.write("%%EndResource");
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            font = (Font)hashtable.get(string);
            this.write("/" + font.fontName() + " findfont");
            this.write("dup length dict begin");
            this.write("  {1 index /FID ne {def} {pop pop} ifelse} forall");
            this.write("  /Encoding ISOLatin1Encoding def");
            this.write("  currentdict");
            this.write("end");
            this.write("/" + font.fontName() + " exch definefont pop");
        }
    }

    protected void writeProcs() {
        this.write("%%BeginResource: procset FOPprocs");
        this.write("%%Title: Utility procedures");
        this.write("/FOPprocs 20 dict dup begin");
        this.write("/bd{bind def}bind def");
        this.write("/ld{load def}bd");
        this.write("/M/moveto ld");
        this.write("/RM/rmoveto ld");
        this.write("/t/show ld");
        this.write("/A/ashow ld");
        this.write("/cp/closepath ld");
        this.write("/re {4 2 roll M");
        this.write("1 index 0 rlineto");
        this.write("0 exch rlineto");
        this.write("neg 0 rlineto");
        this.write("cp } bd");
        this.write("/ux 0.0 def");
        this.write("/uy 0.0 def");
        this.write("/F {");
        this.write("  /Tp exch def");
        this.write("  /Tf exch def");
        this.write("  Tf findfont Tp scalefont setfont");
        this.write("  /cf Tf def  /cs Tp def  /cw ( ) stringwidth pop def");
        this.write("} bd");
        this.write("/ULS {currentpoint /uy exch def /ux exch def} bd");
        this.write("/ULE {");
        this.write("  /Tcx currentpoint pop def");
        this.write("  gsave");
        this.write("  newpath");
        this.write("  cf findfont cs scalefont dup");
        this.write("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
        this.write("  /UnderlinePosition get Ts mul /To exch def");
        this.write("  /UnderlineThickness get Ts mul /Tt exch def");
        this.write("  ux uy To add moveto  Tcx uy To add lineto");
        this.write("  Tt setlinewidth stroke");
        this.write("  grestore");
        this.write("} bd");
        this.write("/OLE {");
        this.write("  /Tcx currentpoint pop def");
        this.write("  gsave");
        this.write("  newpath");
        this.write("  cf findfont cs scalefont dup");
        this.write("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
        this.write("  /UnderlinePosition get Ts mul /To exch def");
        this.write("  /UnderlineThickness get Ts mul /Tt exch def");
        this.write("  ux uy To add cs add moveto Tcx uy To add cs add lineto");
        this.write("  Tt setlinewidth stroke");
        this.write("  grestore");
        this.write("} bd");
        this.write("/SOE {");
        this.write("  /Tcx currentpoint pop def");
        this.write("  gsave");
        this.write("  newpath");
        this.write("  cf findfont cs scalefont dup");
        this.write("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
        this.write("  /UnderlinePosition get Ts mul /To exch def");
        this.write("  /UnderlineThickness get Ts mul /Tt exch def");
        this.write("  ux uy To add cs 10 mul 26 idiv add moveto Tcx uy To add cs 10 mul 26 idiv add lineto");
        this.write("  Tt setlinewidth stroke");
        this.write("  grestore");
        this.write("} bd");
        this.write("end def");
        this.write("%%EndResource");
    }
}

