/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.awt.FontSetup;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUtilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGRenderer
extends AbstractRenderer {
    static final String svgNS = "http://www.w3.org/2000/svg";
    Document svgDocument;
    Element svgRoot;
    Element currentPageG = null;
    Element lastLink = null;
    float totalWidth = 0.0f;
    float totalHeight = 0.0f;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected int pageNumber = 0;
    protected Hashtable fontNames = new Hashtable();
    protected Hashtable fontStyles = new Hashtable();
    protected Color saveColor = null;
    protected IDReferences idReferences = null;
    protected String currentFontName;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected Hashtable options;

    protected void addFilledRect(int n, int n2, int n3, int n4, ColorType colorType) {
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        this.addRect(n, n2, n3, n4, f, f2, f3, f, f2, f3);
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, float f, float f2, float f3) {
        Element element = SVGUtilities.createLine(this.svgDocument, (float)n / 1000.0f, (float)this.pageHeight - (float)n2 / 1000.0f, (float)n3 / 1000.0f, (float)this.pageHeight - (float)n4 / 1000.0f);
        element.setAttributeNS(null, "style", "stroke-width:" + (float)Math.abs(n5) / 1000.0f + ";stroke:rgb(" + (int)(255.0f * f) + "," + (int)(255.0f * f2) + "," + (int)(255.0f * f3) + ")");
        this.currentPageG.appendChild(element);
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3) {
        Element element = SVGUtilities.createRect(this.svgDocument, (float)n / 1000.0f, (float)this.pageHeight - (float)n2 / 1000.0f, (float)n3 / 1000.0f, (float)n4 / 1000.0f);
        element.setAttributeNS(null, "style", "stroke:rgb(" + (int)(255.0f * f) + "," + (int)(255.0f * f2) + "," + (int)(255.0f * f3) + ")");
        this.currentPageG.appendChild(element);
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6) {
        Element element = SVGUtilities.createRect(this.svgDocument, (float)n / 1000.0f, (float)this.pageHeight - (float)n2 / 1000.0f, (float)n3 / 1000.0f, (float)n4 / 1000.0f);
        element.setAttributeNS(null, "style", "stroke:rgb(" + (int)(255.0f * f) + "," + (int)(255.0f * f2) + "," + (int)(255.0f * f3) + ");fill:rgb(" + (int)(255.0f * f4) + "," + (int)(255.0f * f5) + "," + (int)(255.0f * f6) + ")");
        this.currentPageG.appendChild(element);
    }

    protected void addRect(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = (n + 500) / 1000;
        int n6 = this.pageHeight - (n2 + 500) / 1000;
        int n7 = (n + n3 + 500) / 1000;
        int n8 = this.pageHeight - (n2 + n4 + 500) / 1000;
        if (bl) {
            Element element = SVGUtilities.createRect(this.svgDocument, n5, n6, n7 - n5, n8 - n6);
            element.setAttributeNS(null, "style", "fill:none");
            this.currentPageG.appendChild(element);
        } else {
            Element element = SVGUtilities.createRect(this.svgDocument, n5, n6, n7 - n5, n6 - n8);
            element.setAttributeNS(null, "style", "stroke:none");
            this.currentPageG.appendChild(element);
        }
    }

    public static Color colorType2Color(ColorType colorType) {
        if (colorType == null) {
            return null;
        }
        return new Color(colorType.red(), colorType.green(), colorType.blue());
    }

    protected void doFrame(Area area) {
        ColorType colorType;
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, n -= area.getPaddingLeft(), n4 += area.getPaddingTop(), n2, n3);
        n -= area.getBorderLeftWidth();
        n4 += area.getBorderTopWidth();
        n2 = n2 + area.getBorderLeftWidth() + area.getBorderRightWidth();
        n3 = n3 + area.getBorderTopWidth() + area.getBorderBottomWidth();
        BorderAndPadding borderAndPadding = area.getBorderAndPadding();
        if (area.getBorderTopWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(0);
            this.addLine(n, n4, n + n2, n4, area.getBorderTopWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
        if (area.getBorderLeftWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(3);
            this.addLine(n, n4, n, n4 - n3, area.getBorderLeftWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
        if (area.getBorderRightWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(1);
            this.addLine(n + n2, n4, n + n2, n4 - n3, area.getBorderRightWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
        if (area.getBorderBottomWidth() != 0) {
            colorType = borderAndPadding.getBorderColor(2);
            this.addLine(n, n4 - n3, n + n2, n4 - n3, area.getBorderBottomWidth(), colorType.red(), colorType.green(), colorType.blue());
        }
    }

    protected void drawFrame() {
        int n = this.pageWidth;
        int n2 = this.pageHeight;
        Element element = SVGUtilities.createRect(this.svgDocument, 0.0f, 0.0f, n, n2);
        element.setAttributeNS(null, "style", "fill:none;stroke:black");
        this.currentPageG.appendChild(element);
    }

    protected void drawImageClipped(int n, int n2, int n3, int n4, int n5, int n6, FopImage fopImage, FontState fontState) {
    }

    protected void drawImageScaled(int n, int n2, int n3, int n4, FopImage fopImage, FontState fontState) {
    }

    protected Rectangle2D getBounds(Area area) {
        return new Rectangle2D.Double(this.currentAreaContainerXPosition, this.currentYPosition, area.getAllocationWidth(), area.getHeight());
    }

    public void render(Page page) throws IOException {
        this.idReferences = page.getIDReferences();
        int n = this.pageWidth;
        int n2 = this.pageHeight;
        this.pageWidth = (int)((double)((float)page.getWidth() / 1000.0f) + 0.5);
        this.pageHeight = (int)((double)((float)page.getHeight() / 1000.0f) + 0.5);
        if (this.lastLink != null && this.currentPageG != null) {
            this.lastLink.setAttributeNS(null, "xlink:href", "#svgView(viewBox(0, " + this.totalHeight + ", " + this.pageWidth + ", " + this.pageHeight + "))");
            this.currentPageG.appendChild(this.lastLink);
        }
        this.totalHeight += (float)this.pageHeight;
        if (this.totalWidth < (float)this.pageWidth) {
            this.totalWidth = this.pageWidth;
        }
        this.currentPageG = SVGUtilities.createG(this.svgDocument);
        this.currentPageG.setAttributeNS(null, "id", "Page-" + this.pageNumber);
        this.currentPageG.setAttributeNS(null, "style", "font-family:sanserif;font-size:12");
        this.svgRoot.appendChild(this.currentPageG);
        this.drawFrame();
        this.renderPage(page);
        this.currentPageG.setAttributeNS(null, "transform", "translate(0," + (this.totalHeight - (float)this.pageHeight) + ")");
        Element element = this.svgDocument.createElementNS(svgNS, "a");
        if (this.lastLink != null) {
            element.setAttributeNS(null, "xlink:href", "#svgView(viewBox(0, " + (this.totalHeight - (float)this.pageHeight - (float)n2) + ", " + n + ", " + n2 + "))");
        } else {
            element.setAttributeNS(null, "xlink:href", "#svgView(viewBox(0, " + (this.totalHeight - (float)this.pageHeight) + ", " + this.pageWidth + ", " + this.pageHeight + "))");
        }
        this.currentPageG.appendChild(element);
        Element element2 = SVGUtilities.createRect(this.svgDocument, 0.0f, 0.0f, this.pageWidth / 2, this.pageHeight);
        element2.setAttributeNS(null, "style", "fill:blue;visibility:hidden");
        element.appendChild(element2);
        this.lastLink = this.svgDocument.createElementNS(svgNS, "a");
        element2 = SVGUtilities.createRect(this.svgDocument, this.pageWidth / 2, 0.0f, this.pageWidth / 2, this.pageHeight);
        element2.setAttributeNS(null, "style", "fill:blue;visibility:hidden");
        this.lastLink.appendChild(element2);
    }

    public void render(Page page, OutputStream outputStream) throws IOException {
        ++this.pageNumber;
        this.render(page);
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        foreignObjectArea.getObject().render(this);
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage == null) {
            this.log.error("Error while loading image : area.getImage() is null");
            this.addRect(n, n2, n3, n4, true);
        } else if (fopImage instanceof SVGImage) {
            try {
                SVGDocument sVGDocument = ((SVGImage)fopImage).getSVGDocument();
                this.renderSVGDocument((Document)sVGDocument, (float)n / 1000.0f, (float)this.pageHeight - (float)n2 / 1000.0f);
            }
            catch (FopImageException fopImageException) {}
        } else {
            String string = fopImage.getURL();
            try {
                URL uRL = new URL(string);
                ImageIcon imageIcon = new ImageIcon(uRL);
                Image image = imageIcon.getImage();
                int n5 = (n + 500) / 1000;
                int n6 = this.pageHeight - (n2 + 500) / 1000;
                int n7 = (n + n3 + 500) / 1000;
                int n8 = this.pageHeight - (n2 + n4 + 500) / 1000;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.currentXPosition += imageArea.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getLeaderLength();
        int n4 = leaderArea.getHeight();
        int n5 = leaderArea.getRuleThickness();
        int n6 = leaderArea.getRuleStyle();
        float f = leaderArea.getRed();
        float f2 = leaderArea.getGreen();
        float f3 = leaderArea.getBlue();
        this.addRect(n, n2, n3, n5, false);
        this.currentXPosition += leaderArea.getContentWidth();
    }

    public void renderPage(Page page) {
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        float f = (float)this.currentXPosition / 1000.0f;
        float f2 = (float)this.pageHeight - (float)this.currentYPosition / 1000.0f;
        int n = sVGArea.getContentWidth();
        int n2 = sVGArea.getHeight();
        Document document = sVGArea.getSVGDocument();
        this.renderSVGDocument(document, f, f2);
        this.currentXPosition += sVGArea.getContentWidth();
    }

    protected void renderSVGDocument(Document document, float f, float f2) {
        SVGSVGElement sVGSVGElement = ((SVGDocument)document).getRootElement();
        Element element = this.svgDocument.createElementNS(svgNS, "svg");
        Node node = this.svgDocument.importNode((Node)sVGSVGElement, true);
        element.setAttributeNS(null, "x", String.valueOf(f));
        element.setAttributeNS(null, "y", String.valueOf(f2));
        Element element2 = (Element)node;
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", svgNS);
        if (element2.hasAttributeNS(null, "xmlns")) {
            element2.removeAttributeNS(null, "xmlns");
        }
        element.appendChild(node);
        this.currentPageG.appendChild(element);
    }

    public void renderWordArea(WordArea wordArea) {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = wordArea.getFontState().getFontFamily();
        int n = wordArea.getFontState().getFontSize();
        boolean bl = wordArea.getUnderlined();
        float f = wordArea.getRed();
        float f2 = wordArea.getGreen();
        float f3 = wordArea.getBlue();
        if (!string4.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string4;
            this.currentFontSize = n;
        }
        if (f != this.currentRed || f2 != this.currentGreen || f3 != this.currentBlue) {
            this.currentRed = f;
            this.currentGreen = f2;
            this.currentBlue = f3;
        }
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        if (wordArea.getPageNumberID() != null) {
            string3 = this.idReferences.getPageNumber(wordArea.getPageNumberID());
            if (string3 == null) {
                string3 = "";
            }
        } else {
            string3 = wordArea.getText();
        }
        if (this.saveColor != null) {
            if ((float)this.saveColor.getRed() != f || (float)this.saveColor.getGreen() != f2 || (float)this.saveColor.getBlue() != f3) {
                this.saveColor = new Color(f, f2, f3);
            }
        } else {
            this.saveColor = new Color(f, f2, f3);
        }
        Element element = SVGUtilities.createText(this.svgDocument, (float)n2 / 1000.0f, (float)this.pageHeight - (float)n3 / 1000.0f, string3);
        String string5 = null;
        if (!"sans-serif".equals(this.currentFontName)) {
            string5 = "font-family:" + this.currentFontName;
        }
        if (this.currentFontSize != 12000) {
            string5 = string5 == null ? "" : String.valueOf(string5) + ";";
            string5 = String.valueOf(string5) + "font-size:" + (float)this.currentFontSize / 1000.0f;
        }
        if (f != 0.0f || f2 != 0.0f || f3 != 0.0f) {
            string5 = string5 == null ? "" : String.valueOf(string5) + ";";
            string5 = String.valueOf(string5) + "fill:rgb(" + (int)(255.0f * f) + "," + (int)(255.0f * f2) + "," + (int)(255.0f * f3) + ")";
        }
        if (!"normal".equals(string2 = wordArea.getFontState().getFontWeight())) {
            string5 = string5 == null ? "" : String.valueOf(string5) + ";";
            string5 = String.valueOf(string5) + "font-weight:" + string2;
        }
        if (!"normal".equals(string = wordArea.getFontState().getFontStyle())) {
            string5 = string5 == null ? "" : String.valueOf(string5) + ";";
            string5 = String.valueOf(string5) + "font-style:" + string;
        }
        if (string5 != null) {
            element.setAttributeNS(null, "style", string5);
        }
        this.currentPageG.appendChild(element);
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setProducer(String string) {
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        FontSetup.setup(fontInfo, bufferedImage.createGraphics());
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        this.svgDocument = dOMImplementation.createDocument(svgNS, "svg", null);
        ProcessingInstruction processingInstruction = this.svgDocument.createProcessingInstruction("xml", " version=\"1.0\" encoding=\"ISO-8859-1\"");
        this.svgRoot = this.svgDocument.getDocumentElement();
        this.svgDocument.insertBefore(processingInstruction, this.svgRoot);
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.svgRoot.setAttributeNS(null, "width", String.valueOf(this.totalWidth));
        this.svgRoot.setAttributeNS(null, "height", String.valueOf(this.totalHeight));
        SVGTranscoder sVGTranscoder = new SVGTranscoder();
        TranscoderInput transcoderInput = new TranscoderInput(this.svgDocument);
        TranscoderOutput transcoderOutput = new TranscoderOutput((Writer)new OutputStreamWriter(outputStream));
        try {
            sVGTranscoder.transcode(transcoderInput, transcoderOutput);
        }
        catch (TranscoderException transcoderException) {
            this.log.error("could not write svg file :" + transcoderException.getMessage(), (Throwable)transcoderException);
        }
        outputStream.flush();
        this.svgDocument = null;
        this.svgRoot = null;
        this.currentPageG = null;
        this.lastLink = null;
        this.totalWidth = 0.0f;
        this.totalHeight = 0.0f;
        this.pageNumber = 0;
    }
}

