/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFTextPainter
implements TextPainter {
    FontState fontState;

    public PDFTextPainter(FontState fontState) {
        this.fontState = fontState;
    }

    public Rectangle2D getBounds(TextNode textNode) {
        System.out.println("PDFText getBounds");
        return null;
    }

    public Rectangle2D getDecoratedBounds(TextNode textNode) {
        System.out.println("PDFText getDecoratedBounds");
        return null;
    }

    public Shape getDecoratedShape(TextNode textNode) {
        System.out.println("PDFText getDecoratedShape");
        return new Rectangle(1, 1);
    }

    public Shape getHighlightShape(Mark mark, Mark mark2) {
        System.out.println("PDFText getHighlightShape");
        return null;
    }

    public Mark getMark(TextNode textNode, int n, boolean bl) {
        System.out.println("PDFText getMark");
        return null;
    }

    public Rectangle2D getPaintedBounds(TextNode textNode) {
        return null;
    }

    public int[] getSelected(Mark mark, Mark mark2) {
        System.out.println("PDFText getSelected");
        return null;
    }

    public Shape getShape(TextNode textNode) {
        System.out.println("PDFText getShape");
        return null;
    }

    public float getStringWidth(String string) {
        float f = 0.0f;
        float f2 = this.fontState.width(this.fontState.mapChar(' '));
        int n = 0;
        while (n < string.length()) {
            float f3;
            char c = string.charAt(n);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                f3 = this.fontState.width(this.fontState.mapChar(c));
                if (f3 <= 0.0f) {
                    f3 = f2;
                }
            } else {
                f3 = f2;
            }
            f += f3;
            ++n;
        }
        return f / 1000.0f;
    }

    public void paint(TextNode textNode, Graphics2D graphics2D) {
        Object object;
        String string = textNode.getText();
        Point2D point2D = textNode.getLocation();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator.getBeginIndex() == attributedCharacterIterator.getEndIndex()) {
            return;
        }
        char c = attributedCharacterIterator.first();
        if (c == '\uffff') {
            return;
        }
        TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        Vector vector = (Vector)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
        Float f = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
        Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.STROKE);
        Float f2 = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.X);
        Float f3 = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.Y);
        Float f4 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.POSTURE);
        Float f5 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT);
        if (paint instanceof Color) {
            graphics2D.setColor((Color)paint);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        String string2 = f4 != null && (double)f4.floatValue() > 0.0 ? "italic" : "normal";
        String string3 = f5 != null && (double)f5.floatValue() > 1.0 ? "bold" : "normal";
        FontInfo fontInfo = this.fontState.getFontInfo();
        boolean bl = false;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (GVTFontFamily)enumeration.nextElement();
                String string4 = object.getFamilyName();
                if (!fontInfo.hasFont(string4, string3, string2)) continue;
                try {
                    int n = (int)f.floatValue();
                    this.fontState = new FontState(this.fontState.getFontInfo(), string4, string2, string3, n * 1000, 0);
                }
                catch (FOPException fOPException) {
                    fOPException.printStackTrace();
                }
                bl = true;
                break;
            }
        }
        if (!bl) {
            try {
                int n = (int)f.floatValue();
                this.fontState = new FontState(this.fontState.getFontInfo(), "any", string2, string3, n * 1000, 0);
            }
            catch (FOPException fOPException) {
                fOPException.printStackTrace();
            }
        } else if (graphics2D instanceof PDFGraphics2D) {
            ((PDFGraphics2D)((Object)graphics2D)).setOverrideFontState(this.fontState);
        }
        int n = 0;
        n = this.fontState.getFontWeight().equals("bold") ? (this.fontState.getFontStyle().equals("italic") ? 3 : 1) : (this.fontState.getFontStyle().equals("italic") ? 2 : 0);
        object = new Font(this.fontState.getFontFamily(), n, this.fontState.getFontSize() / 1000);
        graphics2D.setFont((Font)object);
        float f6 = this.getStringWidth(string);
        float f7 = 0.0f;
        if (anchor != null) {
            switch (anchor.getType()) {
                case 1: {
                    f7 = -f6 / 2.0f;
                    break;
                }
                case 2: {
                    f7 = -f6;
                }
            }
        }
        graphics2D.drawString(string, (float)(point2D.getX() + (double)f7), (float)point2D.getY());
    }

    public Mark selectAll(double d, double d2, TextNode textNode) {
        System.out.println("PDFText selectAll");
        return null;
    }

    public Mark selectAt(double d, double d2, TextNode textNode) {
        System.out.println("PDFText selectAt");
        return null;
    }

    public Mark selectFirst(TextNode textNode) {
        System.out.println("PDFText selectFirst");
        return null;
    }

    public Mark selectLast(TextNode textNode) {
        System.out.println("PDFText selectLast");
        return null;
    }

    public Mark selectTo(double d, double d2, Mark mark) {
        System.out.println("PDFText selectTo");
        return null;
    }
}

