/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.objects.XString;
import org.xml.sax.SAXException;
import servlet.ApplyXSLTException;
import servlet.ApplyXSLTListener;
import servlet.ApplyXSLTProperties;
import servlet.DefaultApplyXSLTProperties;
import servlet.OrderedProps;

public class ApplyXSLT
extends HttpServlet {
    protected ApplyXSLTProperties ourDefaultParameters = null;
    private boolean useDefaultTemplates = false;
    private Templates defaultTemplates = null;
    public static final String EOL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final String ROOT = System.getProperty("server.root");
    public static String CURRENTDIR;
    protected OrderedProps ourMediaProps = null;
    protected static final String STYLESHEET_ATTRIBUTE = "media";
    protected static final String HEADER_NAME = "user-Agent";

    protected void compileXSL(String string) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.defaultTemplates = transformerFactory.newTemplates(new StreamSource(string));
        this.useDefaultTemplates = true;
    }

    protected void displayException(HttpServletResponse httpServletResponse, ApplyXSLTException applyXSLTException, boolean bl) {
        String string = applyXSLTException.getMessage();
        string = string == null ? "" : "<B>" + string + "</B>";
        StringTokenizer stringTokenizer = new StringTokenizer(string, EOL);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(String.valueOf(stringTokenizer.nextToken()) + EOL + "<BR>");
        }
        string = stringBuffer.toString();
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            applyXSLTException.getException().printStackTrace(printWriter);
            string = String.valueOf(string) + " <PRE> " + byteArrayOutputStream.toString() + " </PRE> ";
        }
        httpServletResponse.setContentType("text/html");
        try {
            httpServletResponse.sendError(applyXSLTException.getStatusCode(), string);
        }
        catch (IOException iOException) {
            System.err.println("IOException is occurring when sendError is called");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.process(transformerFactory, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {}
    }

    public String getContentType(Templates templates) {
        String string;
        Properties properties = templates.getOutputProperties();
        String string2 = properties.getProperty("method");
        if (string2 == null) {
            string2 = "xml";
        }
        Properties properties2 = null;
        properties2 = string2.equals("html") ? OutputProperties.getDefaultMethodProperties((String)"html") : (string2.equals("text") ? OutputProperties.getDefaultMethodProperties((String)"text") : OutputProperties.getDefaultMethodProperties((String)"xml"));
        String string3 = properties.getProperty("encoding");
        if (string3 == null) {
            string3 = properties2.getProperty("encoding");
        }
        if ((string = properties.getProperty("media-type")) == null) {
            string = properties2.getProperty("media-type");
        }
        return String.valueOf(string) + "; charset=" + string3;
    }

    protected Source getDocument(HttpServletRequest httpServletRequest, ApplyXSLTListener applyXSLTListener) throws ApplyXSLTException {
        try {
            String string = null;
            string = httpServletRequest.getPathInfo();
            if (string != null) {
                applyXSLTListener.out.println("Parsing XML Document from PathInfo: " + string);
                return new StreamSource(new URL("http", ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getLocalHost(), string.replace('\\', '/')).openStream());
            }
            string = this.ourDefaultParameters.getXMLurl(httpServletRequest);
            if (string != null) {
                applyXSLTListener.out.println("Parsing XML Document from request parameter: " + string);
                return new StreamSource(new URL(string).openStream());
            }
            String string2 = httpServletRequest.getContentType();
            if (string2 != null && string2.startsWith("text/xml")) {
                applyXSLTListener.out.println("Parsing XML Document from request chain");
                return new StreamSource((InputStream)httpServletRequest.getInputStream());
            }
        }
        catch (IOException iOException) {
            throw new ApplyXSLTException(iOException, 404);
        }
        catch (Exception exception) {
            throw new ApplyXSLTException(exception, 500);
        }
        return null;
    }

    public String getMedia(HttpServletRequest httpServletRequest) {
        return this.ourMediaProps.getValue(httpServletRequest.getHeader(HEADER_NAME));
    }

    protected Source getStylesheet(TransformerFactory transformerFactory, HttpServletRequest httpServletRequest, Source source, ApplyXSLTListener applyXSLTListener) throws ApplyXSLTException {
        try {
            String string = ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getXSLRequestURL(httpServletRequest);
            if (string != null) {
                applyXSLTListener.out.println("Parsing XSL Stylesheet Document from request parameter: " + string);
            } else {
                SAXTransformerFactory sAXTransformerFactory;
                Source source2;
                if (!this.useDefaultTemplates && (source2 = (sAXTransformerFactory = (SAXTransformerFactory)transformerFactory).getAssociatedStylesheet(source, this.getMedia(httpServletRequest), null, null)) != null) {
                    applyXSLTListener.out.println("Parsing XSL Stylesheet from XML document stylesheet PI.");
                    return source2;
                }
                string = this.ourDefaultParameters.getXSLurl(null);
                if (string != null) {
                    applyXSLTListener.out.println("Parsing XSL Stylesheet Document from configuration: " + string);
                    this.useDefaultTemplates = true;
                }
            }
            return new StreamSource(string);
        }
        catch (IOException iOException) {
            throw new ApplyXSLTException(iOException, 404);
        }
        catch (Exception exception) {
            throw new ApplyXSLTException(exception, 500);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        CURRENTDIR = ROOT != null ? String.valueOf(ROOT) + FS + "servlets" + FS : String.valueOf(System.getProperty("user.dir")) + FS;
        this.setDefaultParameters(servletConfig);
        this.setMediaProps(servletConfig.getInitParameter("mediaURL"));
        String string = servletConfig.getInitParameter("xslURL");
        try {
            if (string != null && string.length() > 0) {
                this.compileXSL(string);
            }
        }
        catch (Exception exception) {}
    }

    public void process(TransformerFactory transformerFactory, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, SAXException {
        boolean bl = this.ourDefaultParameters.isDebug(httpServletRequest);
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        ApplyXSLTListener applyXSLTListener = new ApplyXSLTListener();
        applyXSLTListener.out.println("debug is " + bl);
        Source source = null;
        Source source2 = null;
        try {
            source = this.getDocument(httpServletRequest, applyXSLTListener);
            if (source == null) {
                throw new ApplyXSLTException("getDocument() returned null", new NullPointerException(), 404);
            }
        }
        catch (ApplyXSLTException applyXSLTException) {
            applyXSLTException.appendMessage(String.valueOf(EOL) + "getDocument() resulted in ApplyXSLTException" + EOL + applyXSLTListener.getMessage());
            if (bl) {
                this.writeLog(applyXSLTException);
            }
            this.displayException(httpServletResponse, applyXSLTException, bl);
            source = null;
        }
        if (source != null) {
            Object object;
            try {
                source2 = this.getStylesheet(transformerFactory, httpServletRequest, source, applyXSLTListener);
                if (source2 == null) {
                    throw new ApplyXSLTException("getStylesheet() returned null", new NullPointerException(), 404);
                }
                source = this.getDocument(httpServletRequest, applyXSLTListener);
            }
            catch (ApplyXSLTException applyXSLTException) {
                applyXSLTException.appendMessage(String.valueOf(EOL) + "getStylesheet() resulted in ApplyXSLTException" + EOL + applyXSLTListener.getMessage());
                if (bl) {
                    this.writeLog(applyXSLTException);
                }
                this.displayException(httpServletResponse, applyXSLTException, bl);
                source2 = null;
            }
            if (this.useDefaultTemplates) {
                try {
                    applyXSLTListener.out.println("Using default templates");
                    if (this.defaultTemplates == null) {
                        applyXSLTListener.out.println("Must recompile default templates");
                        this.defaultTemplates = transformerFactory.newTemplates(source2);
                    }
                    object = this.defaultTemplates.newTransformer();
                    String string = null;
                    string = this.getContentType(this.defaultTemplates);
                    httpServletResponse.setContentType(string);
                    if (object instanceof TransformerImpl) {
                        TransformerImpl transformerImpl = (TransformerImpl)object;
                        transformerImpl.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(httpServletRequest));
                    }
                    this.setStylesheetParams((Transformer)object, httpServletRequest);
                    ((Transformer)object).transform(source, new StreamResult((OutputStream)httpServletResponse.getOutputStream()));
                    if (bl) {
                        this.writeLog(applyXSLTListener.getMessage(), 200);
                    }
                }
                catch (Exception exception) {
                    ApplyXSLTException applyXSLTException = new ApplyXSLTException("Exception occurred during Transformation:" + EOL + applyXSLTListener.getMessage() + EOL + exception.getMessage(), exception, 500);
                    if (bl) {
                        this.writeLog(applyXSLTException);
                    }
                    this.displayException(httpServletResponse, applyXSLTException, bl);
                }
            } else if (source != null && source2 != null) {
                try {
                    applyXSLTListener.out.println("Performing transformation...");
                    object = transformerFactory.newTemplates(source2);
                    Transformer transformer = object.newTransformer();
                    try {
                        String string = null;
                        string = this.getContentType((Templates)object);
                        httpServletResponse.setContentType(string);
                        if (transformer instanceof TransformerImpl) {
                            TransformerImpl transformerImpl = (TransformerImpl)transformer;
                            transformerImpl.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(httpServletRequest));
                        }
                        this.setStylesheetParams(transformer, httpServletRequest);
                        transformer.transform(source, new StreamResult((OutputStream)httpServletResponse.getOutputStream()));
                        if (bl) {
                            this.writeLog(applyXSLTListener.getMessage(), 200);
                        }
                    }
                    catch (Exception exception) {
                        ApplyXSLTException applyXSLTException = new ApplyXSLTException("Exception occurred during Transformation:" + EOL + applyXSLTListener.getMessage() + EOL + exception.getMessage(), exception, 500);
                        if (bl) {
                            this.writeLog(applyXSLTException);
                        }
                        this.displayException(httpServletResponse, applyXSLTException, bl);
                    }
                }
                catch (Exception exception) {
                    ApplyXSLTException applyXSLTException = new ApplyXSLTException("Exception occurred during ctor/Transformation:" + EOL + applyXSLTListener.getMessage() + EOL + exception.getMessage(), exception, 500);
                    if (bl) {
                        this.writeLog(applyXSLTException);
                    }
                    this.displayException(httpServletResponse, applyXSLTException, bl);
                }
            }
            if (bl) {
                l = System.currentTimeMillis() - l;
                this.writeLog("  No Conflict Warnings = " + this.ourDefaultParameters.isNoCW(httpServletRequest) + "  Transformation time: " + l + " ms", 200);
            }
        }
    }

    protected void setDefaultParameters(ServletConfig servletConfig) {
        this.ourDefaultParameters = new DefaultApplyXSLTProperties(servletConfig);
    }

    protected void setMediaProps(String string) {
        block9: {
            block8: {
                if (string == null) break block8;
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        uRL = new URL("file", "", String.valueOf(CURRENTDIR) + string);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.writeLog("Unable to find the media properties file based on parameter 'mediaURL' = " + string, 202, malformedURLException2);
                        uRL = null;
                    }
                }
                if (uRL == null) break block9;
                try {
                    this.ourMediaProps = new OrderedProps(uRL.openStream());
                }
                catch (IOException iOException) {
                    this.writeLog("Exception occurred while opening media properties file: " + string + ".  Media table may be invalid.", 202, iOException);
                }
                break block9;
            }
            String string2 = String.valueOf(CURRENTDIR) + "media.properties";
            try {
                this.ourMediaProps = new OrderedProps(new FileInputStream(string2));
            }
            catch (IOException iOException) {
                this.writeLog("Default media properties file " + string2 + " not found.", 202, iOException);
            }
        }
    }

    public void setStylesheetParams(Transformer transformer, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                String[] stringArray = httpServletRequest.getParameterValues(string);
                if (stringArray == null) continue;
                transformer.setParameter(string, new XString(stringArray[0]));
            }
            catch (Exception exception) {}
        }
        try {
            transformer.setParameter("servlet-RemoteAddr", new XString(httpServletRequest.getRemoteAddr()));
        }
        catch (Exception exception) {}
        try {
            transformer.setParameter("servlet-RemoteHost", new XString(httpServletRequest.getRemoteHost()));
        }
        catch (Exception exception) {}
        try {
            transformer.setParameter("servlet-RemoteUser", new XString(httpServletRequest.getRemoteUser()));
        }
        catch (Exception exception) {}
    }

    protected URLConnection toAcceptLanguageConnection(URL uRL, HttpServletRequest httpServletRequest) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Accept-Language", httpServletRequest.getHeader("Accept-Language"));
        return uRLConnection;
    }

    protected void writeLog(String string, int n) {
        this.log("HTTP Status Code: " + n + " - " + string);
    }

    protected void writeLog(String string, int n, Throwable throwable) {
        if (throwable == null) {
            this.writeLog(string, n);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            System.out.println("Exception is " + throwable.getClass().getName());
            throwable.printStackTrace(printWriter);
            this.log("HTTP Status Code: " + n + " - " + string + EOL + byteArrayOutputStream.toString());
        }
    }

    protected void writeLog(ApplyXSLTException applyXSLTException) {
        this.writeLog(applyXSLTException.getMessage(), applyXSLTException.getStatusCode(), applyXSLTException.getException());
    }
}

