function lterm=add_lastterm(Sb,So,yy,rindice,op,model,H,dir)

Ni=length(rindice);
Nc=set_numberofcombinations(rindice,model);

tmpadjS=Sb(rindice,:);
tmpadjS=repmat(tmpadjS,[2,1]);
tmpadjS(Ni+1:end,:)=-tmpadjS(Ni+1:end,:);

if(strcmp(dir,'horizontal')==1)
    index=(yy-1)*op.xdim+op.xdim;
    Snei=extract_neigboring(So,index,H);
    
    if(yy==1)    
        if(strcmp(model,'TICA')==1)
            tmpadjS=Sb(rindice,:);
        end
    
        tmpS=repmat(Sb(1,:),[Nc,1]);
        lterm=compute_comb(tmpS,tmpadjS,model);
        
    elseif((1<yy)&&(yy<op.ydim))
        if(op.toponum==8)
            % upper left component
            term1=compute_comb(repmat(Snei(1,:),[Nc,1]),tmpadjS,model);        
            % upper component
            term2=compute_comb(repmat(Snei(2,:),[Nc,1]),tmpadjS,model);        
            % upper right component
            term3=compute_comb(repmat(Snei(3,:),[Nc,1]),tmpadjS,model);
            % right component
            term4=compute_comb(repmat(Snei(5,:),[Nc,1]),tmpadjS,model);        
            % below right component
            term5=compute_comb(repmat(Snei(8,:),[Nc,1]),tmpadjS,model);

            lterm=term1+term2+term3+term4+term5;
        else
            % upper component
            term1=compute_comb(repmat(Snei(1,:),[Nc,1]),tmpadjS,model);       
            % right component
            term2=compute_comb(repmat(Snei(3,:),[Nc,1]),tmpadjS,model);        

            lterm=term1+term2;            
        end
    else               
        if(op.toponum==8)        
            % upper left component
            term1=compute_comb(repmat(Snei(1,:),[Nc,1]),tmpadjS,model);
            % upper component
            term2=compute_comb(repmat(Snei(2,:),[Nc,1]),tmpadjS,model);        
            % upper right component
            term3=compute_comb(repmat(Snei(3,:),[Nc,1]),tmpadjS,model);
            % right component
            term4=compute_comb(repmat(Snei(5,:),[Nc,1]),tmpadjS,model);        
            % below left component
            term5=compute_comb(repmat(Snei(6,:),[Nc,1]),tmpadjS,model);
            % below component
            term6=compute_comb(repmat(Snei(7,:),[Nc,1]),tmpadjS,model);        
            % below right component
            term7=compute_comb(repmat(Snei(8,:),[Nc,1]),tmpadjS,model);

            lterm=term1+term2+term3+term4+term5+term6+term7;
        else
            % upper component
            term1=compute_comb(repmat(Snei(1,:),[Nc,1]),tmpadjS,model);        
            % below component
            term2=compute_comb(repmat(Snei(4,:),[Nc,1]),tmpadjS,model);
            % right component
            term3=compute_comb(repmat(Snei(3,:),[Nc,1]),tmpadjS,model);        

            lterm=term1+term2+term3;                        
        end
    end
elseif(strcmp(dir,'vertical')==1)
    index=(op.ydim-1)*op.xdim+yy;

    Snei=extract_neigboring(So,index,H);
                
     if(yy==1)
        if(op.toponum==8)
            % below left component
            term1=compute_comb(repmat(Snei(6,:),[Nc,1]),tmpadjS,model);
            % below component
            term2=compute_comb(repmat(Snei(7,:),[Nc,1]),tmpadjS,model);
            % below right component
            term3=compute_comb(repmat(Snei(8,:),[Nc,1]),tmpadjS,model);

            lterm=term1+term2+term3;
        else
            % below right component
            term1=compute_comb(repmat(Snei(4,:),[Nc,1]),tmpadjS,model);

            lterm=term1;
        end
     else
        if(op.toponum==8)
            % upper left component
            term1=compute_comb(repmat(Snei(1,:),[Nc,1]),tmpadjS,model);
            % left component
            term2=compute_comb(repmat(Snei(4,:),[Nc,1]),tmpadjS,model);
            % below left component
            term3=compute_comb(repmat(Snei(6,:),[Nc,1]),tmpadjS,model);
            % below component
            term4=compute_comb(repmat(Snei(7,:),[Nc,1]),tmpadjS,model);
            % below right component
            term5=compute_comb(repmat(Snei(8,:),[Nc,1]),tmpadjS,model);

            lterm=term1+term2+term3+term4+term5;
        else
            % left component
            term1=compute_comb(repmat(Snei(2,:),[Nc,1]),tmpadjS,model);
            % below component
            term2=compute_comb(repmat(Snei(4,:),[Nc,1]),tmpadjS,model);
            
            lterm=term1+term2;
        end
     end
else
    error('Specify the direction you want to optimize.\n');
end
