%
% This code visualizes the performance matrices for all the methods and
% the cases of sources.
%

clear all;

addpath('../');

rpath='../../result/artdata/';

tt=1; % trial number

for ii=1:3        
    if(ii==1)
        method='ICA';
    elseif(ii==2)
        method='TICA';
    else
        method='CTA';
    end
    
    for jj=1:4
        sfname=[rpath method '/case' num2str(jj) 'source' method num2str(tt) '.mat'];
        load(sfname);
        
        P=W*whiteningMatrix*A;
        P=normalizebymax(P);
        
        figure(1);
        subplot(3,4,(ii-1)*4+jj);
        imagesc(P,[-1,1]);
        axis square;
        if(ii==1)
            if(jj==1)
                title('case 1');
            elseif(jj==2)
                title('case 2');
            elseif(jj==3)
                title('case 3');
            else
                title('case 4');
            end
        end
        
        if(jj==1)
            if(ii==1)
                ylabel('ICA');
            elseif(ii==2)
                ylabel('TICA');
            else
                ylabel('CTA');
            end
        end
    end 
end