clear all;

addpath('../');
rpath='../../result/artdata/';

dim=10;
N=5;

I=eye(dim);

randTind=zeros(N,1);
randAind=zeros(N,1);

for ii=1:N
    tmp=I(randperm(size(I,1)),:);
    rmat=randn(dim);
    
    randTind(ii)=compute_Tindex(tmp);
    randAind(ii)=compute_Amariindex(rmat);
end

snum=4;

CASE = {'case1', 'case2', 'case3', 'case4'};

for jj=1:snum
    Tindice=randTind;
    Aindice=randAind;

    for ii=1:3
        if(ii==1)
            method='ICA';
        elseif(ii==2)
            method='TICA';
        else
            method='CTA';
        end
        
        sfname=[rpath 'index/case' num2str(jj) 'source' method...
            'index_result.mat'];            
        load(sfname);
        
        Tindice=[Tindice Tind];
        Aindice=[Aindice Aind];
    end
    
    METHOD = {'RAND', 'ICA', 'TICA', 'CTA'};
    font='times';
    figure(1); subplot(2,2,jj); hold on
    boxplot(Aindice);
    set(gca, 'XTick', 1:4, 'XTickLabel', METHOD);
    ylabel('Amari index','fontname',font,'fontsize',14);
    title(CASE(jj),'fontname',font,'fontsize',14);
    axis([0 5 -10 300]); axis square; box on;
    set(gca,'fontname',font,'fontsize',10);

    font='times';
    figure(2); subplot(2,2,jj); hold on
    boxplot(Tindice);
    set(gca, 'XTick', 1:4, 'XTickLabel', METHOD);
    ylabel('topography index','fontname',font,'fontsize',14);
    title(CASE(jj),'fontname',font,'fontsize',14);
    axis([0 5 0 1.05]); axis square; box on;
    set(gca,'fontname',font,'fontsize',10);
end