function Tind=compute_Tindex(P)

% computing topography index.

dim=size(P,1);

Tind=0;

tmpTindmax=zeros(dim,1);

for ii=1:2

    if(ii==1)
        normP=normalizationP(P,'row');
    else
        normP=normalizationP(P,'col');
    end

    tmpP=normP(:,end:-1:1);

    for jj=1:dim
        lP=circshift(normP,[0,jj-1]);
        rP=circshift(tmpP,[0,jj-1]);
        
        tmp1=sum(diag(abs(lP)));
        tmp2=sum(diag(abs(rP)));
    
        tmpTindmax(jj)=max(tmp1,tmp2)/dim;
    end

    Tind=Tind+max(tmpTindmax);
end

Tind=0.5*Tind;