clear all;

addpath('../');

samples=10000;
dim=10;

op.components=dim;
op.xdim=dim;
op.ydim=1;
op.covval=0.4;
op.lambda=1.0;
op.toponum=2;
op.f='CTA';
op.ica=1;
op.ordersign=1;
op.est=1;
op.length=5000;

parametererror(op);

H=topographyMatrix(op);

A=randn(dim,op.components);
S=artificialsources(H,op,samples,'case4');
X=A*S;

[X,whiteningMatrix, dewhiteningMatrix] = whitening(X);

rng('shuffle');
Winit=randn(op.components,dim);

W=estimation(Winit,X,H,op);
            
P=W*whiteningMatrix*A; P=normalizebymax(P);

figure(1); imagesc(P,[-1,1]); axis square;