clear all;

addpath('../');

samples=10000;
dim=10;

op.components=dim;
op.xdim=dim;
op.ydim=1;
op.covval=0.4;
op.lambda=1.0;
op.toponum=2;

op.length=5000;

H=topographyMatrix(op);

N=1;
for tt=1:N
    A=randn(dim,op.components);
    
    for ss=1:4
        cname=['case' num2str(ss)];
        
        S=artificialsources(H,op,samples,cname);
        X=A*S;

        [X,whiteningMatrix, dewhiteningMatrix] = whitening(X);

        Winit=randn(op.components,dim);

        for ii=1:3
            if(ii==1)
                op.ica=1;
                op.ordersign=0;
                op.est=0;
                op.f='ICA';
            else
                op.ica=1;
                op.ordersign=1;
                op.est=1;
                if(ii==2)
                    op.f='TICA';
                else
                    op.f='CTA';
                end
            end
            
            fprintf(['----------------------------------------\n'...
                op.f ' estimation to case' num2str(ss) '\n'...
                '----------------------------------------\n\n']);
            
            parametererror(op);
            W=estimation(Winit,X,H,op);
            
            fname=['../../result/artdata/' op.f '/' cname 'source' op.f num2str(tt) '.mat'];
            save(fname,'W','whiteningMatrix','dewhiteningMatrix','A');
        end
    
        fname=['../../result/artdata/source/' cname 'source' num2str(tt) '.mat'];
        save(fname,'S');
    end
end
