function S=artificialsources(H,op,samples,Scase)
 
if(nargin~=4)
    error('Check the number of arguments.\n');
end

fprintf('generating %s sources.\n', Scase);

toponum=size(H,3);
hnum = round(toponum/2);

% Covariance
C=sum(abs(H),3)-(toponum)*eye(op.components);
C=op.covval*C+eye(op.components);

if (strcmp(Scase,'case1')==1)
    V=randn(op.components,samples);    
    
    U=exprnd(1,op.components,samples);
elseif (strcmp(Scase,'case2')==1)
    V=randn(op.components,samples);    

    tmpH=sum(abs(H(:,:,hnum+1:end)),3)-(hnum-1)*eye(op.components);    
    U=tmpH*exprnd(1,op.components,samples);
elseif (strcmp(Scase,'case3')==1)
    V=mvnrnd(zeros(op.components,1),C,samples)';    

    U=exprnd(1,op.components,samples);
elseif (strcmp(Scase,'case4')==1)
    V=mvnrnd(zeros(op.components,1),C,samples)';    
    
    tmpH=sum(abs(H(:,:,hnum+1:end)),3)-(hnum-1)*eye(op.components);    
    U=tmpH*exprnd(1,op.components,samples);
else
    error('Specify the case of data.\n');
end

S=U.*V;
S=centering(S);
S=normalizevar(S);