clear all;

addpath('../');
addpath('makeCCoutputs/');

rpath='../../result/complex_cell/';

samples=100000;

% reduced dimension
rdim=100;

% setting basic parameters 
op.components=rdim;
op.xdim=10;
op.ydim=10;
op.toponum=8;

% setting optimization paramters
op.ica=1;
op.ordersign=1;
op.est=1;
op.length=5000;
op.f='CTA';
op.lambda=1.0;

% Detecting setting error for parameters.
parametererror(op);

% creating topographic matrix.
H=topographyMatrix(op);

% complex cell outputs
dname=rpath;
% X and Xn are the outputs of simulated CC cells to natural images and noises.
[X,Xn,T]=makeCCoutputs(samples,dname);

% sort of input data
input='NatIm';

Winit=randn(op.components,rdim);

% file name
fname=[rpath op.f 'toponum' num2str(op.toponum)];
switch input
    case 'NatIm'
        [W,whiteningMatrix,dewhiteningMatrix]=CCestimation(X,Winit,H,rdim,op);
        
        fname=[fname 'NatIm.mat'];
        save(fname,'W','whiteningMatrix','dewhiteningMatrix','T','op');
    case 'Noise'        
        [W,whiteningMatrix,dewhiteningMatrix]=CCestimation(Xn,Winit,H,rdim,op);

        fname=[fname 'Noise.mat'];
        save(fname,'W','whiteningMatrix','dewhiteningMatrix','T','op');
    case 'both'
        
        fname=[rpath op.f 'toponum' num2str(op.toponum)];

         % Natural image
         [W,whiteningMatrix,dewhiteningMatrix]=CCestimation(X,Winit,H,rdim,op);
        
         fname=[fname 'NatIm.mat'];
         save(fname,'W','whiteningMatrix','dewhiteningMatrix','T','op');
            
         fname=[rpath op.f 'toponum' num2str(op.toponum)];

         % Noise
         [W,whiteningMatrix,dewhiteningMatrix]=CCestimation(Xn,Winit,H,rdim,op);

         fname=[fname 'Noise.mat'];
         save(fname,'W','whiteningMatrix','dewhiteningMatrix','T','op');
    otherwise,
        error('No such an option');
end