function S=getdata( samples, winsize )
% getdata - gathers image patches from our images
%
% SYNTAX:
% getdata( samples, winsize );
%
% INPUT variables:
% samples            total number of patches to take
% winsize            patch width in pixels
%
% OUTPUT variables:
% X (global)         image patches in the columns
%
% (The output is put in a global to save memory as the data
% set can be quite large.)
%

% How many images are there?
imagenum = 13;

% This will hold the patches
S=zeros(winsize^2,samples);
totalsamples = 0;

% Don't sample too close to the edges
BUFF=4;

% Step through the images
for i=1:imagenum,

  % Display progress
  fprintf('[%d/%d]',i,imagenum);
  
  % Load an image
  I = double(imread(['../../data/' num2str(i) '.tiff']));
  I = I-mean(mean(I));
  I = I/sqrt(mean(mean(I.^2)));
  
  % Determine how many patches to take
  getsample = floor(samples/imagenum);
  if i==imagenum, getsample = samples-totalsamples; end
  
  % Extract patches at random from this image to make data vector X
  for j=1:getsample
    r=BUFF+ceil((size(I,1)-winsize-2*BUFF)*rand);
    c=BUFF+ceil((size(I,2)-winsize-2*BUFF)*rand);
    totalsamples = totalsamples + 1;
    S(:,totalsamples) = ...
        reshape( I(r:r+winsize-1,c:c+winsize-1),winsize^2,1);
  end
  
end  

fprintf('\n');

return;

