function [X,Xn,T]=makeCCoutputs(samples,dname)
% This code creates the outputs of complex cells. 

if(nargin<2)
    opcase='naturalimages';
    fname='naturalimages';
end

global RF iconsize iconthick;

iconsize = [];
iconthick = [];

winsize=24;

RF.random = 0; 
RF.dirs = (0:3)*pi/4; 
RF.pos = linspace(-0.35,0.35,6); 
RF.freqs = 11*pi; 
RF.length = 1.5;

% Gabor filters.
T=handmadebasis(winsize);

for ii=1:2
    if(ii==1)
        D=getdata(samples,winsize);
        
        % Covariance of natural image pathces.
        Cn=cov(D');
        
        fname=[dname 'NatIm.mat'];
    else
        Dn=mvnrnd(zeros(winsize^2,1),Cn,samples)';
        
        fname=[dname 'Noise.mat'];
    end

    % Linear Filter Response
    if(ii==1);
        LRes =T.W*D;
    else
        LRes =T.W*Dn;
    end
    
    % Squaring
    DLRes=LRes.^2;
    LRes=[];

    % Complex cell pooling
    if(ii==1);
        X=sparse(T.H)*DLRes;
        
        save(fname,'X','D','Cn','T');
    else
        Xn=sparse(T.H)*DLRes;

        save(fname,'Xn','Dn','T');
    end
end