function oneterm=compute_comb(S,adjS,model)

if(nargin~=3)
    narginerror;
end

if(strcmp(model,'CTA')==1)
    oneterm=mean(log(cosh(S-adjS)),2);
elseif(strcmp(model,'TICA')==1)
    epsi=0.1;
    oneterm=mean((epsi+S.^2+adjS.^2).^(0.5),2);
else
    error('Check the name of model.\n');
end

oneterm=oneterm';