function [cost,grad]=costgrad_CTA(W,X,H,op)

if(nargin~=4)
    error('Check the number of arguments.\n');
end

if(size(W,2)<2)
    W=reshape(W,[op.components,size(X,1)]);
end

N=size(X,2);

S=W*X;

grad=tanh(S);
cost=log(cosh(S));

for ii=1:op.toponum
    difS=H(:,:,ii)*S;
    grad=grad+op.lambda*tanh(difS);
        
    if(round(op.toponum/2)<ii);
        cost=cost+op.lambda*log(cosh(difS));
    end
end

grad=grad*X'/N-inv(W');
cost=mean(sum(cost))-log(abs(det(W)));

grad=grad(:);